/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.service.executor.LocalServiceMessage;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.engine.NoServiceHandlerException;
import com.ygsoft.ecp.service.executor.engine.ServiceContext;
import com.ygsoft.ecp.service.executor.engine.ServiceContextHelper;
import com.ygsoft.ecp.service.executor.engine.ServiceDispatcher;
import com.ygsoft.ecp.service.executor.engine.ServiceExecutor;
import com.ygsoft.ecp.service.executor.engine.ServiceFilter;
import com.ygsoft.ecp.service.executor.engine.ServiceHandler;
import com.ygsoft.ecp.service.executor.filter.Filter;
import com.ygsoft.ecp.service.executor.filter.FilterUtils;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceDispatcher
implements ServiceDispatcher {
    static Log log = LogFactory.getLog(DefaultServiceDispatcher.class);
    private Map<String, ServiceHandler> serviceHandlers = new HashMap<String, ServiceHandler>();
    private List<ServiceFilter> filters = new ArrayList<ServiceFilter>();
    private ServiceExecutor serviceExecutor;

    @Override
    public ServiceMessage dispatch(ServiceMessage message) {
        ServiceMessage result;
        block4: {
            result = null;
            try {
                FilterChain filterChain = new FilterChain(this.filters, this);
                result = filterChain.process(message);
            }
            catch (Throwable t) {
                log.error((Object)("Error happened when dispatching service message:" + message.getServiceCode()));
                if (t instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)t).getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                }
                if (!(t instanceof RuntimeException)) break block4;
                throw (RuntimeException)t;
            }
        }
        return result;
    }

    @Override
    public ServiceMessage doProcess(ServiceMessage message) throws Throwable {
        ServiceMessage serviceMessage;
        block5: {
            String serviceType = message.getServiceType();
            ServiceHandler serviceHandler = this.getServiceHandler(serviceType);
            ServiceContext serviceContext = ServiceContext.getContext();
            boolean newServiceContext = false;
            if (serviceContext == null) {
                serviceContext = ServiceContextHelper.buildServiceContext(message);
                newServiceContext = true;
            }
            try {
                serviceMessage = this.serviceExecutor.execute(message, message.getTimeout(), serviceHandler);
                Object var8_8 = null;
                if (!newServiceContext) break block5;
            }
            catch (Exception e) {
                try {
                    log.error((Object)"Exception happened when do processing using service engine", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var8_9 = null;
                        if (!newServiceContext) break block6;
                        ServiceContextHelper.cleanServiceContext();
                    }
                    throw throwable;
                }
            }
            ServiceContextHelper.cleanServiceContext();
        }
        return serviceMessage;
    }

    public Map<String, ServiceHandler> getServiceHandlers() {
        return this.serviceHandlers;
    }

    public void setServiceHandlers(Map<String, ServiceHandler> newserviceHandlers) {
        this.serviceHandlers = newserviceHandlers;
    }

    public ServiceHandler getServiceHandler(String serviceType) {
        ServiceHandler serviceHandler = this.serviceHandlers.get(serviceType);
        if (serviceHandler == null) {
            log.error((Object)("No service handler specified for service type:" + serviceType));
            throw new NoServiceHandlerException(serviceType);
        }
        return serviceHandler;
    }

    public List<ServiceFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ServiceFilter> newfilters) {
        this.filters = newfilters;
    }

    public ServiceExecutor getServiceExecutor() {
        return this.serviceExecutor;
    }

    public void setServiceExecutor(ServiceExecutor newserviceExecutor) {
        this.serviceExecutor = newserviceExecutor;
    }

    static class FilterEntry {
        private ServiceFilter serviceFilter;
        private ServiceMessage message;

        public FilterEntry(ServiceFilter newserviceFilter, ServiceMessage newmessage) {
            this.serviceFilter = newserviceFilter;
            this.message = newmessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterChain {
        private List<ServiceFilter> filters;
        private DefaultServiceDispatcher dispatcher;
        private Stack<FilterEntry> chain = new Stack();

        public FilterChain(List<ServiceFilter> newfilters, DefaultServiceDispatcher newdispatcher) {
            this.filters = newfilters;
            this.dispatcher = newdispatcher;
        }

        public ServiceMessage process(ServiceMessage message) throws Throwable {
            ServiceMessage result = null;
            try {
                String serviceCode;
                Class target = null;
                String actionName = null;
                Object obj = null;
                if ("local".equals(message.getServiceType())) {
                    if (message instanceof LocalServiceMessage) {
                        obj = ((LocalServiceMessage)message).getObject();
                        actionName = ((LocalServiceMessage)message).getMethod().getName();
                    } else {
                        String interfaceName = message.getServiceCode();
                        if (interfaceName != null) {
                            obj = OSGiUtil.getService(interfaceName);
                            actionName = message.getServiceName();
                        }
                    }
                } else if ("default".equals(message.getServiceType()) && (serviceCode = message.getServiceCode()) != null) {
                    target = ClassUtil.getClass(message.getServiceCode());
                    actionName = message.getServiceName();
                }
                if (obj != null) {
                    target = AopUtils.isAopProxy((Object)obj) ? AopUtils.getTargetClass((Object)obj) : obj.getClass();
                }
                ServiceMessage processedMessage = this.preProcess(message);
                ArrayList<Filter> chains = new ArrayList();
                if (target != null) {
                    chains = FilterUtils.getFilterChain(target);
                }
                if (chains.isEmpty()) {
                    result = this.dispatcher.doProcess(processedMessage);
                } else {
                    ArrayList<Filter> arounds = new ArrayList<Filter>();
                    if (!this.preFilter(actionName, message, chains, arounds)) {
                        return message;
                    }
                    result = this.dispatcher.doProcess(processedMessage);
                    message.setContent(result.getContent());
                    if (!this.postFilter(actionName, message, chains, arounds)) {
                        return message;
                    }
                    result.setContent(message.getContent());
                }
                result = this.postProcess(result);
            }
            catch (Throwable t) {
                result = this.exceptionProcess(t);
            }
            return result;
        }

        protected boolean preFilter(String actionName, ServiceMessage message, List<Filter> chains, List<Filter> arounds) throws Exception {
            boolean chainBroken = false;
            try {
                for (Filter filter : chains) {
                    if (!filter.canInvoke(actionName)) continue;
                    boolean ret = filter.beforeInvoke(message);
                    if (ret && filter.getAroundFilter() != null) {
                        arounds.add(filter);
                    }
                    if (ret) continue;
                    chainBroken = true;
                    break;
                }
            }
            catch (Exception ex) {
                this.afterInvokeAroundFilters(arounds, message);
                throw ex;
            }
            if (chainBroken) {
                this.afterInvokeAroundFilters(arounds, message);
                return false;
            }
            return true;
        }

        protected boolean postFilter(String actionName, ServiceMessage message, List<Filter> chains, List<Filter> arounds) throws Exception {
            boolean result = this.afterInvokeAroundFilters(arounds, message);
            if (result) {
                for (Filter filter : chains) {
                    if (!filter.canInvoke(actionName) || filter.getAfterFilter() == null) continue;
                    filter.afterInvoke(message);
                }
            }
            return result;
        }

        protected boolean afterInvokeAroundFilters(List<Filter> arounds, ServiceMessage message) throws Exception {
            boolean result = true;
            Exception exception = null;
            for (int i = arounds.size() - 1; i >= 0; --i) {
                try {
                    Filter filter = arounds.get(i);
                    boolean ret = filter.afterInvoke(message);
                    if (ret) continue;
                    result = false;
                    continue;
                }
                catch (Exception ex) {
                    if (exception != null) continue;
                    exception = ex;
                }
            }
            if (exception != null) {
                throw exception;
            }
            return result;
        }

        protected ServiceMessage preProcess(ServiceMessage message) throws Throwable {
            for (ServiceFilter filter : this.filters) {
                FilterEntry entry = new FilterEntry(filter, message);
                this.chain.push(entry);
                message = filter.before(message);
            }
            return message;
        }

        protected ServiceMessage postProcess(ServiceMessage result) throws Throwable {
            while (!this.chain.isEmpty()) {
                FilterEntry entry = this.chain.pop();
                result = entry.serviceFilter.after(entry.message, result);
            }
            return result;
        }

        protected ServiceMessage exceptionProcess(Throwable t) throws Throwable {
            ServiceMessage result = null;
            if (this.chain.isEmpty()) {
                throw t;
            }
            try {
                FilterEntry entry = this.chain.pop();
                result = entry.serviceFilter.doCatch(entry.message, t);
                result = this.postProcess(result);
            }
            catch (Throwable e) {
                result = this.exceptionProcess(e);
            }
            if (this.chain.isEmpty()) {
                throw t;
            }
            return result;
        }
    }
}

