/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.engine.ServiceFilter;
import com.ygsoft.ecp.service.executor.log.LogStoreBuilder;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.ServiceMonitor;
import com.ygsoft.ecp.service.tool.ExceptionUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.SysPropUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultServiceFilter
implements ServiceFilter {
    private static final IEcpLog LOG = EcpLogFactory.getSystemLog(DefaultServiceFilter.class);
    private static final String AOP_LOG_FLAG = "ygsoft.aop.log";
    public static final BlockingQueue<ServiceMonitor> MESSAGE_QUEUE = new LinkedBlockingQueue<ServiceMonitor>();
    private static ServiceFilter filter = null;
    private static AtomicBoolean hasInitServiceFilter = new AtomicBoolean(false);

    private static ServiceFilter getServiceFilter() {
        if (hasInitServiceFilter.compareAndSet(false, true)) {
            filter = OSGiUtil.getSpringBean(ServiceFilter.class);
        }
        return filter;
    }

    public ServiceMessage before(ServiceMessage request) throws Throwable {
        String serviceCode = request.getServiceCode();
        request.set("ST_TIME", System.currentTimeMillis());
        if (serviceCode != null) {
            ServiceFilter filter = DefaultServiceFilter.getServiceFilter();
            if (filter != null) {
                filter.before(request);
            }
            StringBuilder sb = new StringBuilder();
            if (this.isAopLogEnable()) {
                sb.append(0).append("^S^77^").append((Object)serviceCode).append(".").append(request.getServiceName()).append("#begin");
                if (LOG.isInfoEnabled()) {
                    LOG.info(sb.toString());
                }
            }
        }
        return request;
    }

    private boolean isAopLogEnable() {
        return SysPropUtil.isTrue(AOP_LOG_FLAG);
    }

    public ServiceMessage after(ServiceMessage request, ServiceMessage response) throws Throwable {
        String serviceCode = request.getServiceCode();
        if (serviceCode != null) {
            ServiceFilter filter = DefaultServiceFilter.getServiceFilter();
            if (filter != null) {
                filter.after(request, response);
            }
            if (this.isAopLogEnable()) {
                Long stime = request.getLong("ST_TIME");
                long time = 0L;
                if (stime != null) {
                    time = System.currentTimeMillis() - stime;
                }
                if (LOG.isInfoEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(time).append("^S^77^").append((Object)serviceCode).append(".").append(request.getServiceName()).append("#end");
                    LOG.info(sb.toString());
                }
            }
            request.setContent(response.getContent());
            ServiceMonitor monitor = LogStoreBuilder.build(request);
            if (monitor != null) {
                MESSAGE_QUEUE.add(monitor);
            }
        }
        return response;
    }

    public ServiceMessage doCatch(ServiceMessage request, Throwable exception) throws Throwable {
        String serviceCode = request.getServiceCode();
        if (serviceCode != null) {
            ServiceFilter filter = DefaultServiceFilter.getServiceFilter();
            if (filter != null) {
                filter.doCatch(request, exception);
            }
            if (this.isAopLogEnable() && LOG.isErrorEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(0).append("^S^77^").append((Object)serviceCode).append(".").append(request.getServiceName()).append("#error");
                LOG.error(sb.toString());
            }
            request.setResultMsg(ExceptionUtil.getExceptionAllMessage(exception));
            ServiceMonitor monitor = LogStoreBuilder.build(request);
            if (monitor != null) {
                MESSAGE_QUEUE.add(monitor);
            }
        }
        throw exception;
    }
}

