/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.engine.ServiceContext;
import com.ygsoft.ecp.service.executor.engine.ServiceHandler;
import com.ygsoft.ecp.service.executor.engine.ThreadPoolExecutorAopSupport;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceExecution
implements Callable<ServiceMessage> {
    private ServiceMessage message;
    private ServiceHandler serviceHandler;
    private ServiceContext serviceContext;
    private Future<ServiceMessage> future;

    private void setTenant() {
        String tenantId = TokenHolder.INSTANCE.getTenantId();
        if (tenantId != null) {
            this.message.set("tenantId", tenantId);
        }
    }

    public ServiceExecution(ServiceMessage newmessage, ServiceHandler newserviceHandler, ServiceContext newserviceContext) {
        this.message = newmessage;
        this.serviceHandler = newserviceHandler;
        this.serviceContext = newserviceContext;
        ThreadPoolExecutorAopSupport.doBeforeDispatch(this.message.getProperties());
        this.setTenant();
    }

    @Override
    public ServiceMessage call() throws Exception {
        ServiceContext.setContext(this.serviceContext);
        return this.serviceHandler.service(this.message);
    }

    public Future<ServiceMessage> getFuture() {
        return this.future;
    }

    public void setFuture(Future<ServiceMessage> newfuture) {
        this.future = newfuture;
    }

    public ServiceMessage getMessage() {
        return this.message;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public int getExecutionId() {
        return this.message.hashCode();
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public boolean cancel(boolean newmayInterruptIfRunning) {
        return this.future.cancel(newmayInterruptIfRunning);
    }

    public int getPriority() {
        return this.message.getPriority();
    }
}

