/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.filter;

import com.ygsoft.ecp.service.datasource.DatasourceManager;
import com.ygsoft.ecp.service.datasource.SlaveDataSource;
import com.ygsoft.ecp.service.executor.filter.AfterFilter;
import com.ygsoft.ecp.service.executor.filter.AfterFilters;
import com.ygsoft.ecp.service.executor.filter.AroundFilter;
import com.ygsoft.ecp.service.executor.filter.AroundFilters;
import com.ygsoft.ecp.service.executor.filter.BeforeFilter;
import com.ygsoft.ecp.service.executor.filter.BeforeFilters;
import com.ygsoft.ecp.service.executor.filter.Filter;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterUtils {
    private static final Map<String, List<Filter>> CACHE = new ConcurrentHashMap<String, List<Filter>>();

    private static boolean isExistsBeforeFilter(List<Filter> filters, BeforeFilter beforeFilter) {
        for (Filter filter : filters) {
            if (filter.getBeforeFilter() == null || !filter.getBeforeFilter().service().equals(beforeFilter.service())) continue;
            return true;
        }
        return false;
    }

    private static boolean isExistsAfterFilter(List<Filter> filters, AfterFilter afterFilter) {
        for (Filter filter : filters) {
            if (filter.getAfterFilter() == null || !filter.getAfterFilter().service().equals(afterFilter.service())) continue;
            return true;
        }
        return false;
    }

    private static boolean isExistsAroundFilter(List<Filter> filters, AroundFilter aroundFilter) {
        for (Filter filter : filters) {
            if (filter.getAroundFilter() == null || !filter.getAroundFilter().service().equals(aroundFilter.service())) continue;
            return true;
        }
        return false;
    }

    public static List<Filter> getFilterChain(Class<?> clasz) throws Exception {
        if (CACHE.containsKey(clasz.getName())) {
            return CACHE.get(clasz.getName());
        }
        ArrayList<Filter> chains = new ArrayList<Filter>();
        for (Annotation annotation : clasz.getAnnotations()) {
            Filter filter;
            if (annotation instanceof BeforeFilter) {
                BeforeFilter beforeFilter = (BeforeFilter)annotation;
                if (FilterUtils.isExistsBeforeFilter(chains, beforeFilter)) continue;
                Filter filter2 = new Filter(clasz, beforeFilter);
                chains.add(filter2);
                continue;
            }
            if (annotation instanceof BeforeFilters) {
                BeforeFilters beforeFilters = (BeforeFilters)annotation;
                for (BeforeFilter beforeFilter : beforeFilters.value()) {
                    if (FilterUtils.isExistsBeforeFilter(chains, beforeFilter)) continue;
                    filter = new Filter(clasz, beforeFilter);
                    chains.add(filter);
                }
                continue;
            }
            if (annotation instanceof AfterFilter) {
                AfterFilter afterFilter = (AfterFilter)annotation;
                if (FilterUtils.isExistsAfterFilter(chains, afterFilter)) continue;
                Filter filter3 = new Filter(clasz, afterFilter);
                chains.add(filter3);
                continue;
            }
            if (annotation instanceof AfterFilters) {
                AfterFilters afterFilters = (AfterFilters)annotation;
                for (AfterFilter afterFilter : afterFilters.value()) {
                    if (FilterUtils.isExistsAfterFilter(chains, afterFilter)) continue;
                    filter = new Filter(clasz, afterFilter);
                    chains.add(filter);
                }
                continue;
            }
            if (annotation instanceof AroundFilter) {
                AroundFilter aroundFilter = (AroundFilter)annotation;
                if (FilterUtils.isExistsAroundFilter(chains, aroundFilter)) continue;
                Filter filter4 = new Filter(clasz, aroundFilter);
                chains.add(filter4);
                continue;
            }
            if (!(annotation instanceof AroundFilters)) continue;
            AroundFilters aroundFilters = (AroundFilters)annotation;
            for (AroundFilter aroundFilter : aroundFilters.value()) {
                if (FilterUtils.isExistsAroundFilter(chains, aroundFilter)) continue;
                filter = new Filter(clasz, aroundFilter);
                chains.add(filter);
            }
        }
        FilterUtils.scanMasterSlave(clasz, chains);
        if (chains.size() > 0) {
            CACHE.put(clasz.getName(), chains);
        } else {
            CACHE.put(clasz.getName(), Collections.EMPTY_LIST);
        }
        return chains;
    }

    private static void scanMasterSlave(Class<?> clasz, List<Filter> chains) {
        try {
            HashSet<String> actions;
            String slaveJndi;
            SlaveDataSource masterSalve;
            String masterSlave = null;
            for (Annotation annotation : clasz.getAnnotations()) {
                if (!(annotation instanceof SlaveDataSource)) continue;
                masterSalve = (SlaveDataSource)annotation;
                slaveJndi = FilterUtils.getJndi(masterSalve.domain(), masterSalve.affinityAccess());
                masterSlave = StringUtil.isEmpty(slaveJndi) ? "masterSlaveSwitch" : "masterSlaveSwitch#" + slaveJndi;
                break;
            }
            Map<String, Method> methods = ClassUtil.getMethods(clasz);
            Iterator<Method> it = methods.values().iterator();
            ConcurrentHashMap jndiMap = new ConcurrentHashMap();
            while (it.hasNext()) {
                Method m = it.next();
                masterSalve = m.getAnnotation(SlaveDataSource.class);
                if (masterSalve == null) continue;
                slaveJndi = FilterUtils.getJndi(masterSalve.domain(), masterSalve.affinityAccess());
                if (slaveJndi != null && slaveJndi.length() > 0) {
                    String key = "masterSlaveSwitch#" + slaveJndi;
                    if (jndiMap.containsKey(key)) {
                        ((Set)jndiMap.get(key)).add(m.getName());
                        continue;
                    }
                    HashSet<String> actions2 = new HashSet<String>();
                    actions2.add(m.getName());
                    jndiMap.put(key, actions2);
                    continue;
                }
                if (jndiMap.containsKey("masterSlaveSwitch")) {
                    ((Set)jndiMap.get("masterSlaveSwitch")).add(m.getName());
                    continue;
                }
                actions = new HashSet<String>();
                actions.add(m.getName());
                jndiMap.put("masterSlaveSwitch", actions);
            }
            if (!jndiMap.isEmpty()) {
                for (Map.Entry entry : jndiMap.entrySet()) {
                    String service = (String)entry.getKey();
                    AroundFilter aroundFilter = FilterUtils.createAroundFilter(service, (actions = (HashSet<String>)entry.getValue()).toArray(new String[0]), new String[0]);
                    if (FilterUtils.isExistsAroundFilter(chains, aroundFilter)) continue;
                    Filter filter = new Filter(clasz, aroundFilter);
                    chains.add(filter);
                }
            }
            if (StringUtil.isNotEmpty(masterSlave)) {
                if (jndiMap.containsKey(masterSlave)) {
                    Set actions3 = (Set)jndiMap.get(masterSlave);
                    AroundFilter aroundFilter = FilterUtils.createAroundFilter(masterSlave, new String[0], actions3.toArray(new String[0]));
                    Filter filter = new Filter(clasz, aroundFilter);
                    chains.add(filter);
                } else {
                    AroundFilter aroundFilter = FilterUtils.createAroundFilter(masterSlave, new String[0], new String[0]);
                    if (!FilterUtils.isExistsAroundFilter(chains, aroundFilter)) {
                        Filter filter = new Filter(clasz, aroundFilter);
                        chains.add(filter);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getJndi(String domain, boolean affinityAccess) {
        String jndi = XtcsUtil.getConfigValueFromXtcs(domain);
        if (affinityAccess) {
            if (StringUtil.isEmptyString(jndi)) {
                jndi = "fmismain";
            }
            jndi = DatasourceManager.INSTANCE.randomSlaveJndiName(jndi);
        }
        return jndi;
    }

    private static AroundFilter createAroundFilter(final String service, final String[] only, final String[] except) {
        try {
            return new AroundFilter(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                @Override
                public String service() {
                    return service;
                }

                @Override
                public String[] only() {
                    return only;
                }

                @Override
                public String[] except() {
                    return except;
                }

                @Override
                public String before() {
                    return "before";
                }

                @Override
                public String after() {
                    return "after";
                }
            };
        }
        catch (Exception e) {
            return null;
        }
    }
}

