/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.log;

import com.ygsoft.ecp.service.cache.IRedisService;
import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.executor.log.RedisClient;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.ServiceMonitor;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogStoreHandle {
    private IRedisService service;
    private DataSource dataSource;
    public static final LogStoreHandle INSTANCE = new LogStoreHandle();
    private static final IEcpLog LOG = EcpLogFactory.getSystemLog(LogStoreHandle.class);

    private LogStoreHandle() {
    }

    public void store(List<ServiceMonitor> messagestores) {
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                this.storeWithRedis(messagestores);
            } else {
                this.storeWithDB(messagestores);
            }
        } else {
            this.storeWithDB(messagestores);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeWithDB(List<ServiceMonitor> messagestores) {
        PreparedStatement stat;
        Connection conn;
        block8: {
            block7: {
                conn = null;
                stat = null;
                try {
                    try {
                        conn = this.getConnection();
                        if (conn == null) {
                            Object var8_4 = null;
                            break block7;
                        }
                        stat = conn.prepareStatement(MessageFormat.format("INSERT INTO {0}ECP_MONITOR_LOG(GID,S_ID,S_NAME,S_START,S_END,S_INPUT,S_OUTPUT,S_EXCEPTION,U_IP,U_NAME) VALUES (?,?,?,?,?,?,?,?,?,?)", this.getSchema()));
                        int size = 0;
                        for (ServiceMonitor message : messagestores) {
                            ++size;
                            stat.setString(NumberConst.ONE, message.getId());
                            stat.setString(NumberConst.TWO, message.getSid());
                            stat.setString(NumberConst.THREE, message.getSname());
                            stat.setLong(NumberConst.FOUR, message.getStart());
                            stat.setLong(NumberConst.FIVE, message.getEnd());
                            stat.setLong(NumberConst.SIX, message.getInput());
                            stat.setLong(NumberConst.SEVEN, message.getOutput());
                            stat.setString(NumberConst.EIGHT, message.getException());
                            stat.setString(NumberConst.NINE, message.getIp());
                            stat.setString(NumberConst.TEN, message.getUname());
                            stat.addBatch();
                            if (size % 30 != 0) continue;
                            stat.executeBatch();
                        }
                        stat.executeBatch();
                        break block8;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Object var8_6 = null;
                        DBUitl.closeConnStatementResultSet(conn, stat, null);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    DBUitl.closeConnStatementResultSet(conn, stat, null);
                    throw throwable;
                }
            }
            DBUitl.closeConnStatementResultSet(conn, stat, null);
            return;
        }
        Object var8_5 = null;
        DBUitl.closeConnStatementResultSet(conn, stat, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeWithRedis(List<ServiceMonitor> messagestores) {
        Jedis jedis = null;
        ShardedJedis sharedJedis = null;
        try {
            try {
                String countKey = RedisClient.INSTANCE.genKey("SERVICE_MONITOR", "SIZE");
                int day = XtcsUtil.getMointorDay();
                int time = 86400;
                if (day > 0) {
                    time = day * 86400;
                }
                for (ServiceMonitor message : messagestores) {
                    long size = 0L;
                    message.setId(String.valueOf(size));
                    jedis = RedisClient.INSTANCE.getConnection();
                    sharedJedis = RedisClient.INSTANCE.getSharedConnection();
                    if (sharedJedis != null) {
                        size = sharedJedis.incr(countKey);
                        sharedJedis.setex(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", String.valueOf(size)), time, JSONUtil.toJsonString(message));
                        if (!StringUtil.isNotEmptyString(message.getSid())) continue;
                        sharedJedis.sadd(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", message.getSid()), new String[]{String.valueOf(size)});
                        continue;
                    }
                    if (jedis == null) continue;
                    size = jedis.incr(countKey);
                    jedis.setex(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", String.valueOf(size)), time, JSONUtil.toJsonString(message));
                    if (!StringUtil.isNotEmptyString(message.getSid())) continue;
                    jedis.sadd(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", message.getSid()), new String[]{String.valueOf(size)});
                }
                Object var12_11 = null;
                RedisClient.INSTANCE.returnConnection(jedis);
                RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u96c6\u4e2d\u5f0f\u7f13\u5b58Redis\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", e);
                }
                Object var12_12 = null;
                RedisClient.INSTANCE.returnConnection(jedis);
                RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            RedisClient.INSTANCE.returnConnection(jedis);
            RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            throw throwable;
        }
    }

    protected ServiceMonitor find(String id) {
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                ServiceMonitor vo;
                vo.setStatus(StringUtil.isEmptyString((vo = this.findWithRedis(id)).getException()) ? 1 : -1);
                return vo;
            }
            return this.findWithDB(id);
        }
        return this.findWithDB(id);
    }

    protected ServiceMonitor findWithRedis(String id) {
        String json = this.getService().get("SERVICE_MONITOR", id);
        if (json != null) {
            return (ServiceMonitor)JSONUtil.fromJsonString(json, ServiceMonitor.class);
        }
        return null;
    }

    protected ServiceMonitor findWithDB(String id) {
        ServiceMonitor vo;
        block0: {
            String sql = MessageFormat.format("SELECT GID,S_ID,U_IP,U_NAME,S_NAME,S_START,S_END,S_INPUT,S_OUTPUT,S_EXCEPTION FROM {0}ECP_MONITOR_LOG WHERE ID = :ID", this.getSchema());
            List<Object[]> data = this.getDao().findBySQLWithoutRowNumLimit(sql, "ID", id, Object[].class);
            vo = new ServiceMonitor();
            Iterator<Object[]> iterator = data.iterator();
            if (!iterator.hasNext()) break block0;
            Object[] object = iterator.next();
            vo.setId(String.valueOf(object[NumberConst.ZERO_INTEGER]));
            vo.setSid(String.valueOf(object[NumberConst.ONE]));
            vo.setIp(String.valueOf(object[NumberConst.TWO]));
            vo.setUname(String.valueOf(object[NumberConst.THREE]));
            vo.setSname(String.valueOf(object[NumberConst.FOUR]));
            vo.setStart(Long.parseLong(String.valueOf(object[NumberConst.FIVE])));
            vo.setEnd(Long.parseLong(String.valueOf(object[NumberConst.SIX])));
            vo.setInput(Long.parseLong(String.valueOf(object[NumberConst.SEVEN])));
            vo.setOutput(Long.parseLong(String.valueOf(object[NumberConst.EIGHT])));
            vo.setException(String.valueOf(object[NumberConst.NINE]));
            vo.setStatus(StringUtil.isEmptyString(String.valueOf(object[NumberConst.NINE])) ? 1 : -1);
        }
        return vo;
    }

    protected Map<Integer, List<ServiceMonitor>> findAll(int pageNo, int pageSize) {
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                return this.findAllWithRedis(pageNo, pageSize);
            }
            return this.findAllWithDB(pageNo, pageSize);
        }
        return this.findAllWithDB(pageNo, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, List<ServiceMonitor>> findAllWithRedis(int pageNo, int pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new UnsupportedOperationException("Page [" + pageNo + "] and PageSize [" + pageSize + "] must be positive integer!");
        }
        int firstResult = (pageNo - 1) * pageSize;
        int maxResult = pageSize > 2000 ? 2000 : pageSize;
        HashMap<Integer, List<ServiceMonitor>> dataMap = new HashMap<Integer, List<ServiceMonitor>>();
        ArrayList<ServiceMonitor> dataList = new ArrayList<ServiceMonitor>();
        Jedis jedis = null;
        ShardedJedis sharedJedis = null;
        String countKey = RedisClient.INSTANCE.genKey("SERVICE_MONITOR", "SIZE");
        Long size = 0L;
        try {
            try {
                jedis = RedisClient.INSTANCE.getConnection();
                sharedJedis = RedisClient.INSTANCE.getSharedConnection();
                long realCount = 0L;
                if (sharedJedis != null) {
                    size = Long.parseLong(sharedJedis.get(countKey));
                    for (int i = firstResult; i < maxResult; ++i) {
                        realCount = size - (long)i;
                        String json = sharedJedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", String.valueOf(size - (long)i)));
                        if (json != null) {
                            ServiceMonitor vo;
                            vo.setStatus(StringUtil.isEmptyString((vo = (ServiceMonitor)JSONUtil.fromJsonString(json, ServiceMonitor.class)).getException()) ? 1 : -1);
                            dataList.add(vo);
                            continue;
                        }
                        size = realCount;
                        sharedJedis.set(countKey, String.valueOf(realCount));
                    }
                } else if (jedis != null) {
                    size = Long.parseLong(jedis.get(countKey));
                    for (int i = firstResult; i < maxResult; ++i) {
                        realCount = size - (long)i;
                        String json = jedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", String.valueOf(size - (long)i)));
                        if (json != null) {
                            ServiceMonitor vo;
                            vo.setStatus(StringUtil.isEmptyString((vo = (ServiceMonitor)JSONUtil.fromJsonString(json, ServiceMonitor.class)).getException()) ? 1 : -1);
                            dataList.add(vo);
                            continue;
                        }
                        size = realCount;
                        jedis.set(countKey, String.valueOf(realCount));
                    }
                }
                Object var17_19 = null;
                RedisClient.INSTANCE.returnConnection(jedis);
                RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            }
            catch (Exception e) {
                LOG.error("\u96c6\u4e2d\u5f0f\u7f13\u5b58Redis\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", e);
                Object var17_20 = null;
                RedisClient.INSTANCE.returnConnection(jedis);
                RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            RedisClient.INSTANCE.returnConnection(jedis);
            RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            throw throwable;
        }
        dataMap.put(size.intValue(), dataList);
        return dataMap;
    }

    protected Map<Integer, List<ServiceMonitor>> findAllWithDB(int pageNo, int pageSize) {
        String sql = MessageFormat.format("SELECT GID,S_ID,U_IP,U_NAME,S_NAME,S_START,S_END,S_INPUT,S_OUTPUT,S_EXCEPTION FROM {0}ECP_MONITOR_LOG", this.getSchema());
        List<Number> size = this.getDao().findBySQL(MessageFormat.format("SELECT COUNT(GID) FROM {0}ECP_MONITOR_LOG", this.getSchema()), Number.class);
        List<Object[]> data = this.getDao().findBySQL(sql, pageNo, pageSize, Object[].class);
        ArrayList<ServiceMonitor> dataList = new ArrayList<ServiceMonitor>();
        for (Object[] object : data) {
            ServiceMonitor vo = new ServiceMonitor();
            vo.setId(String.valueOf(object[NumberConst.ZERO_INTEGER]));
            vo.setSid(String.valueOf(object[NumberConst.ONE]));
            vo.setIp(String.valueOf(object[NumberConst.TWO]));
            vo.setUname(String.valueOf(object[NumberConst.THREE]));
            vo.setSname(String.valueOf(object[NumberConst.FOUR]));
            vo.setStart(Long.parseLong(String.valueOf(object[NumberConst.FIVE])));
            vo.setEnd(Long.parseLong(String.valueOf(object[NumberConst.SIX])));
            vo.setInput(Long.parseLong(String.valueOf(object[NumberConst.SEVEN])));
            vo.setOutput(Long.parseLong(String.valueOf(object[NumberConst.EIGHT])));
            vo.setException(String.valueOf(object[NumberConst.NINE]));
            vo.setStatus(StringUtil.isEmptyString(String.valueOf(object[NumberConst.NINE])) ? 1 : -1);
            dataList.add(vo);
        }
        HashMap<Integer, List<ServiceMonitor>> dataMap = new HashMap<Integer, List<ServiceMonitor>>();
        dataMap.put(size.get(0).intValue(), dataList);
        return dataMap;
    }

    protected void deleteHistory() {
        if (this.getService() == null || !this.getService().isEnabled()) {
            if (this.getDao() == null) {
                return;
            }
            String sql = MessageFormat.format("DELETE FROM {0}ECP_MONITOR_LOG WHERE S_START < :START", this.getSchema());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(System.currentTimeMillis()));
            int day = XtcsUtil.getMointorDay();
            if (day > 0) {
                calendar.add(5, 0 - day);
            } else {
                calendar.add(5, -1);
            }
            try {
                this.getDao().executeSQL(sql, "START", calendar.getTimeInMillis());
            }
            catch (Throwable ex) {
                LOG.info("\u5220\u9664\u6027\u80fd\u65e5\u5fd7\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38" + ex.getMessage());
            }
        }
    }

    private String getSchema() {
        try {
            return DBUitl.getShareSchema() + ".";
        }
        catch (Throwable ex) {
            return "";
        }
    }

    protected List<ServiceMonitor> findBySid(String sid) {
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                return this.findBySidWithRedis(sid);
            }
            return this.findBySidWithDB(sid);
        }
        return this.findBySidWithDB(sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ServiceMonitor> findBySidWithRedis(String sid) {
        Set<String> set = this.getService().smembers("SERVICE_MONITOR", sid);
        if (set == null || set.isEmpty()) {
            return null;
        }
        ArrayList<ServiceMonitor> dataList = new ArrayList<ServiceMonitor>();
        Jedis jedis = null;
        ShardedJedis sharedJedis = null;
        try {
            try {
                jedis = RedisClient.INSTANCE.getConnection();
                sharedJedis = RedisClient.INSTANCE.getSharedConnection();
                if (sharedJedis != null) {
                    for (String id : set) {
                        ServiceMonitor vo;
                        String json = sharedJedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", id));
                        if (json == null) continue;
                        vo.setStatus(StringUtil.isEmptyString((vo = (ServiceMonitor)JSONUtil.fromJsonString(json, ServiceMonitor.class)).getException()) ? 1 : -1);
                        dataList.add(vo);
                    }
                } else if (jedis != null) {
                    for (String id : set) {
                        ServiceMonitor vo;
                        String json = jedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", id));
                        if (json == null) continue;
                        vo.setStatus(StringUtil.isEmptyString((vo = (ServiceMonitor)JSONUtil.fromJsonString(json, ServiceMonitor.class)).getException()) ? 1 : -1);
                        dataList.add(vo);
                    }
                }
                Object var11_15 = null;
                RedisClient.INSTANCE.returnConnection(jedis);
                RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            }
            catch (Exception e) {
                LOG.error("\u96c6\u4e2d\u5f0f\u7f13\u5b58Redis\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", e);
                Object var11_16 = null;
                RedisClient.INSTANCE.returnConnection(jedis);
                RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            RedisClient.INSTANCE.returnConnection(jedis);
            RedisClient.INSTANCE.returnShareConnection(sharedJedis);
            throw throwable;
        }
        return dataList;
    }

    protected List<ServiceMonitor> findBySidWithDB(String sid) {
        String sql = MessageFormat.format("SELECT GID,S_ID,U_IP,U_NAME,S_NAME,S_START,S_END,S_INPUT,S_OUTPUT,S_EXCEPTION FROM {0}ECP_MONITOR_LOG WHERE S_ID = :SID", this.getSchema());
        List<Object[]> data = this.getDao().findBySQLWithoutRowNumLimit(sql, "SID", sid, Object[].class);
        ArrayList<ServiceMonitor> dataList = new ArrayList<ServiceMonitor>();
        for (Object[] object : data) {
            ServiceMonitor vo = new ServiceMonitor();
            vo.setId(String.valueOf(object[NumberConst.ZERO_INTEGER]));
            vo.setSid(String.valueOf(object[NumberConst.ONE]));
            vo.setIp(String.valueOf(object[NumberConst.TWO]));
            vo.setUname(String.valueOf(object[NumberConst.THREE]));
            vo.setSname(String.valueOf(object[NumberConst.FOUR]));
            vo.setStart(Long.parseLong(String.valueOf(object[NumberConst.FIVE])));
            vo.setEnd(Long.parseLong(String.valueOf(object[NumberConst.SIX])));
            vo.setInput(Long.parseLong(String.valueOf(object[NumberConst.SEVEN])));
            vo.setOutput(Long.parseLong(String.valueOf(object[NumberConst.EIGHT])));
            vo.setException(String.valueOf(object[NumberConst.NINE]));
            vo.setStatus(StringUtil.isEmptyString(String.valueOf(object[NumberConst.NINE])) ? 1 : -1);
            dataList.add(vo);
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findAllByJson(int pageNo, int pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new UnsupportedOperationException("Page [" + pageNo + "] and PageSize [" + pageSize + "] must be positive integer!");
        }
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                int firstResult = (pageNo - 1) * pageSize;
                int maxResult = pageSize > 2000 ? 2000 : pageSize;
                HashMap dataMap = new HashMap();
                ArrayList<String> dataList = new ArrayList<String>();
                Jedis jedis = null;
                ShardedJedis sharedJedis = null;
                String countKey = RedisClient.INSTANCE.genKey("SERVICE_MONITOR", "SIZE");
                Long size = 0L;
                try {
                    try {
                        jedis = RedisClient.INSTANCE.getConnection();
                        sharedJedis = RedisClient.INSTANCE.getSharedConnection();
                        long realCount = 0L;
                        if (sharedJedis != null) {
                            size = Long.parseLong(sharedJedis.get(countKey));
                            for (int i = firstResult; i < maxResult; ++i) {
                                realCount = size - (long)i;
                                String json = sharedJedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", String.valueOf(size - (long)i)));
                                if (json != null) {
                                    dataList.add(json);
                                    continue;
                                }
                                size = realCount;
                                sharedJedis.set(countKey, String.valueOf(realCount));
                            }
                        } else if (jedis != null) {
                            size = Long.parseLong(jedis.get(countKey));
                            for (int i = firstResult; i < maxResult; ++i) {
                                realCount = size - (long)i;
                                String json = jedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", String.valueOf(size - (long)i)));
                                if (json != null) {
                                    dataList.add(json);
                                    continue;
                                }
                                size = realCount;
                                jedis.set(countKey, String.valueOf(realCount));
                            }
                        }
                        Object var16_17 = null;
                        RedisClient.INSTANCE.returnConnection(jedis);
                        RedisClient.INSTANCE.returnShareConnection(sharedJedis);
                    }
                    catch (Exception e) {
                        LOG.error("\u96c6\u4e2d\u5f0f\u7f13\u5b58Redis\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", e);
                        Object var16_18 = null;
                        RedisClient.INSTANCE.returnConnection(jedis);
                        RedisClient.INSTANCE.returnShareConnection(sharedJedis);
                    }
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    RedisClient.INSTANCE.returnConnection(jedis);
                    RedisClient.INSTANCE.returnShareConnection(sharedJedis);
                    throw throwable;
                }
                dataMap.put(size.intValue(), dataList);
                return JSONUtil.toJsonString(dataMap);
            }
            return JSONUtil.toJsonString(this.findAllWithDB(pageNo, pageSize));
        }
        return JSONUtil.toJsonString(this.findAllWithDB(pageNo, pageSize));
    }

    protected String findByJson(String id) {
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                this.getService().get("SERVICE_MONITOR", id);
                return null;
            }
            return JSONUtil.toJsonString(this.find(id));
        }
        return JSONUtil.toJsonString(this.find(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String findBySidByJson(String sid) {
        if (this.getService() != null) {
            if (this.getService().isEnabled()) {
                Set<String> set = this.getService().smembers("SERVICE_MONITOR", sid);
                if (set == null || set.isEmpty()) {
                    return null;
                }
                ArrayList<String> dataList = new ArrayList<String>();
                Jedis jedis = null;
                ShardedJedis sharedJedis = null;
                try {
                    try {
                        jedis = RedisClient.INSTANCE.getConnection();
                        sharedJedis = RedisClient.INSTANCE.getSharedConnection();
                        if (sharedJedis != null) {
                            for (String id : set) {
                                dataList.add(sharedJedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", id)));
                            }
                        } else if (jedis != null) {
                            for (String id : set) {
                                dataList.add(jedis.get(RedisClient.INSTANCE.genKey("SERVICE_MONITOR", id)));
                            }
                        }
                        Object var9_11 = null;
                        RedisClient.INSTANCE.returnConnection(jedis);
                        RedisClient.INSTANCE.returnShareConnection(sharedJedis);
                    }
                    catch (Exception e) {
                        LOG.error("\u96c6\u4e2d\u5f0f\u7f13\u5b58Redis\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38", e);
                        Object var9_12 = null;
                        RedisClient.INSTANCE.returnConnection(jedis);
                        RedisClient.INSTANCE.returnShareConnection(sharedJedis);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    RedisClient.INSTANCE.returnConnection(jedis);
                    RedisClient.INSTANCE.returnShareConnection(sharedJedis);
                    throw throwable;
                }
                return JSONUtil.toJsonString(dataList);
            }
            return JSONUtil.toJsonString(this.findBySidWithDB(sid));
        }
        return JSONUtil.toJsonString(this.findBySidWithDB(sid));
    }

    private IRedisService getService() {
        if (this.service == null) {
            this.service = OSGiUtil.getService(IRedisService.class);
        }
        return this.service;
    }

    private ISQLTemplate getDao() {
        return OSGiUtil.getService(ISQLTemplate.class);
    }

    private Connection getConnection() {
        if (this.dataSource == null) {
            this.dataSource = OSGiUtil.getService(DataSource.class);
        }
        if (this.dataSource == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6570\u636e\u6e90\u8fd8\u672a\u53d1\u5e03!");
            }
            return null;
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new UnsupportedOperationException("\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u5931\u8d25!");
        }
    }
}

