/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.log;

import com.ygsoft.ecp.service.executor.log.LogStoreCallable;
import com.ygsoft.ecp.service.executor.log.LogStoreHandle;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.IMonitorLog;
import com.ygsoft.ecp.service.log.ServiceMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogStoreService
implements IMonitorLog {
    private static final IEcpLog LOG = EcpLogFactory.getSystemLog(LogStoreService.class);
    public static final LogStoreService INSTANCE = new LogStoreService();
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static List<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();

    private LogStoreService() {
    }

    protected void store() {
        try {
            this.executorService.invokeAll(tasks);
        }
        catch (Exception ex) {
            LOG.error("\u670d\u52a1\u76d1\u63a7\u65e5\u5fd7\u5b58\u50a8\u670d\u52a1\u6267\u884c\u53d1\u751f\u5f02\u5e38", ex);
        }
    }

    public void storeOnStop() {
        for (Callable<Boolean> task : tasks) {
            LogStoreHandle.INSTANCE.store(((LogStoreCallable)task).getMessages());
        }
    }

    @Override
    public ServiceMonitor find(String id) {
        return LogStoreHandle.INSTANCE.find(id);
    }

    @Override
    public Map<Integer, List<ServiceMonitor>> findAll(int pageNo, int pageSize) {
        return LogStoreHandle.INSTANCE.findAll(pageNo, pageSize);
    }

    @Override
    public List<ServiceMonitor> findBySid(String sid) {
        return LogStoreHandle.INSTANCE.findBySid(sid);
    }

    @Override
    public String findAllByJson(int pageNo, int pageSize) {
        return LogStoreHandle.INSTANCE.findAllByJson(pageNo, pageSize);
    }

    @Override
    public String findByJson(String id) {
        return LogStoreHandle.INSTANCE.findByJson(id);
    }

    @Override
    public String findBySidByJson(String sid) {
        return LogStoreHandle.INSTANCE.findBySidByJson(sid);
    }

    static {
        tasks.add(new LogStoreCallable());
        tasks.add(new LogStoreCallable());
        tasks.add(new LogStoreCallable());
        tasks.add(new LogStoreCallable());
        tasks.add(new LogStoreCallable());
    }
}

