/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.i18n;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.internal.i18n.TableEnum;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ConvertUtil;
import com.ygsoft.ecp.service.tool.DBUtil;
import com.ygsoft.ecp.service.tool.I18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBResourceAccessService
implements IEcpToolLogic {
    private static final String MUTIL_LANGUAGE = "mutil.language";
    private static final String QRY_LAN_NOSTOP = "SELECT LANCODE, LANID, NOTE, DEFAULTED, STOPED FROM {0}ECP_LANGUAGE WHERE {1} ";
    private static final String QUERY_STOP_FIELD_MYSQL = " IFNULL(STOPED, 0)=0 ";
    private static final String QUERY_STOP_FIELD = " NVL(STOPED, 0)=0 ";
    private static final int PAGE_SIZE_1000 = 1000;
    private static final String LANGUAGE_TABLE = TableEnum.LANGUAGE.getName();
    private static final ICache<String, String> RUMTIME_LANCACHE = EcpService.getTimeExpireCache();
    private static final ICache<String, Map<String, Object>> MUTILLINGUAL_CACHE = EcpService.getCacheService("mutil.language", "mutilingual");
    private static final ICache<String, String> DESIGNLANGUAGE_CACHE = EcpService.getCacheService("mutil.language", "designmutilingual");
    private static final String QRY_RUNTIMEFNAME_BY_NAME_LANCODE = "SELECT ZH_CHNAME, FNAME FROM {0}ECP_LAN_RUNTIME_BASEDICT A LEFT JOIN {0}ECP_LANGUAGE B ON A.LANID=B.LANID WHERE ZH_CHNAME IN(:DEFAULT_CHNAME) AND B.LANCODE=:LAN_CODE";
    private static final String QRY_FNAME_BY_NAME_LANCODE = "SELECT ZH_CHNAME, FNAME FROM {0}ECP_LAN_BASEDICT A LEFT JOIN {0}ECP_LANGUAGE B ON A.LANID=B.LANID WHERE ZH_CHNAME IN(:DEFAULT_CHNAME) AND B.LANCODE=:LAN_CODE";
    private static final String QRY_COUNT_BY_NAME = "SELECT ZH_CHNAME, COUNT(FNAME) FCOUNT FROM {0}ECP_LAN_BASEDICT A , {0}ECP_LANGUAGE B WHERE A.LANID = B.LANID AND ZH_CHNAME IN(:DEFAULT_CHNAME)  AND {1} GROUP BY ZH_CHNAME";
    private static final IEcpLog LOG = EcpLogFactory.getLog(DBResourceAccessService.class);
    private static ISQLTemplate sqlTemplate = DBUtil.getSqlTemplate();
    private static final Map<String, String> LANGUAGE_HASHMAP = new ConcurrentHashMap<String, String>();
    private static ICache<String, String> resourceCache = EcpService.getLRUCache("DBResourceCache");

    private DBResourceAccessService() {
    }

    public static int getLangIdByCode(String code) {
        String upperCode;
        if (!StringUtils.isEmpty((CharSequence)code) && LANGUAGE_HASHMAP.containsKey(upperCode = code.toUpperCase())) {
            return Integer.parseInt(LANGUAGE_HASHMAP.get(upperCode));
        }
        return -1;
    }

    public static ICache<String, String> getResourceCache() {
        return resourceCache;
    }

    public static void clearResource() {
        resourceCache.clear();
    }

    public static void setSQLTemplate(ISQLTemplate newSQLTemplate) {
        sqlTemplate = newSQLTemplate;
    }

    private static String getSelectSQL(String schema) {
        String sql = null;
        sql = StringUtils.isEmpty((CharSequence)schema) ? "SELECT fname FROM " + DBUtil.getShareSchema() + "." + TableEnum.XTYWDJXM.getName() + " a ," + LANGUAGE_TABLE + " b WHERE a.lanid = b.lanid AND a.zh_chname=:chname AND  UPPER(b.lancode)=:lancode" : "SELECT fname FROM " + schema + "." + TableEnum.XTYWDJXM.getName() + " a ," + LANGUAGE_TABLE + " b WHERE a.lanid = b.lanid AND a.zh_chname=:chname AND  UPPER(b.lancode)=:lancode";
        return sql;
    }

    private static String getInSelectSQL(String schema) {
        String sql = null;
        sql = StringUtils.isEmpty((CharSequence)schema) ? "SELECT a.zh_chname,a.fname FROM " + DBUtil.getShareSchema() + "." + TableEnum.XTYWDJXM.getName() + " a ," + LANGUAGE_TABLE + " b WHERE a.lanid = b.lanid AND a.zh_chname in (:chname) AND  UPPER(b.lancode)=:lancode" : "SELECT a.zh_chname,a.fname FROM " + schema + "." + TableEnum.XTYWDJXM.getName() + " a ," + LANGUAGE_TABLE + " b WHERE a.lanid = b.lanid AND a.zh_chname in (:chname) AND  UPPER(b.lancode)=:lancode";
        return sql;
    }

    private static String getUpdateSQL(String schema) {
        String sql = null;
        sql = StringUtils.isEmpty((CharSequence)schema) ? "UPDATE " + DBUtil.getShareSchema() + "." + TableEnum.XTYWDJXM.getName() + " SET fname=:translatedstr WHERE zh_chname=:chname AND  lanid=:lanid" : "UPDATE " + schema + "." + TableEnum.XTYWDJXM.getName() + " SET fname=:translatedstr WHERE zh_chname=:chname AND  lanid=:lanid";
        return sql;
    }

    private static String getInsertSQL(String schema) {
        String sql = null;
        sql = StringUtils.isEmpty((CharSequence)schema) ? "insert into " + DBUtil.getShareSchema() + "." + TableEnum.XTYWDJXM.getName() + "(zh_chname,lanid,fname) values (:chname,:lanid,:translatedstr)" : "insert into " + schema + "." + TableEnum.XTYWDJXM.getName() + "(zh_chname,lanid,fname) values (:chname,:lanid,:translatedstr)";
        return sql;
    }

    private static String getDeleteSQL(String schema) {
        String sql = null;
        sql = StringUtils.isEmpty((CharSequence)schema) ? "delete from " + DBUtil.getShareSchema() + "." + TableEnum.XTYWDJXM.getName() + " where zh_chname=:chname AND  lanid=:lanid" : "delete from " + schema + "." + TableEnum.XTYWDJXM.getName() + " where zh_chname=:chname AND  lanid=:lanid";
        return sql;
    }

    public static String localizedString(String schema, Locale locale, String chName) {
        if (StringUtils.isEmpty((CharSequence)chName) || locale == null) {
            return chName;
        }
        String res = chName;
        String cacheValue = DBResourceAccessService.findInCache(DBResourceAccessService.getCacheKey(locale, chName));
        if (cacheValue != null) {
            res = cacheValue;
        } else {
            Map<String, Object> params = DBResourceAccessService.getParams(locale, chName, null, false);
            if (params != null) {
                List<?> list = DBResourceAccessService.executeDDL(DBResourceAccessService.getSelectSQL(schema), params, 1, 1, String.class);
                if (DBResourceAccessService.isListNotEmpty(list)) {
                    res = (String)list.get(0);
                }
                if (res != null) {
                    resourceCache.put(DBResourceAccessService.getCacheKey(locale, chName), res);
                }
            }
        }
        return res;
    }

    private static List<?> executeDDL(String sql, Map<String, Object> params, int pageIdx, int pageSize, Class<?> clazz) {
        try {
            return sqlTemplate.findBySQL(sql, params, pageIdx, pageSize, clazz);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e);
            }
            return null;
        }
    }

    private static String getCacheKey(Locale locale, String chName) {
        return I18nUtil.getLocaleStr(locale) + chName;
    }

    public static boolean existsLocalizedString(String schema, Locale locale, String chName) {
        if (StringUtils.isEmpty((CharSequence)chName)) {
            return false;
        }
        Map<String, Object> params = DBResourceAccessService.getParams(locale, chName, null, false);
        if (params == null) {
            return false;
        }
        List<?> list = DBResourceAccessService.executeDDL(DBResourceAccessService.getInSelectSQL(schema), params, 1, 1, Map.class);
        return DBResourceAccessService.isListNotEmpty(list);
    }

    private static String findInCache(String cacheKey) {
        if (resourceCache.containsKey(cacheKey)) {
            return resourceCache.get(cacheKey);
        }
        return null;
    }

    public static List<String> localizedString(String schema, Locale locale, List<String> chNames) {
        if (chNames == null || chNames.isEmpty() || locale == null) {
            return chNames;
        }
        long start = 0L;
        if (LOG.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        ArrayList<String> notInCacheChNames = null;
        String cacheValue = null;
        String chName = null;
        for (int i = 0; i < chNames.size(); ++i) {
            chName = chNames.get(i);
            if (StringUtils.isEmpty((CharSequence)chName)) continue;
            cacheValue = DBResourceAccessService.findInCache(DBResourceAccessService.getCacheKey(locale, chName));
            if (cacheValue != null) {
                chNames.set(i, cacheValue);
                continue;
            }
            if (notInCacheChNames == null) {
                notInCacheChNames = new ArrayList<String>();
            }
            notInCacheChNames.add(chName);
        }
        if (notInCacheChNames != null) {
            DBResourceAccessService.replaceByDB(schema, locale, chNames, notInCacheChNames);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6279\u91cf\u56fd\u9645\u5316,\u5143\u7d20\u4e2a\u6570" + chNames.size() + ",\u8017\u65f6" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        return chNames;
    }

    private static void replaceByDB(String schema, Locale locale, List<String> chNames, List<String> notInCacheChNames) {
        int size = notInCacheChNames.size();
        if (size > 0) {
            int offset;
            long start = 0L;
            if (LOG.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            if (size > (offset = NumberConst.HUNDRED * NumberConst.FIVE)) {
                DBResourceAccessService.localizedByPage(schema, locale, chNames, notInCacheChNames, offset);
            } else {
                DBResourceAccessService.localizedString(schema, locale, chNames, notInCacheChNames, offset);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6570\u636e\u5e93\u6279\u91cf\u56fd\u9645\u5316,\u5143\u7d20\u4e2a\u6570" + size + ",\u8017\u65f6" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            }
        }
    }

    private static void localizedByPage(String schema, Locale locale, Object chNames, List<String> notInCacheChNames, int offset) {
        int size = notInCacheChNames.size();
        int count = size / offset;
        if (size % offset > 0) {
            ++count;
        }
        int end = offset;
        int start = 0;
        for (int j = 0; j < count; ++j) {
            if (end > size) {
                end = size;
            }
            List<String> list = notInCacheChNames.subList(start, end);
            if (chNames instanceof List) {
                DBResourceAccessService.localizedString(schema, locale, (List)chNames, list, offset);
            } else {
                Map<String, String> noInCacheMap = DBResourceAccessService.localizedString(schema, locale, list, offset);
                if (noInCacheMap != null) {
                    ((Map)chNames).putAll(noInCacheMap);
                }
            }
            start = end;
            end += offset;
        }
    }

    public static Map<String, String> localizedListString(String schema, Locale locale, List<String> chNames) {
        if (chNames == null || chNames.isEmpty() || locale == null) {
            return null;
        }
        long start = 0L;
        if (LOG.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        ArrayList<String> notInCacheChNames = null;
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        String cacheValue = null;
        for (String chName : chNames) {
            if (StringUtil.isEmpty(chName)) continue;
            map.put(chName, chName);
            cacheValue = DBResourceAccessService.findInCache(DBResourceAccessService.getCacheKey(locale, chName));
            if (cacheValue != null) {
                map.put(chName, cacheValue);
                continue;
            }
            if (notInCacheChNames == null) {
                notInCacheChNames = new ArrayList<String>(chNames);
            }
            notInCacheChNames.add(chName);
        }
        if (notInCacheChNames != null) {
            DBResourceAccessService.findByDB(schema, locale, map, notInCacheChNames);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6279\u91cf\u56fd\u9645\u5316,\u5143\u7d20\u4e2a\u6570" + chNames.size() + ",\u8017\u65f6" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        }
        return map;
    }

    private static void findByDB(String schema, Locale locale, Map<String, String> storageMap, List<String> notInCacheChNames) {
        int size = notInCacheChNames.size();
        if (size > 0) {
            int offset;
            long start = 0L;
            if (LOG.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            if (size > (offset = NumberConst.HUNDRED * NumberConst.FIVE)) {
                DBResourceAccessService.localizedByPage(schema, locale, storageMap, notInCacheChNames, offset);
            } else {
                Map<String, String> noInCacheMap = DBResourceAccessService.localizedString(schema, locale, notInCacheChNames, offset);
                if (noInCacheMap != null) {
                    storageMap.putAll(noInCacheMap);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6570\u636e\u5e93\u6279\u91cf\u56fd\u9645\u5316,\u5143\u7d20\u4e2a\u6570" + size + ",\u8017\u65f6" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            }
        }
    }

    private static void localizedString(String schema, Locale locale, List<String> chNames, List<String> notInCacheChNames, int offset) {
        List<Map> list;
        if (locale == null || chNames == null || chNames.size() == 0 || notInCacheChNames.size() == 0) {
            return;
        }
        Map<String, Object> params = DBResourceAccessService.getParams(locale, notInCacheChNames, null, false);
        if (params != null && DBResourceAccessService.isListNotEmpty(list = DBResourceAccessService.executeDDL(DBResourceAccessService.getInSelectSQL(schema), params, 1, offset, Map.class))) {
            Map<String, String> resMap = DBResourceAccessService.getDBResourceMap(list);
            for (String str : notInCacheChNames) {
                String value = null;
                if (!resMap.containsKey(str)) continue;
                value = resMap.get(str);
                chNames.set(chNames.indexOf(str), value);
                resourceCache.put(DBResourceAccessService.getCacheKey(locale, str), value);
            }
        }
    }

    private static Map<String, String> localizedString(String schema, Locale locale, List<String> notInCacheChNames, int offset) {
        List<Map> list;
        if (locale == null || notInCacheChNames.size() == 0) {
            return null;
        }
        Map<String, Object> params = DBResourceAccessService.getParams(locale, notInCacheChNames, null, false);
        if (params != null && DBResourceAccessService.isListNotEmpty(list = DBResourceAccessService.executeDDL(DBResourceAccessService.getInSelectSQL(schema), params, 1, offset, Map.class))) {
            Map<String, String> resMap = DBResourceAccessService.getDBResourceMap(list);
            for (String str : notInCacheChNames) {
                if (!resMap.containsKey(str)) continue;
                resourceCache.put(DBResourceAccessService.getCacheKey(locale, str), resMap.get(str));
            }
            return resMap;
        }
        return null;
    }

    private static boolean isListNotEmpty(List<?> list) {
        return list != null && list.size() > 0;
    }

    private static Map<String, String> getDBResourceMap(List<Map> list) {
        ConcurrentHashMap<String, String> res = new ConcurrentHashMap<String, String>();
        String tranStr = null;
        for (Map map : list) {
            String chineseStr = (String)map.get("zh_chname");
            tranStr = (String)map.get("fname");
            if (StringUtil.isEmpty(tranStr)) continue;
            res.put(chineseStr, tranStr);
        }
        return res;
    }

    private static void initLanguageHM() {
        block4: {
            try {
                String sql = "select upper(lancode) lancode,lanid from " + DBUtil.getShareSchema() + "." + TableEnum.LANGUAGE.getName();
                List<Map> hmList = sqlTemplate.findBySQLWithoutRowNumLimit(sql, Map.class);
                if (hmList != null) {
                    for (Map hm : hmList) {
                        LANGUAGE_HASHMAP.put(hm.get("lancode").toString(), hm.get("lanid").toString());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error(e);
            }
        }
    }

    public static boolean updateLocalizedString(String schema, Locale locale, String chName, String tranStr) {
        return DBResourceAccessService.insertOrUpdateLocalizedString(schema, locale, chName, tranStr, false);
    }

    private static boolean insertOrUpdateLocalizedString(String schema, Locale locale, String chName, String tranStr, boolean isInsert) {
        if (locale == null || StringUtils.isEmpty((CharSequence)chName)) {
            return false;
        }
        String cacheKey = DBResourceAccessService.getCacheKey(locale, chName);
        String sql = null;
        sql = isInsert ? DBResourceAccessService.getInsertSQL(schema) : DBResourceAccessService.getUpdateSQL(schema);
        Map<String, Object> params = DBResourceAccessService.getParams(locale, chName, tranStr, true);
        if (params == null) {
            return false;
        }
        boolean res = DBResourceAccessService.executeDML(sql, params);
        if (res) {
            resourceCache.put(cacheKey, tranStr);
        }
        return res;
    }

    public static boolean insertLocalizedString(String schema, Locale locale, String chName, String tranStr) {
        return DBResourceAccessService.insertOrUpdateLocalizedString(schema, locale, chName, tranStr, true);
    }

    public static boolean deleteLocalizedString(String schema, Locale locale, String chName) {
        if (locale == null || StringUtils.isEmpty((CharSequence)chName)) {
            return false;
        }
        String cacheKey = DBResourceAccessService.getCacheKey(locale, chName);
        Map<String, Object> params = DBResourceAccessService.getParams(locale, chName, null, true);
        if (params == null) {
            return false;
        }
        boolean res = DBResourceAccessService.executeDML(DBResourceAccessService.getDeleteSQL(schema), params);
        if (res && resourceCache.containsKey(cacheKey)) {
            resourceCache.remove(cacheKey);
        }
        return res;
    }

    private static Map<String, Object> getParams(Locale locale, Object chName, String tranStr, boolean isDML) {
        String localeStr = I18nUtil.getLocaleStr(locale);
        String lanCode = localeStr.toUpperCase();
        if (!LANGUAGE_HASHMAP.containsKey(lanCode)) {
            if (LOG.isErrorEnabled()) {
                LOG.error("\u5728\u6570\u636e\u5e93\u4e2d\u8bed\u8a00\u8868\u4e2d\u672a\u8bbe\u7f6e\u6b64\u79cd\u8bed\u8a00,\u8bed\u8a00=" + localeStr);
            }
            return null;
        }
        ConcurrentHashMap<String, Object> hm = new ConcurrentHashMap<String, Object>();
        if (isDML) {
            hm.put("lanid", LANGUAGE_HASHMAP.get(lanCode));
        } else {
            hm.put("lancode", lanCode);
        }
        hm.put("chname", chName);
        if (!StringUtil.isEmpty(tranStr)) {
            hm.put("translatedstr", tranStr);
        }
        return hm;
    }

    private static boolean executeDML(String sql, Map<String, Object> params) {
        try {
            return sqlTemplate.executeSQL(sql, params) > 0;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e);
            }
            return false;
        }
    }

    public static Map<String, String> transLanguageFnames(String schema, Locale locale, List<String> chNames, boolean isDesign) {
        if (chNames == null || chNames.isEmpty() || locale == null) {
            return null;
        }
        ArrayList<String> notInCacheChNames = new ArrayList<String>();
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        String cacheValue = "";
        for (String chName : chNames) {
            if (!StringUtil.isNotEmptyString(chName)) continue;
            map.put(chName, chName);
            cacheValue = DBResourceAccessService.getCacheService(isDesign).get(DBResourceAccessService.getCacheKey(locale, chName));
            if (StringUtil.isNotEmptyString(cacheValue)) {
                map.put(chName, cacheValue);
                continue;
            }
            notInCacheChNames.add(chName);
        }
        if (!notInCacheChNames.isEmpty()) {
            Map<String, String> cacheMap = DBResourceAccessService.findLanguageFnamesFromDB(schema, I18nUtil.getLocaleStr(locale).toUpperCase(), notInCacheChNames, isDesign);
            DBResourceAccessService.pushLanCache(locale, cacheMap, isDesign);
            map.putAll(cacheMap);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6279\u91cf\u56fd\u9645\u5316transRuntimeFnames\u5143\u7d20\u4e2a\u6570" + chNames.size());
        }
        return map;
    }

    public static void pushLanCache(Locale locale, Map<String, String> cacheMap, boolean isDesign) {
        if (cacheMap == null || cacheMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : cacheMap.entrySet()) {
            DBResourceAccessService.getCacheService(isDesign).put(DBResourceAccessService.getCacheKey(locale, entry.getKey()), entry.getValue());
        }
    }

    private static Map<String, String> findLanguageFnamesFromDB(String schema, String localeName, List<String> zhChnameList, boolean isDesign) {
        Map<String, String> map = new ConcurrentHashMap<String, String>();
        if (zhChnameList == null || zhChnameList.isEmpty()) {
            return map;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        int totalSize = zhChnameList.size();
        int totalPageSize = totalSize / 1000;
        int endIndex = 0;
        for (int pageIndex = 0; pageIndex <= totalPageSize; ++pageIndex) {
            if (pageIndex == totalPageSize) {
                if (pageIndex * 1000 == totalSize) break;
                endIndex = totalSize;
            } else {
                endIndex = (pageIndex + 1) * 1000;
            }
            list.addAll(DBResourceAccessService.findLanguageDicByNameLancode(schema, localeName, zhChnameList.subList(pageIndex * 1000, endIndex), isDesign));
        }
        if (list != null && !list.isEmpty()) {
            map = DBResourceAccessService.getDBResourceMap(list);
        }
        return map;
    }

    private static List<Map> findLanguageDicByNameLancode(String schema, String localeName, List<String> zhChnameList, boolean isDesign) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DEFAULT_CHNAME", zhChnameList);
        param.put("LAN_CODE", localeName);
        String schemaPre = schema == null ? DBUtil.getShareSchema() : schema;
        String qrySql = QRY_RUNTIMEFNAME_BY_NAME_LANCODE;
        if (isDesign) {
            qrySql = QRY_FNAME_BY_NAME_LANCODE;
        }
        String sql = MessageFormat.format(qrySql, schemaPre + ".");
        return sqlTemplate.findBySQLWithoutRowNumLimit(sql, param, Map.class);
    }

    private static ICache<String, String> getCacheService(boolean isDesign) {
        if (isDesign) {
            return DESIGNLANGUAGE_CACHE;
        }
        return RUMTIME_LANCACHE;
    }

    public static Map<String, Boolean> checkDicFnamesCount(String schema, List<String> chNames) {
        ConcurrentHashMap<String, Boolean> resultMap = new ConcurrentHashMap<String, Boolean>();
        if (chNames == null || chNames.isEmpty()) {
            return resultMap;
        }
        Map<String, Integer> map = DBResourceAccessService.findDicFnamesCount(schema, chNames);
        if (map == null) {
            return resultMap;
        }
        int lanCount = MUTILLINGUAL_CACHE.size();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue() == lanCount);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6279\u91cf\u68c0\u67e5checkRuntimeFnames\u586b\u5199\u4e2a\u6570" + chNames.size());
        }
        return resultMap;
    }

    private static Map<String, Integer> findDicFnamesCount(String schema, List<String> zhChnameList) {
        Map<String, Integer> map = new ConcurrentHashMap<String, Integer>();
        if (zhChnameList == null || zhChnameList.isEmpty()) {
            return map;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        int pageSize = 1000;
        int totalSize = zhChnameList.size();
        double size = Math.ceil(totalSize / 1000);
        int endIndex = 0;
        int i = 0;
        while ((double)i <= size) {
            endIndex = (double)i == size ? totalSize : (i + 1) * 1000;
            list.addAll(DBResourceAccessService.findDicByZhChName(schema, zhChnameList.subList(i * 1000, endIndex)));
            ++i;
        }
        if (list != null && !list.isEmpty()) {
            map = DBResourceAccessService.getResourceCount(list);
        }
        return map;
    }

    private static List<Map> findDicByZhChName(String schema, List<String> zhChnameList) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("DEFAULT_CHNAME", zhChnameList);
        String schemaPre = schema == null ? DBUtil.getShareSchema() : schema;
        String stopFilter = QUERY_STOP_FIELD;
        if (DBUtil.isMySql()) {
            stopFilter = QUERY_STOP_FIELD_MYSQL;
        }
        String sql = MessageFormat.format(QRY_COUNT_BY_NAME, schemaPre + ".", stopFilter);
        return sqlTemplate.findBySQLWithoutRowNumLimit(sql, param, Map.class);
    }

    private static Map<String, Integer> getResourceCount(List<Map> list) {
        ConcurrentHashMap<String, Integer> res = new ConcurrentHashMap<String, Integer>();
        String chineseStr = null;
        int fcount = 0;
        if (list == null || list.isEmpty()) {
            return res;
        }
        for (Map map : list) {
            chineseStr = ConvertUtil.toString(map.get("zh_chname"));
            fcount = ConvertUtil.toInt(map.get("fcount"));
            res.put(chineseStr, fcount);
        }
        return res;
    }

    public static void initLanguageCache() {
        String stopFilter = QUERY_STOP_FIELD;
        if (DBUtil.isMySql()) {
            stopFilter = QUERY_STOP_FIELD_MYSQL;
        }
        String sql = MessageFormat.format(QRY_LAN_NOSTOP, DBUtil.getShareSchema() + ".", stopFilter);
        List<Map> hmList = sqlTemplate.findBySQLWithoutRowNumLimit(sql, Map.class);
        MUTILLINGUAL_CACHE.clear();
        if (hmList != null && !hmList.isEmpty()) {
            String lanCode = "";
            for (Map hm : hmList) {
                if (hm == null || StringUtil.isEmptyString(lanCode = ConvertUtil.toString(hm.get("lancode")))) continue;
                MUTILLINGUAL_CACHE.put(lanCode.toUpperCase(), hm);
            }
        }
    }

    public static void cleanMutilingualCache() {
        DBResourceAccessService.initLanguageCache();
        DBResourceAccessService.getCacheService(true).clear();
        DBResourceAccessService.getCacheService(false).clear();
    }

    public static Integer getLanIdByCode(Locale locale) {
        Map<String, Object> languageMap;
        String lanCode = I18nUtil.getLocaleStr(locale);
        if (MUTILLINGUAL_CACHE.size() == 0) {
            DBResourceAccessService.initLanguageCache();
        }
        if ((languageMap = MUTILLINGUAL_CACHE.get(lanCode.toUpperCase())) != null) {
            return ConvertUtil.toInteger(languageMap.get("lanid"));
        }
        return null;
    }

    static {
        DBResourceAccessService.initLanguageCache();
        DBResourceAccessService.initLanguageHM();
    }
}

