/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.i18n;

import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18nConfig {
    private static I18nConfig instance;
    private static Map<String, String> langMap;

    private I18nConfig() {
    }

    public static I18nConfig getInstance() {
        if (instance == null) {
            instance = new I18nConfig();
            I18nConfig.initByDB();
        }
        return instance;
    }

    public static void initByDB() {
        String settings = XtcsUtil.getConfigValueFromXtcs("SYSTEM_LANGUAGE");
        if (!StringUtil.isEmpty(settings)) {
            langMap.clear();
            String[] langs = settings.split(",");
            String lang = null;
            String[] tmp = null;
            for (int i = 0; i < langs.length; ++i) {
                lang = langs[i];
                tmp = lang.split("=");
                langMap.put(tmp[0], tmp[1]);
            }
        }
    }

    public Map<String, String> getLangMap() {
        return langMap;
    }

    static {
        langMap = new LinkedHashMap<String, String>();
        langMap.put("zh_CN", "\u7b80\u4f53\u4e2d\u6587");
        langMap.put("zh_TW", "\u7e41\u4f53\u4e2d\u6587");
        langMap.put("en_US", "\u82f1\u6587");
    }
}

