/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log;

import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.log.EcpInvokeTypeEnum;
import com.ygsoft.ecp.service.log.IEcpInvokeLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.DateUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class EcpInvokeLogImpl
implements IEcpInvokeLog {
    Logger logger = null;
    private static int logSize = 0;
    private static final int DEFAULTSIZE = 10240;
    private static final String ECPLOGSIZE = "ecp.log.length";
    private static final String SPERATOR = "^";
    private ThreadLocal<List<MsgEntity>> timeList = new ThreadLocal<List<MsgEntity>>(){

        @Override
        protected List<MsgEntity> initialValue() {
            return new ArrayList<MsgEntity>();
        }
    };
    private static final int MAX_TIMELIST_SIZE = 9999;
    private static int maxInvokeTime = NumberConst.THOUSAND;
    private static final String MAX_INVOKETIME_FLAG = "ygsoft.http.maxInvokeTime";

    public Logger getLog() {
        return this.logger;
    }

    public void setLog(Logger newlog) {
        this.logger = newlog;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    private String getFinalMsg(String category, String msg) {
        String finalMsg = this.getMessage(msg);
        long startTime = System.currentTimeMillis();
        String token = Long.toString(startTime);
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setCategory(category);
        msgEntity.setSessionID(this.getSessionID());
        msgEntity.setToken(token);
        msgEntity.setUserID(this.getUserID());
        msgEntity.setUserName(this.getUserName());
        msgEntity.setMsg(finalMsg);
        msgEntity.setStartTime(startTime);
        msgEntity.setEstimatedTime(0L);
        return msgEntity.toString();
    }

    void setMDC() {
        MDC.put((String)"username", (String)this.getUserName());
    }

    private String getUserName() {
        String userName = "";
        try {
            String className = "com.ygsoft.ecp.core.framework.tool.DataContextUtil";
            Class cls = ClassUtil.getClass("com.ygsoft.ecp.core.framework.tool.DataContextUtil");
            Object context = ClassUtil.callMethod(cls, "getCurrentLoginContext", null);
            userName = (String)ClassUtil.callMethod(context, "getUserName", null);
        }
        catch (Throwable e) {
            return "";
        }
        return userName;
    }

    private String getUserID() {
        String userID = "";
        try {
            String className = "com.ygsoft.ecp.core.framework.tool.DataContextUtil";
            Class cls = ClassUtil.getClass("com.ygsoft.ecp.core.framework.tool.DataContextUtil");
            Object context = ClassUtil.callMethod(cls, "getCurrentLoginContext", null);
            userID = (String)ClassUtil.callMethod(context, "getUserId", null);
        }
        catch (Throwable e) {
            return "";
        }
        return userID;
    }

    public void error(String category, String msg) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.error(this.getFinalMsg(category, msg));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(String category, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.error(this.getFinalMsg(category, msg), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getMessage(String value) {
        int length;
        int logLength;
        String msg = " ";
        if (msg != null) {
            msg = value;
        }
        if ((logLength = this.getLogSize()) < (length = msg.length())) {
            length = logLength;
        }
        msg = msg.substring(0, length);
        return msg;
    }

    private int getLogSize() {
        if (logSize == 0) {
            String size = System.getProperty(ECPLOGSIZE);
            try {
                logSize = size == null ? 10240 : Integer.parseInt(size);
            }
            catch (Throwable e) {
                logSize = 10240;
            }
        }
        return logSize;
    }

    public void debug(String category, String msg) {
        if (this.isDebugEnabled()) {
            try {
                this.logger.debug(this.getFinalMsg(category, msg));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void debug(String category, String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            try {
                this.logger.debug(this.getFinalMsg(category, msg), throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public void info(String category, String msg) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.info(this.getFinalMsg(category, msg));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void info(String category, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.info(this.getFinalMsg(category, msg), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(String category, String msg) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.warn(this.getFinalMsg(category, msg));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(String category, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.warn(this.getFinalMsg(category, msg), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(String category, String msg) {
        if (this.isTraceEnabled()) {
            try {
                this.logger.trace(this.getFinalMsg(category, msg));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(String category, String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            try {
                this.logger.trace(this.getFinalMsg(category, msg), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String join(Object[] msgs) {
        if (msgs == null || msgs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object str : msgs) {
            if (str instanceof String) {
                if (!StringUtils.isBlank((CharSequence)((String)str))) {
                    sb.append(str);
                } else {
                    sb.append("null");
                }
            } else {
                sb.append(str);
            }
            sb.append(SPERATOR);
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Deprecated
    public String start(EcpInvokeTypeEnum category, String newMsg) {
        return this.start(category.name(), newMsg);
    }

    @Deprecated
    public void end(String token, EcpInvokeTypeEnum category, String msg) {
        this.end(token, category.name(), msg);
    }

    public String start(String category, String newMsg) {
        if (!this.logger.isInfoEnabled()) {
            return null;
        }
        try {
            long startTime = System.nanoTime();
            String token = Long.toString(startTime) + new Random().nextInt(NumberConst.HUNDRED);
            List<MsgEntity> times = this.timeList.get();
            if (times.size() > 9999) {
                this.timeList.get().clear();
            }
            MsgEntity msgInfo = this.getMsgEntity(token, category, newMsg, 0L);
            this.timeList.get().add(msgInfo);
            return token;
        }
        catch (Throwable e) {
            this.error(category, "\u8c03\u7528\u65e5\u5fd7,\u65e5\u5fd7\u5165\u6808\u51fa\u9519:" + e.getMessage());
            return null;
        }
    }

    private String getSessionID() {
        String sessionID = "";
        try {
            String dataContextUtil = "com.ygsoft.ecp.core.framework.tool.DataContextUtil";
            Class cls = ClassUtil.getClass("com.ygsoft.ecp.core.framework.tool.DataContextUtil");
            Object loginContext = ClassUtil.callMethod(cls, "getCurrentLoginContext", null);
            sessionID = (String)ClassUtil.callMethod(loginContext, "getTokenId", null);
        }
        catch (Throwable e) {
            return "";
        }
        return sessionID;
    }

    public void end(String token, String category, String msg) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        if (StringUtil.isEmpty(token)) {
            return;
        }
        try {
            List<MsgEntity> msgInfoList = this.timeList.get();
            MsgEntity start = null;
            if (msgInfoList.size() > 0 && StringUtils.equals((CharSequence)(start = msgInfoList.get(0)).getToken(), (CharSequence)token)) {
                this.setMaxInvoketime();
                long startTime = start.getStartTime();
                int nano2Millis = NumberConst.THOUSAND * NumberConst.THOUSAND;
                long estimatedTime = (System.nanoTime() - startTime) / (long)nano2Millis;
                if (estimatedTime >= (long)maxInvokeTime) {
                    StringBuilder sb = new StringBuilder();
                    for (MsgEntity msgInfo : msgInfoList) {
                        sb.append(msgInfo.toString());
                        sb.append("\r\n");
                    }
                    sb.append(this.getMsgEntity(token, category, msg, estimatedTime).toString());
                    this.setMDC();
                    this.logger.info(sb.toString());
                    msgInfoList.clear();
                }
            }
        }
        catch (Throwable e) {
            this.error(category, "\u8c03\u7528\u65e5\u5fd7,\u65e5\u5fd7\u51fa\u6808\u51fa\u9519:" + e.getMessage());
        }
    }

    private MsgEntity getMsgEntity(String token, String category, String msg, long estimatedTime) {
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setCategory(category);
        msgEntity.setSessionID(this.getSessionID());
        msgEntity.setToken(token);
        msgEntity.setUserID(this.getUserID());
        msgEntity.setUserName(this.getUserName());
        msgEntity.setMsg(msg);
        msgEntity.setStartTime(System.nanoTime());
        msgEntity.setEstimatedTime(estimatedTime);
        return msgEntity;
    }

    private void setMaxInvoketime() {
        String p = System.getProperty(MAX_INVOKETIME_FLAG);
        if (!StringUtils.isBlank((CharSequence)p)) {
            maxInvokeTime = Integer.parseInt(p);
        }
    }

    private class MsgEntity {
        String category;
        String sessionID;
        String token;
        String userID;
        String userName;
        String msg;
        long estimatedTime;
        long startTime = 0L;

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String newCategory) {
            this.category = newCategory;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public void setSessionID(String newSessionID) {
            this.sessionID = newSessionID;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String newToken) {
            this.token = newToken;
        }

        public void setUserName(String newUserName) {
            this.userName = newUserName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getUserID() {
            return this.userID;
        }

        public void setUserID(String newUserID) {
            this.userID = newUserID;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String newMsg) {
            this.msg = newMsg;
        }

        public long getEstimatedTime() {
            return this.estimatedTime;
        }

        public void setEstimatedTime(long newEstimatedTime) {
            this.estimatedTime = newEstimatedTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long newStartTime) {
            this.startTime = newStartTime;
        }

        public String toString() {
            String startTimeStr = DateUtil.date2Str("yyyy-MM-dd HH:mm:ss SSS", new Date(System.currentTimeMillis() - this.estimatedTime));
            return EcpInvokeLogImpl.this.join(new Object[]{Thread.currentThread().getId(), Thread.currentThread().getName(), startTimeStr, this.category, this.sessionID, this.token, this.userID, this.msg, this.estimatedTime});
        }
    }
}

