/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log.memlog2;

import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.internal.log.memlog2.MemoryLogAccessor;
import com.ygsoft.ecp.service.internal.log.memlog2.OutputBuilder;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.MemoryLogService;
import com.ygsoft.ecp.service.tool.CryptoUtil;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;

public class MemoryLogServiceImpl
implements MemoryLogService,
InitializingBean {
    private MemoryLogAccessor memoryLogAccessor;
    private OutputBuilder outputBuilder;
    private static final IEcpLog LOG = EcpLogFactory.getLog(MemoryLogServiceImpl.class);

    public void setMemoryLogAccessor(MemoryLogAccessor newmemoryLogAccessor) {
        this.memoryLogAccessor = newmemoryLogAccessor;
    }

    public void setOutputBuilder(OutputBuilder newoutputBuilder) {
        this.outputBuilder = newoutputBuilder;
    }

    public void afterPropertiesSet() throws BeanCreationException {
        if (this.memoryLogAccessor == null) {
            throw new BeanCreationException("\u65e5\u5fd7\u8bbf\u95ee\u5668\u672a\u8bbe\u7f6e...");
        }
        if (this.outputBuilder == null) {
            throw new BeanCreationException("\u65e5\u5fd7\u6784\u5efa\u5668\u672a\u8bbe\u7f6e...");
        }
    }

    public void start(String countRow) {
        int count;
        String clientip = this.memoryLogAccessor.getControler().getClientIP();
        if (StringUtil.isEmptyString(clientip)) {
            clientip = TokenHolder.INSTANCE.getClientIP();
        }
        if (StringUtil.isEmptyString(clientip)) {
            throw new RuntimeException("\u6ca1\u6709\u83b7\u53d6\u5230\u767b\u9646IP\u4fe1\u606f,\u53ef\u80fd\u5ba2\u6237\u672a\u767b\u5f55,\u8bf7\u767b\u5f55\u7cfb\u7edf\u540e\u518d\u622a\u53d6\u5185\u5b58\u65e5\u5fd7.");
        }
        try {
            count = StringUtil.isEmptyString(countRow) ? 2000 : Integer.parseInt(countRow);
            if (count <= 0 || count > 10000) {
                throw new RuntimeException("\u6027\u80fd\u8003\u8651,\u5185\u5b58\u65e5\u5fd7\u6761\u6570\u53ea\u80fd\u8bbe\u7f6e\u57280-10000\u4e4b\u95f4.");
            }
        }
        catch (Exception e) {
            count = 2000;
        }
        this.memoryLogAccessor.getControler().setEnabled(clientip, count);
        this.outputBuilder.deleteDir();
        LOG.info("\u5185\u5b58\u65e5\u5fd7\u5f00\u542f\uff0cIP\u4e3a:" + clientip);
    }

    public String getLogSnapshotAndStop() {
        try {
            String string = StringUtil.strToXml(this.memoryLogAccessor.read());
            return string;
        }
        finally {
            this.stop();
        }
    }

    public String getOutputAndStop(String zipName) {
        try {
            if (StringUtil.isEmpty(zipName)) {
                String string = this.getOutput("information.zip");
                return string;
            }
            String string = this.getOutput(zipName);
            return string;
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutputPathAndStop(String zipName) {
        try {
            this.outputBuilder.build(zipName);
            String localPath = this.outputBuilder.getProduce();
            String string = localPath + File.separator + zipName;
            return string;
        }
        finally {
            this.stop();
        }
    }

    public boolean isLogStarted() {
        return this.memoryLogAccessor.getControler().isEnabled();
    }

    public String getServerName() {
        return RuntimeEnvUtil.INSTANCE.getServerName();
    }

    public String getServerType() {
        return RuntimeEnvUtil.INSTANCE.getServerType().name();
    }

    public String getVersion() {
        return RuntimeEnvUtil.INSTANCE.getVersion();
    }

    private String getOutput(String zipName) {
        this.outputBuilder.build(zipName);
        String localPath = this.outputBuilder.getProduce();
        try {
            return "{\"url\":\"ResourceDownloadServlet?uri=" + CryptoUtil.StrToHex(localPath + "\\" + zipName) + "\"}";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void stop() {
        String clientip = this.memoryLogAccessor.getControler().getClientIP();
        this.memoryLogAccessor.getControler().setDisabled(clientip);
        LOG.info("\u5185\u5b58\u65e5\u5fd7\u5173\u95ed\uff0cIP\u4e3a:" + clientip);
    }
}

