/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log.memlog2;

import com.ygsoft.ecp.service.internal.log.memlog2.HtmlViewerOutputBuilder;
import com.ygsoft.ecp.service.internal.log.memlog2.OutputBuilder;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipOutputBuilder
extends HtmlViewerOutputBuilder
implements OutputBuilder {
    private static final String INFORMATION_ZIP = "information.zip";
    private static final int BUFFER = 2048;
    private static final IEcpLog LOG = EcpLogFactory.getLog(ZipOutputBuilder.class);

    public void build(String zipName) {
        super.build();
        String path = super.getProduce();
        try {
            FileOutputStream dest = new FileOutputStream(this.getZipFileName(zipName));
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            File f = new File(path);
            if (f.isDirectory()) {
                this.zipDir(out, data, f, f.getName(), zipName);
            } else {
                this.zipFile(out, data, f.getName(), f);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void build() {
        super.build();
        String path = super.getProduce();
        try {
            FileOutputStream dest = new FileOutputStream(this.getZipFileName());
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            File f = new File(path);
            if (f.isDirectory()) {
                this.zipDir(out, data, f, f.getName(), INFORMATION_ZIP);
            } else {
                this.zipFile(out, data, f.getName(), f);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void zipDir(ZipOutputStream out, byte[] dataBuffer, File dir, String base, String zipFileName) throws Exception {
        String baseName = base;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equalsIgnoreCase(zipFileName) || files[i].getName().lastIndexOf(".zip") > -1) continue;
            if (files[i].isDirectory()) {
                out.putNextEntry(new ZipEntry(baseName + File.separator + files[i].getName() + File.separator));
                this.zipDir(out, dataBuffer, files[i], baseName + File.separator + files[i].getName(), zipFileName);
                continue;
            }
            String fileName = baseName + File.separator + files[i].getName();
            this.zipFile(out, dataBuffer, fileName, files[i]);
        }
    }

    private void zipFile(ZipOutputStream out, byte[] dataBuffer, String fileName, File file) throws Exception {
        int count;
        LOG.info("\u52a0\u5165\u538b\u7f29\u6587\u4ef6\uff1a" + fileName);
        FileInputStream fi = new FileInputStream(file);
        BufferedInputStream origin = new BufferedInputStream(fi, 2048);
        ZipEntry entry = new ZipEntry(fileName);
        out.putNextEntry(entry);
        while ((count = origin.read(dataBuffer, 0, 2048)) != -1) {
            out.write(dataBuffer, 0, count);
        }
        origin.close();
    }

    private String getZipFileName(String zipName) {
        return super.getProduce() + File.separatorChar + zipName;
    }

    private String getZipFileName() {
        return super.getProduce() + File.separatorChar + INFORMATION_ZIP;
    }
}

