/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.tool;

import java.io.Serializable;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcpUUID
implements Serializable,
Comparable<EcpUUID> {
    private static final long serialVersionUID = -4856846361193249489L;
    private final long mostSigBits;
    private final long leastSigBits;
    private static volatile SecureRandom numberGenerator = null;

    private EcpUUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    public static EcpUUID randomUUID() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return new EcpUUID(randomBytes);
    }

    public String toString() {
        return EcpUUID.digits(this.mostSigBits >> 32, 8) + EcpUUID.digits(this.mostSigBits >> 16, 4) + EcpUUID.digits(this.mostSigBits, 4) + EcpUUID.digits(this.leastSigBits >> 48, 4) + EcpUUID.digits(this.leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    @Override
    public int compareTo(EcpUUID o) {
        return 0;
    }
}

