/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.tool;

import com.ygsoft.ecp.framework.actuator.TraceHolder;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.TraceLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ReflectionUtils;

public final class HTTPServiceRequester {
    private static final String REMOTE_SERVICE_SERVLET = "/grm/ecp/webcore/remoteService";
    private static final String NEW_REMOTE_SERVICE_SERVLET = "/assets/necp/remoteService";
    private static final String DEFUALT_ENCODER = "UTF-8";
    private static final int HTTP_CONNECTION_TIMEOUT = 2000;
    private static final int HTTP_READ_TIMEOUT = 30000;

    private HTTPServiceRequester() {
    }

    public static String send(String host, String beanName, String methodName, Object[] parameters) throws IOException {
        long beginTime = System.nanoTime();
        long callStartTime = System.currentTimeMillis();
        HttpURLConnection urlConnection = null;
        StringBuilder urlString = new StringBuilder(host);
        urlString.append(REMOTE_SERVICE_SERVLET);
        StringBuilder paramsBuilder = new StringBuilder();
        String token = TokenHolder.INSTANCE.getToken();
        if (token == null || token.trim().length() == 0) {
            paramsBuilder.append("ecp_token=ecp.mapp");
        } else {
            paramsBuilder.append("ecp_token=").append(token);
        }
        paramsBuilder.append("&mapp=").append("true");
        paramsBuilder.append("&trice_pid=").append(TraceHolder.INSTANCE.getId());
        paramsBuilder.append("&name=").append(beanName).append(".").append(methodName);
        paramsBuilder.append("&params=[");
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                String value = null;
                if (parameters[i] == null) {
                    if (i == parameters.length - 1) {
                        paramsBuilder.append(value);
                        continue;
                    }
                    paramsBuilder.append(value).append(",");
                    continue;
                }
                boolean b = parameters[i].getClass().isPrimitive();
                String string = value = b ? parameters[i].toString() : JSONUtil.toJsonString(parameters[i]);
                if (i == parameters.length - 1) {
                    paramsBuilder.append(URLEncoder.encode(value, DEFUALT_ENCODER));
                    continue;
                }
                paramsBuilder.append(URLEncoder.encode(value, DEFUALT_ENCODER)).append(",");
            }
        }
        paramsBuilder.append("]");
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
            URL u = new URL(urlString.toString());
            Constructor constructor = ReflectionUtils.findConstructor(clazz, (Object[])new Object[]{u, null});
            urlConnection = (HttpURLConnection)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{u, null});
        }
        catch (ClassNotFoundException ex) {
            urlConnection = (HttpURLConnection)new URL(urlString.toString()).openConnection();
        }
        TraceLogUtil.setTraceHeader(urlConnection);
        String currentMills = "Tim" + System.currentTimeMillis() + "ct";
        urlConnection.setRequestProperty("mapp_send_mills", currentMills);
        urlConnection.setConnectTimeout(2000);
        urlConnection.setReadTimeout(30000);
        urlConnection.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        urlConnection.setRequestMethod("POST");
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        byte[] bypes = paramsBuilder.toString().getBytes();
        urlConnection.getOutputStream().write(bypes);
        urlConnection.getOutputStream().flush();
        urlConnection.getOutputStream().close();
        HttpURLConnection httpConn = urlConnection;
        int statusCode = httpConn.getResponseCode();
        InputStream in = null;
        if (statusCode == 200) {
            in = httpConn.getInputStream();
        }
        if (in == null) {
            in = httpConn.getErrorStream();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(IOUtils.toString((InputStream)in, (Charset)Charset.forName(DEFUALT_ENCODER)));
        in.close();
        if (statusCode == 200) {
            String errCode = httpConn.getHeaderField("ERROR_CODE");
            if (errCode != null) {
                TraceLogUtil.processLog(urlConnection, errCode, "com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester", "send", "ecp.mapp", beginTime, callStartTime, REMOTE_SERVICE_SERVLET);
                throw new EcpRuntimeException(errCode, sb.toString());
            }
            TraceLogUtil.processLog(urlConnection, null, "com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester", "send", "ecp.mapp", beginTime, callStartTime, REMOTE_SERVICE_SERVLET);
            return sb.toString();
        }
        TraceLogUtil.processLog(urlConnection, sb.toString(), "com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester", "send", "ecp.mapp", beginTime, callStartTime, REMOTE_SERVICE_SERVLET);
        throw new RuntimeException(sb.toString());
    }

    public static String send4New(String host, String beanName, String methodName, Object[] parameters) throws IOException {
        return HTTPServiceRequester.send4New(2000, 30000, host, beanName, methodName, parameters);
    }

    public static String send4New(int connentTimeout, int readTimeout, String host, String beanName, String methodName, Object[] parameters) throws IOException {
        long beginTime = System.nanoTime();
        long callStartTime = System.currentTimeMillis();
        HttpURLConnection urlConnection = null;
        StringBuilder urlString = new StringBuilder(host);
        urlString.append(NEW_REMOTE_SERVICE_SERVLET);
        StringBuilder paramsBuilder = new StringBuilder();
        String token = TokenHolder.INSTANCE.getToken();
        if (token == null || token.trim().length() == 0) {
            paramsBuilder.append("ecp_token=ecp.mapp");
        } else {
            paramsBuilder.append("ecp_token=").append(token);
        }
        paramsBuilder.append("&mapp=").append("true");
        paramsBuilder.append("&trice_pid=").append(TraceHolder.INSTANCE.getId());
        paramsBuilder.append("&name=").append(beanName).append(".").append(methodName);
        paramsBuilder.append("&params=[");
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                String value = null;
                if (parameters[i] == null) {
                    if (i == parameters.length - 1) {
                        paramsBuilder.append(value);
                        continue;
                    }
                    paramsBuilder.append(value).append(",");
                    continue;
                }
                boolean b = parameters[i].getClass().isPrimitive();
                String string = value = b ? parameters[i].toString() : JSONUtil.toJsonString(parameters[i]);
                if (i == parameters.length - 1) {
                    paramsBuilder.append(URLEncoder.encode(value, DEFUALT_ENCODER));
                    continue;
                }
                paramsBuilder.append(URLEncoder.encode(value, DEFUALT_ENCODER)).append(",");
            }
        }
        paramsBuilder.append("]");
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.net.www.protocol.http.HttpURLConnection");
            URL u = new URL(urlString.toString());
            Constructor constructor = ReflectionUtils.findConstructor(clazz, (Object[])new Object[]{u, null});
            urlConnection = (HttpURLConnection)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{u, null});
        }
        catch (ClassNotFoundException ex) {
            urlConnection = (HttpURLConnection)new URL(urlString.toString()).openConnection();
        }
        TraceLogUtil.setTraceHeader(urlConnection);
        String currentMills = "Tim" + System.currentTimeMillis() + "ct";
        urlConnection.setRequestProperty("mapp_send_mills", currentMills);
        urlConnection.setConnectTimeout(connentTimeout);
        urlConnection.setReadTimeout(readTimeout);
        urlConnection.setRequestProperty("Accept-Charset", DEFUALT_ENCODER);
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        urlConnection.setRequestProperty("Cookie", "ecpDataContext.tokenId=" + token + "; closeEncry=true");
        urlConnection.setRequestMethod("POST");
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        byte[] bypes = paramsBuilder.toString().getBytes();
        urlConnection.getOutputStream().write(bypes);
        urlConnection.getOutputStream().flush();
        urlConnection.getOutputStream().close();
        HttpURLConnection httpConn = urlConnection;
        int statusCode = httpConn.getResponseCode();
        InputStream in = statusCode == 200 ? httpConn.getInputStream() : httpConn.getErrorStream();
        StringBuffer sb = new StringBuffer();
        sb.append(IOUtils.toString((InputStream)in, (Charset)Charset.forName(DEFUALT_ENCODER)));
        in.close();
        if (statusCode == 200) {
            String errCode = httpConn.getHeaderField("ERROR_CODE");
            if (errCode != null) {
                TraceLogUtil.processLog(urlConnection, errCode, "com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester", "send4New", "ecp.mapp", beginTime, callStartTime, NEW_REMOTE_SERVICE_SERVLET);
                throw new EcpRuntimeException(errCode, sb.toString());
            }
            TraceLogUtil.processLog(urlConnection, null, "com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester", "send4New", "ecp.mapp", beginTime, callStartTime, NEW_REMOTE_SERVICE_SERVLET);
            return sb.toString();
        }
        TraceLogUtil.processLog(urlConnection, sb.toString(), "com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester", "send4New", "ecp.mapp", beginTime, callStartTime, NEW_REMOTE_SERVICE_SERVLET);
        throw new RuntimeException(sb.toString());
    }
}

