/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.xml;

import com.ygsoft.ecp.service.internal.xml.XmlParse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParseImpl
implements XmlParse {
    private static DocumentBuilderFactory getDOMFactory() {
        DocumentBuilderFactory dbf;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        catch (Exception e) {
            dbf = null;
        }
        return dbf;
    }

    public Document parse(InputStream input) throws Exception {
        DocumentBuilder builder = XmlParseImpl.getDOMFactory().newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".getBytes("UTF-8")));
            }
        });
        return builder.parse(input);
    }

    public Document parse(File documentFile) throws Exception {
        DocumentBuilder builder = XmlParseImpl.getDOMFactory().newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".getBytes("UTF-8")));
            }
        });
        return builder.parse(documentFile);
    }

    public Document parse(String xmlString) throws Exception {
        InputSource source = new InputSource(new StringReader(xmlString));
        return this.parse(source);
    }

    public Document parse(InputSource inSource) throws Exception {
        DocumentBuilder builder = XmlParseImpl.getDOMFactory().newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>".getBytes("UTF-8")));
            }
        });
        return builder.parse(inSource);
    }
}

