/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.register;

import com.ygsoft.necp.eclipse.core.internal.registry.RegistryProperties;
import com.ygsoft.necp.eclipse.core.internal.registry.osgi.EquinoxRegistryStrategy;
import com.ygsoft.necp.eclipse.core.internal.registry.osgi.OSGIUtils;
import com.ygsoft.necp.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import com.ygsoft.necp.eclipse.core.runtime.IExtensionRegistry;
import com.ygsoft.necp.eclipse.core.runtime.RegistryFactory;
import com.ygsoft.necp.eclipse.core.runtime.spi.RegistryStrategy;
import com.ygsoft.necp.eclipse.osgi.service.datalocation.Location;
import java.io.File;

public final class OSGIExtensionRegistryFactory {
    private static Object masterRegistryKey = new Object();
    private static Object userRegistryKey = new Object();
    public static IExtensionRegistry defaultRegistry;
    private static final String STORAGE_DIR = "org.eclipse.core.runtime";

    public static Object getMasterRegistryKey() {
        return masterRegistryKey;
    }

    public static Object getUserRegistryKey() {
        return userRegistryKey;
    }

    public static IExtensionRegistry getRegistry() {
        if (defaultRegistry == null) {
            defaultRegistry = OSGIExtensionRegistryFactory.init();
        }
        return defaultRegistry;
    }

    public static IExtensionRegistry init() {
        RegistryStrategyOSGI strategy = null;
        Location configuration = OSGIUtils.getDefault().getConfigurationLocation();
        if (configuration == null) {
            RegistryProperties.setProperty((String)"eclipse.noRegistryCache", (String)"true");
            RegistryProperties.setProperty((String)"eclipse.noLazyRegistryCacheLoading", (String)"true");
            strategy = new RegistryStrategyOSGI(null, null, masterRegistryKey);
        } else {
            boolean[] readOnlyLocations;
            File[] registryLocations;
            File primaryDir = new File(configuration.getURL().getPath() + '/' + STORAGE_DIR);
            boolean primaryReadOnly = configuration.isReadOnly();
            Location parentLocation = configuration.getParentLocation();
            if (parentLocation != null) {
                File secondaryDir = new File(parentLocation.getURL().getFile() + '/' + STORAGE_DIR);
                registryLocations = new File[]{primaryDir, secondaryDir};
                readOnlyLocations = new boolean[]{primaryReadOnly, true};
            } else {
                registryLocations = new File[]{primaryDir};
                readOnlyLocations = new boolean[]{primaryReadOnly};
            }
            strategy = new EquinoxRegistryStrategy(registryLocations, readOnlyLocations, masterRegistryKey);
        }
        return RegistryFactory.createRegistry((RegistryStrategy)strategy, (Object)masterRegistryKey, (Object)userRegistryKey);
    }
}

