/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.internal.tool.Assert;
import com.ygsoft.ecp.service.internal.tool.ComparableComparator;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.exception.ParamCheckException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtil
implements IEcpToolLogic {
    private ArrayUtil() {
    }

    public static Object[] copyOf(Object[] original, int newLength) {
        return ArrayUtil.copyOf(original, newLength, original.getClass());
    }

    public static Object[] copyOf(Object[] original, int newLength, Class newType) {
        Object[] arr = newType != Object[].class ? (Object[])Array.newInstance(newType.getComponentType(), newLength) : new Object[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] arr = new byte[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static short[] copyOf(short[] original, int newLength) {
        short[] arr = new short[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] arr = new int[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static long[] copyOf(long[] original, int newLength) {
        long[] arr = new long[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] arr = new char[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static float[] copyOf(float[] original, int newLength) {
        float[] arr = new float[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static double[] copyOf(double[] original, int newLength) {
        double[] arr = new double[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] arr = new boolean[newLength];
        int len = original.length >= newLength ? newLength : original.length;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static Object[] copyOfRange(Object[] original, int from, int to) {
        return ArrayUtil.copyOfRange(original, from, to, original.getClass());
    }

    public static Object[] copyOfRange(Object[] original, int from, int to, Class newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        Object[] arr = newType != Object[].class ? (Object[])Array.newInstance(newType.getComponentType(), newLength) : new Object[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        byte[] arr = new byte[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static short[] copyOfRange(short[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        short[] arr = new short[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static int[] copyOfRange(int[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        int[] arr = new int[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static long[] copyOfRange(long[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        long[] arr = new long[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        char[] arr = new char[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static float[] copyOfRange(float[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        float[] arr = new float[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static double[] copyOfRange(double[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        double[] arr = new double[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static boolean[] copyOfRange(boolean[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", from + " > " + to));
        }
        boolean[] arr = new boolean[newLength];
        int ceil = original.length - from;
        int len = ceil >= newLength ? newLength : ceil;
        System.arraycopy(original, from, arr, 0, len);
        return arr;
    }

    public static int hashCode(long[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            long e = a[i];
            hash = 31 * hash + (int)(e ^ e >>> 32);
        }
        return hash;
    }

    public static int hashCode(int[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            hash = 31 * hash + a[i];
        }
        return hash;
    }

    public static int hashCode(short[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            hash = 31 * hash + a[i];
        }
        return hash;
    }

    public static int hashCode(char[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            hash = 31 * hash + a[i];
        }
        return hash;
    }

    public static int hashCode(byte[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            hash = 31 * hash + a[i];
        }
        return hash;
    }

    public static int hashCode(boolean[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            hash = 31 * hash + (a[i] ? 1231 : 1237);
        }
        return hash;
    }

    public static int hashCode(float[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            hash = 31 * hash + Float.floatToIntBits(a[i]);
        }
        return hash;
    }

    public static int hashCode(double[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            long e = Double.doubleToLongBits(a[i]);
            hash = 31 * hash + (int)(e ^ e >>> 32);
        }
        return hash;
    }

    public static int hashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            Object e = a[i];
            hash = 31 * hash + (e != null ? e.hashCode() : 0);
        }
        return hash;
    }

    public static int deepHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 1;
        for (int i = 0; i < a.length; ++i) {
            Object e = a[i];
            hash = 31 * hash + (e instanceof Object[] ? ArrayUtil.deepHashCode((Object[])e) : (e instanceof byte[] ? ArrayUtil.hashCode((byte[])e) : (e instanceof short[] ? ArrayUtil.hashCode((short[])e) : (e instanceof int[] ? ArrayUtil.hashCode((int[])e) : (e instanceof long[] ? ArrayUtil.hashCode((long[])e) : (e instanceof char[] ? ArrayUtil.hashCode((char[])e) : (e instanceof boolean[] ? ArrayUtil.hashCode((boolean[])e) : (e instanceof float[] ? ArrayUtil.hashCode((float[])e) : (e instanceof double[] ? ArrayUtil.hashCode((double[])e) : (e == null ? 0 : e.hashCode()))))))))));
        }
        return hash;
    }

    public static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int len = a1.length;
        if (len != a2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            boolean eq;
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean bl = e1.getClass() == e2.getClass() && !e1.getClass().isArray() ? (!(e1 instanceof Object[]) || !(e2 instanceof Object[]) ? (!(e1 instanceof byte[]) || !(e2 instanceof byte[]) ? (!(e1 instanceof short[]) || !(e2 instanceof short[]) ? (!(e1 instanceof int[]) || !(e2 instanceof int[]) ? (!(e1 instanceof long[]) || !(e2 instanceof long[]) ? (!(e1 instanceof char[]) || !(e2 instanceof char[]) ? (!(e1 instanceof boolean[]) || !(e2 instanceof boolean[]) ? (!(e1 instanceof float[]) || !(e2 instanceof float[]) ? (!(e1 instanceof double[]) || !(e2 instanceof double[]) ? e1.equals(e2) : Arrays.equals((double[])e1, (double[])e2)) : Arrays.equals((float[])e1, (float[])e2)) : Arrays.equals((boolean[])e1, (boolean[])e2)) : Arrays.equals((char[])e1, (char[])e2)) : Arrays.equals((long[])e1, (long[])e2)) : Arrays.equals((int[])e1, (int[])e2)) : Arrays.equals((short[])e1, (short[])e2)) : Arrays.equals((byte[])e1, (byte[])e2)) : ArrayUtil.deepEquals((Object[])e1, (Object[])e2)) : (eq = e1.equals(e2));
            if (eq) continue;
            return false;
        }
        return true;
    }

    public static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(short[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(char[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[').append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ").append(a[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String deepToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        ArrayUtil.deepToString(a, buf, new ArrayList());
        return buf.toString();
    }

    private static void deepToString(Object[] a, StringBuffer buf, List seen) {
        seen.add(a);
        buf.append('[');
        for (int i = 0; i < a.length; ++i) {
            Object e;
            if (i > 0) {
                buf.append(", ");
            }
            if ((e = a[i]) == null) {
                buf.append("null");
                continue;
            }
            if (!e.getClass().isArray()) {
                buf.append(e.toString());
                continue;
            }
            if (e instanceof Object[]) {
                if (seen.contains(e)) {
                    buf.append("[...]");
                    continue;
                }
                ArrayUtil.deepToString((Object[])e, buf, seen);
                continue;
            }
            buf.append(e instanceof byte[] ? ArrayUtil.toString((byte[])e) : (e instanceof short[] ? ArrayUtil.toString((short[])e) : (e instanceof int[] ? ArrayUtil.toString((int[])e) : (e instanceof long[] ? ArrayUtil.toString((long[])e) : (e instanceof char[] ? ArrayUtil.toString((char[])e) : (e instanceof boolean[] ? ArrayUtil.toString((boolean[])e) : (e instanceof float[] ? ArrayUtil.toString((float[])e) : (e instanceof double[] ? ArrayUtil.toString((double[])e) : ""))))))));
        }
        buf.append(']');
        seen.remove(seen.size() - 1);
    }

    public static int compare(Object[] v1, Object[] v2) {
        Object tmp2;
        Object tmp1;
        Assert.check(v1.length == v2.length);
        int ret = 0;
        for (int i = 0; i < v1.length && (ret = ComparableComparator.INSTANCE.compare(tmp1 = v1[i], tmp2 = v2[i])) == 0; ++i) {
        }
        return ret;
    }

    public static <T> T[] comboArray(T[] first, T[] second) {
        Assert.check(first != null && second != null);
        int firstSize = first.length;
        int secondSize = second.length;
        Object[] results = (Object[])Array.newInstance(first.getClass().getComponentType(), firstSize + secondSize);
        System.arraycopy(first, 0, results, 0, firstSize);
        System.arraycopy(second, 0, results, firstSize, secondSize);
        return results;
    }

    public static <T> List<T> arrayToList(T ... objs) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : objs) {
            result.add(obj);
        }
        return result;
    }
}

