/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.internal.crypto.BASE64Decoder;
import com.ygsoft.ecp.service.internal.crypto.BASE64Encoder;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.exception.CompressException;
import com.ygsoft.ecp.service.tool.exception.EncodeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class CompressUtil
implements IEcpToolLogic {
    private static final String ENCODENAME = "UTF-8";
    private static final int BUFFER_SIZE = 1024;

    private CompressUtil() {
    }

    /*
     * Loose catch block
     */
    public static byte[] compress(byte[] plainBytes) {
        ByteArrayOutputStream dest = null;
        DeflaterOutputStream out = null;
        dest = new ByteArrayOutputStream();
        out = new DeflaterOutputStream(dest);
        out.write(plainBytes);
        out.finish();
        byte[] byArray = dest.toByteArray();
        Object var5_5 = null;
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            if (dest != null) {
                dest.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return byArray;
        catch (IOException e) {
            try {
                throw new CompressException("E0208.0007", e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    if (dest != null) {
                        dest.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public static byte[] decompress(byte[] compressBytes) {
        byte[] byArray;
        ByteArrayInputStream dest = null;
        InflaterInputStream in = null;
        try {
            dest = new ByteArrayInputStream(compressBytes);
            in = new InflaterInputStream(dest);
            int count = 0;
            byte[] bytes = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((count = in.read(bytes, 0, 1024)) != -1) {
                out.write(bytes, 0, count);
            }
            byArray = out.toByteArray();
            Object var8_8 = null;
        }
        catch (Exception e) {
            try {
                throw new CompressException("E0208.0008", e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                StreamUtil.closeStream(dest);
                StreamUtil.closeStream(in);
                throw throwable;
            }
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(in);
        return byArray;
    }

    public static String decompressToString(byte[] compressBytes) {
        try {
            return new String(CompressUtil.decompress(compressBytes), ENCODENAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new CompressException("E0208.0008", e);
        }
    }

    public static String zipAndEncodeByte(byte[] inByte) {
        String string;
        ByteArrayOutputStream dest = null;
        DeflaterOutputStream out = null;
        try {
            String result;
            dest = new ByteArrayOutputStream();
            out = new DeflaterOutputStream(dest);
            out.write(inByte);
            out.finish();
            BASE64Encoder encoder = new BASE64Encoder();
            byte[] bytes = dest.toByteArray();
            string = result = encoder.encode(bytes);
            Object var8_8 = null;
        }
        catch (IOException e) {
            try {
                throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", e.getMessage()), e, new Object[0]);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                StreamUtil.closeStream(dest);
                StreamUtil.closeStream(out);
                throw throwable;
            }
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(out);
        return string;
    }

    public static String zipAndEncodeString(String inStr) {
        String string;
        ByteArrayOutputStream dest = null;
        DeflaterOutputStream out = null;
        try {
            String result;
            dest = new ByteArrayOutputStream();
            out = new DeflaterOutputStream(dest);
            out.write(inStr.getBytes(ENCODENAME));
            out.finish();
            BASE64Encoder encoder = new BASE64Encoder();
            byte[] bytes = dest.toByteArray();
            string = result = encoder.encode(bytes);
            Object var8_8 = null;
        }
        catch (IOException e) {
            try {
                throw new EncodeException("E0208.0013", EcpI18nUtil.localizedString("E0208.0013", e.getMessage()), e, new Object[0]);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                StreamUtil.closeStream(dest);
                StreamUtil.closeStream(out);
                throw throwable;
            }
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(out);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String zipAndEncodeFile(String fileName) throws Exception {
        String string;
        ByteArrayOutputStream dest = null;
        DeflaterOutputStream out = null;
        FileInputStream in = null;
        try {
            dest = new ByteArrayOutputStream();
            out = new DeflaterOutputStream(dest);
            in = new FileInputStream(fileName);
            byte[] buffer = new byte[1024];
            int count = -1;
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.finish();
            BASE64Encoder encoder = new BASE64Encoder();
            string = encoder.encode(dest.toByteArray());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            StreamUtil.closeStream(dest);
            StreamUtil.closeStream(in);
            StreamUtil.closeStream(out);
            throw throwable;
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(in);
        StreamUtil.closeStream(out);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String zipAndEncodeFile(File file) throws Exception {
        String string;
        ByteArrayOutputStream dest = null;
        DeflaterOutputStream out = null;
        FileInputStream in = null;
        try {
            dest = new ByteArrayOutputStream();
            out = new DeflaterOutputStream(dest);
            in = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int count = -1;
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.finish();
            BASE64Encoder encoder = new BASE64Encoder();
            string = encoder.encode(dest.toByteArray());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            StreamUtil.closeStream(dest);
            StreamUtil.closeStream(in);
            StreamUtil.closeStream(out);
            throw throwable;
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(in);
        StreamUtil.closeStream(out);
        return string;
    }

    public static String encodeStream(InputStream in) throws Exception {
        BASE64Encoder encoder = new BASE64Encoder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        encoder.encode(in, (OutputStream)out);
        return new String(out.toByteArray(), ENCODENAME);
    }

    public static String encodeString(String inStr) throws Exception {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(inStr.getBytes(ENCODENAME));
    }

    public static String decodeString(String inStr) throws Exception {
        BASE64Decoder decoder = new BASE64Decoder();
        return new String(decoder.decodeBuffer(inStr), ENCODENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unzipAndDecodeString(String inStr) throws Exception {
        String string;
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] inByte = decoder.decodeBuffer(inStr);
        ByteArrayInputStream dest = null;
        InflaterInputStream in = null;
        try {
            dest = new ByteArrayInputStream(inByte);
            in = new InflaterInputStream(dest);
            int count = 0;
            byte[] bytes = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((count = in.read(bytes, 0, 1024)) != -1) {
                out.write(bytes, 0, count);
            }
            string = new String(out.toByteArray(), ENCODENAME);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            StreamUtil.closeStream(dest);
            StreamUtil.closeStream(in);
            throw throwable;
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzipAndDecodeStringToByte(String inStr) throws Exception {
        byte[] byArray;
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] inByte = decoder.decodeBuffer(inStr);
        ByteArrayInputStream dest = null;
        InflaterInputStream in = null;
        try {
            dest = new ByteArrayInputStream(inByte);
            in = new InflaterInputStream(dest);
            int count = 0;
            byte[] bytes = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((count = in.read(bytes, 0, 1024)) != -1) {
                out.write(bytes, 0, count);
            }
            byArray = out.toByteArray();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            StreamUtil.closeStream(dest);
            StreamUtil.closeStream(in);
            throw throwable;
        }
        StreamUtil.closeStream(dest);
        StreamUtil.closeStream(in);
        return byArray;
    }
}

