/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.framework.jpa.extds.ExtDataSourceRuntime;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.dataaccess.IHibernateTemplate;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.datasource.DatasourceManager;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.internal.config.ApplicationConfig;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;

public final class DBUitl
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(DBUitl.class);
    private static String shareSchema = "";
    private static ISQLTemplate sqlTemplate;
    private static IHibernateTemplate hqlTemplate;
    private static final String RES_LOCATION_KEY = "necp.ext-datasource.location";
    private static Boolean isbindJpaTransaction;

    private DBUitl() {
    }

    /*
     * Unable to fully structure code
     */
    public static String getShareSchema() {
        block6: {
            extDataSource = ServerProps.getProperty((String)"necp.ext-datasource.location");
            conn = null;
            if (!StringUtils.isBlank((CharSequence)extDataSource)) break block6;
            conn = DatasourceManager.INSTANCE.getDefaultDataSource().getConnection();
            if (!StringUtils.isNotBlank((CharSequence)DBUitl.shareSchema)) ** GOTO lbl14
            var2_2 = DBUitl.shareSchema;
            DBUitl.closeConnection(conn);
            return var2_2;
        }
        try {
            compositeDataSource = ExtDataSourceRuntime.INSTANCE.selectExtDataSource();
            conn = compositeDataSource.getDataSource().getConnection();
lbl14:
            // 2 sources

            DBUitl.shareSchema = DatabaseType.MySql.equals((Object)(databaseType = ApplicationConfig.INSTANCE.getDatabaseType())) != false || DatabaseType.GBase.equals((Object)databaseType) != false ? conn.getCatalog() : (DatabaseType.H2.equals((Object)databaseType) != false ? "public" : (DatabaseType.MSSQL.equals((Object)databaseType) != false ? "dbo" : conn.getMetaData().getUserName()));
            var3_5 = DBUitl.shareSchema;
        }
        catch (Exception e) {
            try {
                if (DBUitl.LOG.isErrorEnabled()) {
                    DBUitl.LOG.error(e);
                }
                throw new EcpRuntimeException("GET_SHAREDB_SCHEMA_2", e);
            }
            catch (Throwable var4_6) {
                DBUitl.closeConnection(conn);
                throw var4_6;
            }
        }
        DBUitl.closeConnection(conn);
        return var3_5;
    }

    public static void closeConnection(Connection conn) {
        block3: {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error(e);
            }
        }
    }

    public static void closeConnStatementResultSet(Connection conn, Statement stat, ResultSet rs) {
        block11: {
            block10: {
                block9: {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error(e);
                    }
                }
                try {
                    if (stat != null) {
                        stat.close();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block10;
                    LOG.error(e);
                }
            }
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block11;
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Timestamp getDatabaseDate(String sql) {
        Timestamp sysdate = null;
        try {
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                conn = DatasourceManager.INSTANCE.getDefaultDataSource().getConnection();
                st = conn.createStatement();
                rs = st.executeQuery(sql);
                if (!rs.next()) return sysdate;
                sysdate = rs.getTimestamp(1);
                return sysdate;
            }
            catch (SQLException e) {
                e.printStackTrace();
                Timestamp timestamp = null;
                return timestamp;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                DBUitl.closeConnection(conn);
            }
        }
        catch (Throwable e6) {
            e6.printStackTrace();
        }
        return sysdate;
    }

    public static IHibernateTemplate getHibernateTemplate() {
        if (hqlTemplate != null) {
            return hqlTemplate;
        }
        IHibernateTemplate hibernateTemplate = null;
        if (RuntimeEnvUtil.INSTANCE.isUAP()) {
            hibernateTemplate = OSGiUtil.getServiceByFilter(IHibernateTemplate.class, "(org.springframework.osgi.bean.name=UAPDataaccessTemplateProxy)");
            if (hibernateTemplate == null) {
                hibernateTemplate = OSGiUtil.getServiceByFilter(IHibernateTemplate.class, "(org.springframework.osgi.bean.name=dataaccessTemplate)");
            }
        } else {
            hibernateTemplate = (IHibernateTemplate)OSGiUtil.getSpringBean(IHibernateTemplate.class.getName());
        }
        if (hibernateTemplate == null) {
            throw new RuntimeException("\u670d\u52a1" + IHibernateTemplate.class.getName() + "\u8fd8\u672a\u53d1\u5e03\u6210\u529f!");
        }
        return hibernateTemplate;
    }

    public static ISQLTemplate getSqlTemplate() {
        if (sqlTemplate != null) {
            return sqlTemplate;
        }
        ISQLTemplate sqlTemplate = null;
        if (RuntimeEnvUtil.INSTANCE.isUAP()) {
            sqlTemplate = OSGiUtil.getServiceByFilter(ISQLTemplate.class, "(org.springframework.osgi.bean.name=UAPDataaccessTemplateProxy)");
            if (sqlTemplate == null) {
                sqlTemplate = OSGiUtil.getServiceByFilter(ISQLTemplate.class, "(org.springframework.osgi.bean.name=dataaccessTemplate)");
            }
        } else {
            sqlTemplate = (ISQLTemplate)OSGiUtil.getSpringBean(ISQLTemplate.class.getName());
        }
        if (sqlTemplate == null) {
            throw new RuntimeException("\u670d\u52a1" + ISQLTemplate.class.getName() + "\u8fd8\u672a\u53d1\u5e03\u6210\u529f!");
        }
        return sqlTemplate;
    }

    public static String transBitAndSqlString(String x, String y) {
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isEmptyString(x) || StringUtil.isEmptyString(y)) {
            throw new RuntimeException("parameter can not empyt");
        }
        if (ApplicationConfig.INSTANCE.getDatabaseType() == DatabaseType.Oracle || ApplicationConfig.INSTANCE.getDatabaseType() == DatabaseType.DM || ApplicationConfig.INSTANCE.getDatabaseType() == DatabaseType.H2) {
            sb.append(" bitand(").append(x).append(",").append(y).append(") ");
        } else if (ApplicationConfig.INSTANCE.getDatabaseType() == DatabaseType.MySql || ApplicationConfig.INSTANCE.getDatabaseType() == DatabaseType.GBase) {
            sb.append(" ").append(x).append(" & ").append(y).append(" ");
        } else {
            sb.append(" ").append(x).append(" & ").append(y).append(" ");
        }
        return sb.toString();
    }

    public static boolean isOracle() {
        DatabaseType dbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        return dbType.equals((Object)DatabaseType.Oracle) || dbType.equals((Object)DatabaseType.DM);
    }

    public static boolean isDM() {
        return EcpService.getConfigService().getApplicationConfig().getDatabaseType().equals((Object)DatabaseType.DM);
    }

    public static boolean isH2() {
        return EcpService.getConfigService().getApplicationConfig().getDatabaseType().equals((Object)DatabaseType.H2);
    }

    public static boolean isMsSql() {
        return EcpService.getConfigService().getApplicationConfig().getDatabaseType().equals((Object)DatabaseType.MSSQL);
    }

    public static boolean isbindJpaTransaction() {
        if (isbindJpaTransaction == null) {
            String bindJpaTransaction = ServerProps.getProperty((String)"hibernate.isbindJpaTransaction", (String)"true");
            isbindJpaTransaction = "true".equals(bindJpaTransaction);
        }
        return isbindJpaTransaction;
    }
}

