/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.sql.SqlResource;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.entity.DDLOperatorMetaData;
import com.ygsoft.ecp.service.entity.TableMetaData;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DBUitl;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DDLUtil {
    private static final String SQL_CLASS = DDLUtil.class.getName();
    private static ISQLTemplate sqlTemplate;
    private static final IEcpLog LOG;
    private static final String O_METADATA_BYTABLENAME = "SELECT TABLE_NAME AS TABLENAME, COLUMN_ID AS COLUMNID, COLUMN_NAME AS COLUMNNAME, DATA_TYPE AS DATATYPE, DATA_LENGTH AS DATALENGTH, DATA_PRECISION AS DATAPRECISION, DATA_SCALE AS DATASCALE, NULLABLE  FROM USER_TAB_COLUMNS WHERE TABLE_NAME = :tname";
    private static final String O_METADATA_BYTABLENAMELIKE = "SELECT TABLE_NAME AS TABLENAME, COLUMN_ID AS COLUMNID, COLUMN_NAME AS COLUMNNAME, DATA_TYPE AS DATATYPE, DATA_LENGTH AS DATALENGTH, DATA_PRECISION AS DATAPRECISION, DATA_SCALE AS DATASCALE, NULLABLE  FROM USER_TAB_COLUMNS WHERE TABLE_NAME LIKE :tname";
    private static final String M_METADATA_BYTABLENAME = "SELECT TABLE_NAME AS TABLENAME, COLUMN_NAME AS COLUMNNAME, DATA_TYPE AS DATATYPE, CHARACTER_MAXIMUM_LENGTH AS DATALENGTH, NUMERIC_PRECISION AS DATAPRECISION, NUMERIC_SCALE AS DATASCALE, IS_NULLABLE AS NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = :tname";
    private static final String M_METADATA_BYTABLENAMELIKE = "SELECT TABLE_NAME AS TABLENAME, COLUMN_NAME AS COLUMNNAME, DATA_TYPE AS DATATYPE, CHARACTER_MAXIMUM_LENGTH AS DATALENGTH, NUMERIC_PRECISION AS DATAPRECISION, NUMERIC_SCALE AS DATASCALE, IS_NULLABLE AS NULLABLE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE :tname";
    private static Boolean SP_DDL_ENALBED_FLAG;
    public static final String PARAMS_INFO = "\u53c2\u6570\u540d\u79f0\uff1a{0}-\u53c2\u6570\u503c\uff1a{1};\n";

    private DDLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkSPDDLEnabled() {
        if (SP_DDL_ENALBED_FLAG != null) return SP_DDL_ENALBED_FLAG;
        Class<DDLUtil> clazz = DDLUtil.class;
        synchronized (DDLUtil.class) {
            try {
                DDLOperatorMetaData metaData = new DDLOperatorMetaData();
                metaData.setDomainCode("default");
                metaData.setTableName("XTCS");
                SP_DDL_ENALBED_FLAG = DDLUtil.isExistTable(metaData);
                if (!LOG.isInfoEnabled()) return SP_DDL_ENALBED_FLAG;
                LOG.info("\u5b58\u50a8\u8fc7\u7a0b\u53ef\u7528");
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u5b58\u50a8\u8fc7\u7a0b\u4e0d\u53ef\u7528\uff1a" + e.getMessage());
                }
                SP_DDL_ENALBED_FLAG = Boolean.FALSE;
            }
            return SP_DDL_ENALBED_FLAG;
        }
    }

    public static void newTable(DDLOperatorMetaData ... metaDatas) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5b89\u5168\u8981\u6c42ECP4.1\u7248\u672c\u79fb\u9664\u8be5API\u5b9e\u73b0,[PA_FMIS_BASE.NEWENTITY]\u5df2\u7ecf\u79fb\u9664,\u4e0d\u80fd\u4f7f\u7528\uff01");
        }
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528newTable\u65b9\u6cd5\uff1a");
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "tablename", metaData.getTableName()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "tableDesc", metaData.getTableDesc()));
            }
            Object[] paramList = new Object[]{metaData.getTableName(), metaData.getTableDesc(), DBUitl.getShareSchema()};
            DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_NEWENTITY", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
        }
    }

    public static void newTableByQuery(DDLOperatorMetaData ... metaDatas) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5b89\u5168\u8981\u6c42ECP4.1\u7248\u672c\u79fb\u9664\u8be5API\u5b9e\u73b0,[PA_FMIS_BASE.NEWENTITYBYQUERY\u5df2\u7ecf\u79fb\u9664,\u4e0d\u80fd\u4f7f\u7528\uff01");
        }
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528newTableByQuery\u65b9\u6cd5\uff1a");
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "tablename", metaData.getTableName()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "sqlText", metaData.getSqlText()));
            }
            Object[] paramList = new Object[]{metaData.getTableName(), metaData.getSqlText(), DBUitl.getShareSchema()};
            DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_NEWENTITYBYQUERY", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
        }
    }

    public static void removeTable(DDLOperatorMetaData ... metaDatas) {
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528removeTable\u65b9\u6cd5\uff1a");
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "tablename", metaData.getTableName()));
            }
            Object[] paramList = new Object[]{metaData.getTableName()};
            DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_DELENTITY", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
        }
    }

    public static void emptyTable(DDLOperatorMetaData ... metaDatas) {
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528emptyTable\u65b9\u6cd5\uff1a");
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "tablename", metaData.getTableName()));
            }
            Object[] paramList = new Object[]{metaData.getTableName()};
            DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_EMPTYENTITY", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
        }
    }

    public static void newObject(DDLOperatorMetaData ... metaDatas) {
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528newObject\u65b9\u6cd5\uff1a");
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "sqlText", metaData.getSqlText()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "isReplaced", metaData.getIsReplaced()));
            }
            Object[] paramList = new Object[]{metaData.getSqlText(), metaData.getIsReplaced()};
            DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_NEWOBJECT", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
        }
    }

    public static void removeObject(DDLOperatorMetaData ... metaDatas) {
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528removeObject\u65b9\u6cd5\uff1a");
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "sqlText", metaData.getSqlText()));
            }
            Object[] paramList = new Object[]{metaData.getSqlText()};
            DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_DELOBJECT", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
        }
    }

    public static boolean isExistTable(DDLOperatorMetaData metaData) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u8c03\u7528isExistTable\u65b9\u6cd5\uff1a");
            LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
            LOG.info(MessageFormat.format(PARAMS_INFO, "tablename", metaData.getTableName()));
        }
        HashMap<String, Object> mapIn = new HashMap<String, Object>();
        mapIn.put("I_TAB_NAME", metaData.getTableName());
        HashMap<String, Object> mapOut = new HashMap<String, Object>();
        mapOut.put("O_VALUE", 4);
        Map<?, ?> result = DDLUtil.getSqlTemplate().executeProcedure(mapIn, mapOut, SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_ISEXISENTITY", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}));
        return result.containsKey("O_VALUE") && Integer.parseInt(result.get("O_VALUE").toString()) > 0;
    }

    public static boolean isExistView(DDLOperatorMetaData metaData) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u8c03\u7528isExistView\u65b9\u6cd5\uff1a");
            LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
            LOG.info(MessageFormat.format(PARAMS_INFO, "viewname", metaData.getViewName()));
        }
        HashMap<String, Object> mapIn = new HashMap<String, Object>();
        mapIn.put("I_VIEW_NAME", metaData.getViewName());
        HashMap<String, Object> mapOut = new HashMap<String, Object>();
        mapOut.put("O_VALUE", 4);
        Map<?, ?> result = DDLUtil.getSqlTemplate().executeProcedure(mapIn, mapOut, SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_ISEXISVIEW", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}));
        return result.containsKey("O_VALUE") && Integer.parseInt(result.get("O_VALUE").toString()) > 0;
    }

    public static void addColumn(DDLOperatorMetaData ... metaDatas) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u8c03\u7528addColumn\u65b9\u6cd5\uff1a");
        }
        DDLUtil.commonColumnCtrl(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_ADDCOLUMN", (String[])new String[0]), metaDatas);
    }

    public static void modifyColumn(DDLOperatorMetaData ... metaDatas) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u8c03\u7528modifyColumn\u65b9\u6cd5\uff1a");
        }
        DDLUtil.commonColumnCtrl(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_MODIFYCOLUMN", (String[])new String[0]), metaDatas);
    }

    public static void delColumn(DDLOperatorMetaData ... metaDatas) {
        DDLUtil.commonColumnCtrl(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_DELCOLUMN", (String[])new String[0]), metaDatas);
    }

    public static void addPartitionIndex(String indexName, String tableName, String colName, int isUnique) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u8c03\u7528\u5206\u533a\u8868\u65b0\u589e\u7d22\u5f15\u65b9\u6cd5\uff1a");
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_INDEX_NAME", indexName));
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_TABLE_NAME", tableName));
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_IND_COLS", colName));
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_UNIQUE", isUnique));
        }
        Object[] paramList = new Object[]{indexName, tableName, colName, isUnique};
        DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_ADDPARTITIONINDEX", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
    }

    public static void addIndex(String indexName, String tableName, String colName, int isUnique) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u8c03\u7528\u666e\u901a\u8868\u65b0\u589e\u7d22\u5f15\u65b9\u6cd5\uff1a");
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_INDEX_NAME", indexName));
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_TABLE_NAME", tableName));
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_IND_COLS", colName));
            LOG.info(MessageFormat.format(PARAMS_INFO, "I_UNIQUE", isUnique));
        }
        Object[] paramList = new Object[]{indexName, tableName, colName, isUnique};
        DDLUtil.getSqlTemplate().executeProcedure(SqlResource.getSql((String)SQL_CLASS, (String)"C_CALLPR_ADDINDEX", (String[])new String[]{"DBUitl.getShareSchema()", DBUitl.getShareSchema()}), paramList);
    }

    private static void commonColumnCtrl(String callPRName, DDLOperatorMetaData ... metaDatas) {
        DDLUtil.commonColumnCtrlNoTranscation(callPRName, metaDatas);
    }

    private static void commonColumnCtrlNoTranscation(String callPRName, DDLOperatorMetaData ... metaDatas) {
        for (DDLOperatorMetaData metaData : metaDatas) {
            if (LOG.isInfoEnabled()) {
                LOG.info(MessageFormat.format(PARAMS_INFO, "domainCode", metaData.getDomainCode()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "tableName", metaData.getTableName()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "colList", metaData.getColList()));
                LOG.info(MessageFormat.format(PARAMS_INFO, "callPRName", callPRName));
            }
            Object[] paramList = new Object[]{metaData.getTableName(), metaData.getColList()};
            DDLUtil.getSqlTemplate().executeProcedure(callPRName, paramList);
        }
    }

    public static List<TableMetaData> getMetaDataByTableNameLike(String tableName) {
        String value = tableName + "%";
        DatabaseType dtype = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (dtype.equals((Object)DatabaseType.Oracle) || dtype.equals((Object)DatabaseType.DM)) {
            return DDLUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(O_METADATA_BYTABLENAMELIKE, "tname", value, TableMetaData.class);
        }
        if (dtype.equals((Object)DatabaseType.MySql)) {
            return DDLUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(M_METADATA_BYTABLENAMELIKE, "tname", value, TableMetaData.class);
        }
        return null;
    }

    public static List<TableMetaData> getMetaDataByTableName(String tableName) {
        DatabaseType dtype = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (dtype.equals((Object)DatabaseType.Oracle) || dtype.equals((Object)DatabaseType.DM)) {
            return DDLUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(O_METADATA_BYTABLENAME, "tname", tableName, TableMetaData.class);
        }
        if (dtype.equals((Object)DatabaseType.MySql)) {
            return DDLUtil.getSqlTemplate().findBySQLWithoutRowNumLimit(M_METADATA_BYTABLENAME, "tname", tableName, TableMetaData.class);
        }
        return null;
    }

    public static void setSqlTemplate(ISQLTemplate newsqlTemplate) {
        sqlTemplate = newsqlTemplate;
    }

    private static ISQLTemplate getSqlTemplate() {
        if (sqlTemplate == null) {
            sqlTemplate = DBUitl.getSqlTemplate();
        }
        return sqlTemplate;
    }

    static {
        LOG = EcpLogFactory.getLog(DDLUtil.class);
        SP_DDL_ENALBED_FLAG = null;
    }
}

