/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.internal.log.EcpLogUtils;
import com.ygsoft.ecp.service.storage.StorageWriteModel;
import com.ygsoft.ecp.service.tool.ConfigUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.exception.FileException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil
implements IEcpToolLogic {
    private FileUtil() {
    }

    public static void renameFile(String filePath, String newFileName) {
        com.ygsoft.ecp.service.async.FileUtil.renameFile(filePath, newFileName);
    }

    public static String[] listFilesByFilter(String dirPath, String ignoreFileSuffixes) {
        return com.ygsoft.ecp.service.async.FileUtil.listFilesByFilter(dirPath, ignoreFileSuffixes);
    }

    public static void smartCopyFile(String srcFilePath, String destPath) {
        com.ygsoft.ecp.service.async.FileUtil.smartCopyFile(srcFilePath, destPath);
    }

    public static void copyFile(String srcFilePath, String destFilePath) {
        com.ygsoft.ecp.service.async.FileUtil.copyFile(srcFilePath, destFilePath);
    }

    public static void copyFileToDir(String srcFilePath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.copyFileToDir(srcFilePath, destDirPath);
    }

    public static void copyFilesByFilter(String srcDirPath, String destDirPath, String ignoreFileSuffixes) {
        com.ygsoft.ecp.service.async.FileUtil.copyFilesByFilter(srcDirPath, destDirPath, ignoreFileSuffixes);
    }

    public static void copyDir(String srcDirPath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.copyDir(srcDirPath, destDirPath);
    }

    public static void copyDirToDir(String srcDirPath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.copyDirToDir(srcDirPath, destDirPath);
    }

    public static void copyLargeFileToDir(String srcFilePath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.copyLargeFileToDir(srcFilePath, destDirPath);
    }

    public static void copyLargeFile(String srcFilePath, String destFilePath) {
        com.ygsoft.ecp.service.async.FileUtil.copyLargeFile(srcFilePath, destFilePath);
    }

    public static void delete(String path) {
        com.ygsoft.ecp.service.async.FileUtil.delete(path);
    }

    public static void deleteDir(String dirPath) {
        com.ygsoft.ecp.service.async.FileUtil.deleteDir(dirPath);
    }

    public static void deleteFile(String filePath) {
        com.ygsoft.ecp.service.async.FileUtil.deleteFile(filePath);
    }

    public static void deleteFilesByFilter(String dirPath, String ignoreFileSuffixes) {
        com.ygsoft.ecp.service.async.FileUtil.deleteFilesByFilter(dirPath, ignoreFileSuffixes);
    }

    public static void moveDir(String srcDirPath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.moveDir(srcDirPath, destDirPath);
    }

    public static void moveDirToDir(String srcDirPath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.moveDirToDir(srcDirPath, destDirPath);
    }

    public static void moveFileToDir(String srcFilePath, String destDirPath) {
        com.ygsoft.ecp.service.async.FileUtil.moveFileToDir(srcFilePath, destDirPath);
    }

    public static void moveFilesByFilter(String srcDirPath, String destDirPath, String ignoreFileSuffixes) {
        com.ygsoft.ecp.service.async.FileUtil.moveFilesByFilter(srcDirPath, destDirPath, ignoreFileSuffixes);
    }

    public static byte[] readFile(String filePath) {
        try {
            return EcpService.getStorageService().getCommonFileStorage().read(filePath);
        }
        catch (IOException e) {
            throw new FileException("E0208.0017", e);
        }
    }

    public static int write(String path, byte[] content, StorageWriteModel model) {
        try {
            return EcpService.getStorageService().getCommonFileStorage().write(path, content, model);
        }
        catch (IOException e) {
            throw new FileException("E0208.0017", e);
        }
    }

    public static void writeTextFile(File file, String context) {
        FileUtil.writeTextFile(file, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeTextFile(File file, String context, boolean appendable) {
        OutputStreamWriter writer = null;
        try {
            try {
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    file.createNewFile();
                }
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, appendable), ConfigUtil.getCharsetName());
                writer.write(context);
                writer.close();
            }
            catch (IOException e) {
                EcpLogUtils.handleAndLogException(e);
                Object var6_7 = null;
                StreamUtil.closeWriter(writer);
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            StreamUtil.closeWriter(writer);
            throw throwable;
        }
        StreamUtil.closeWriter(writer);
    }

    public static String readTextFile(String fileName) {
        File file = new File(fileName);
        return FileUtil.readTextFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readListFile(InputStream is) {
        ArrayList<String> arrayList;
        BufferedReader reader = null;
        ArrayList<String> contextList = new ArrayList<String>();
        try {
            reader = new BufferedReader(new InputStreamReader(is, ConfigUtil.getCharsetName()));
            while (reader.ready()) {
                contextList.add(reader.readLine());
            }
            arrayList = contextList;
            Object var6_5 = null;
        }
        catch (Exception e) {
            List list;
            try {
                list = (List)EcpLogUtils.handleAndLogException(e);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                StreamUtil.closeReader(reader);
                throw throwable;
            }
            StreamUtil.closeReader(reader);
            return list;
        }
        StreamUtil.closeReader(reader);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeByteFile(File file, InputStream is) {
        FileOutputStream os = null;
        try {
            try {
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                os = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
                Object var6_6 = null;
            }
            catch (IOException e) {
                EcpLogUtils.handleAndLogException(e);
                Object var6_7 = null;
                StreamUtil.closeStream(os);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            StreamUtil.closeStream(os);
            throw throwable;
        }
        StreamUtil.closeStream(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = FileUtil.readTextFile(fis);
            Object var5_4 = null;
        }
        catch (FileNotFoundException e) {
            String string2;
            try {
                string2 = (String)EcpLogUtils.handleAndLogException(e);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                StreamUtil.closeStream(fis);
                throw throwable;
            }
            StreamUtil.closeStream(fis);
            return string2;
        }
        StreamUtil.closeStream(fis);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(InputStream is) {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is, ConfigUtil.getCharsetName()));
            StringBuffer buf = new StringBuffer();
            while (reader.ready()) {
                buf.append(reader.readLine()).append('\n');
            }
            string = buf.toString();
            Object var5_6 = null;
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = (String)EcpLogUtils.handleAndLogException(e);
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                StreamUtil.closeReader(reader);
                throw throwable;
            }
            StreamUtil.closeReader(reader);
            return string2;
        }
        StreamUtil.closeReader(reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getInnerJarFilesByFilter(String jarPath, String relativePath, String fileType) {
        ArrayList<String> fileNames = new ArrayList<String>();
        JarFile jarFile = null;
        jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> entrys = jarFile.entries();
        while (entrys.hasMoreElements()) {
            JarEntry jarEntry = entrys.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.startsWith(relativePath) || !entryName.endsWith(fileType)) continue;
            fileNames.add(entryName);
        }
        Object var9_9 = null;
        if (jarFile == null) return fileNames;
        try {
            jarFile.close();
            return fileNames;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return fileNames;
        {
            catch (Exception e) {
                EcpLogUtils.handleAndLogException(e);
                Object var9_10 = null;
                if (jarFile == null) return fileNames;
                try {
                    jarFile.close();
                    return fileNames;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return fileNames;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileCode(String fileName) {
        bin = null;
        code = null;
        try {
            bin = new BufferedInputStream(new FileInputStream(fileName));
            p = (bin.read() << 8) + bin.read();
            switch (p) {
                case 61371: {
                    code = "UTF-8";
                    ** break;
                }
                case 65534: {
                    code = "Unicode";
                    ** break;
                }
                case 65279: {
                    code = "UTF-16BE";
                    ** break;
                }
            }
            code = "GBK";
        }
        catch (Exception e) {
            EcpLogUtils.handleAndLogException(e);
            var5_6 = null;
            if (bin == null) return code;
            try {
                bin.close();
                return code;
            }
            catch (IOException e) {
                e.printStackTrace();
                return code;
            }
        }
lbl31:
        // 4 sources

        var5_5 = null;
        if (bin == null) return code;
        ** GOTO lbl-1000
        {
            catch (Throwable var4_11) {
                var5_7 = null;
                if (bin == null) throw var4_11;
                ** try [egrp 2[TRYBLOCK] [4 : 121->128)] { 
lbl39:
                // 1 sources

                bin.close();
                throw var4_11;
lbl41:
                // 1 sources

                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var4_11;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (IOException e) {}
            e.printStackTrace();
            return code;
            bin.close();
            return code;
        }
    }
}

