/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.json.IJSONService;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.exception.JSONException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(JSONUtil.class);
    private static final String DATAMODELUTIL_CLASS = "com.ygsoft.ecp.core.framework.tool.DataModelUtil";
    private static final String DATAMODELUTIL_METHOD = "setDynamicPropertyNullByOriValue";
    private static final String XML_ROOT_BEGIN = "<xml2json>";
    private static final String XML_ROOT_END = "</xml2json>";
    private static final String DYNAMIC_NODE = "dynamicProperties";
    private static IJSONService jsonService;

    private JSONUtil() {
    }

    public static String toJsonString(Object object) {
        IJSONService service = JSONUtil.getJSONService();
        if (service != null) {
            try {
                String json = service.toJsonString(object);
                return JSONUtil.deleteDynamicNode(json);
            }
            catch (StackOverflowError e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u4f20\u5165\u7684\u5bf9\u8c61\u5b58\u5728\u5faa\u73af\u5f15\u7528\u65e0\u6cd5\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c!" + object);
                }
                throw new UnsupportedOperationException("\u4f20\u5165\u7684\u5bf9\u8c61\u5b58\u5728\u5faa\u73af\u5f15\u7528\u65e0\u6cd5\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c!");
            }
        }
        throw new JSONException("E0208.0020", EcpI18nUtil.localizedString("E0208.0020", "JSONService \u6ca1\u6709\u627e\u5230"));
    }

    public static String toJsonWithoutJcls(Object object) {
        IJSONService service = JSONUtil.getJSONService();
        if (service != null) {
            try {
                String json = service.toJsonWithoutJcls(object);
                return JSONUtil.deleteDynamicNode(json);
            }
            catch (StackOverflowError e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u4f20\u5165\u7684\u5bf9\u8c61\u5b58\u5728\u5faa\u73af\u5f15\u7528\u65e0\u6cd5\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c!" + object);
                }
                throw new UnsupportedOperationException("\u4f20\u5165\u7684\u5bf9\u8c61\u5b58\u5728\u5faa\u73af\u5f15\u7528\u65e0\u6cd5\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c!");
            }
        }
        throw new JSONException("E0208.0020", EcpI18nUtil.localizedString("E0208.0020", "JSONService \u6ca1\u6709\u627e\u5230"));
    }

    public static <T> T fromJsonString(String json, Type javaType) {
        IJSONService service = JSONUtil.getJSONService();
        if (service != null) {
            T obj = null;
            try {
                obj = service.fromJsonString(json, javaType);
            }
            catch (StackOverflowError e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u4f20\u5165\u7684\u5b57\u7b26\u4e32\u5b58\u5728\u5faa\u73af\u5f15\u7528\u65e0\u6cd5\u8fdb\u884c\u53cd\u5e8f\u5217\u5316\u64cd\u4f5c!" + json);
                }
                throw new UnsupportedOperationException("\u4f20\u5165\u7684\u5b57\u7b26\u4e32\u5b58\u5728\u5faa\u73af\u5f15\u7528\u65e0\u6cd5\u8fdb\u884c\u53cd\u5e8f\u5217\u5316\u64cd\u4f5c!");
            }
            try {
                Class cls = ClassUtil.getClass(DATAMODELUTIL_CLASS);
                JSONUtil.setDynamicPropertyNullByOriValue(cls, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return obj;
        }
        throw new JSONException("E0208.0020", EcpI18nUtil.localizedString("E0208.0020", "JSONService \u6ca1\u6709\u627e\u5230"));
    }

    private static void setDynamicPropertyNullByOriValue(Class cls, Object obj) {
        if (obj != null) {
            if (obj instanceof List) {
                for (Object o : (List)obj) {
                    if (o instanceof List || o instanceof Map) {
                        JSONUtil.setDynamicPropertyNullByOriValue(cls, o);
                        continue;
                    }
                    ClassUtil.callMethod(cls, DATAMODELUTIL_METHOD, new Object[]{o});
                }
            } else if (obj instanceof Map) {
                Iterator it = ((Map)obj).entrySet().iterator();
                while (it.hasNext()) {
                    Object o = it.next().getValue();
                    if (o instanceof List || o instanceof Map) {
                        JSONUtil.setDynamicPropertyNullByOriValue(cls, o);
                        continue;
                    }
                    ClassUtil.callMethod(cls, DATAMODELUTIL_METHOD, new Object[]{o});
                }
            } else {
                ClassUtil.callMethod(cls, DATAMODELUTIL_METHOD, new Object[]{obj});
            }
        }
    }

    private static IJSONService getJSONService() {
        block3: {
            if (jsonService == null) {
                try {
                    jsonService = (IJSONService)Class.forName("com.ygsoft.ecp.service.json.impl.JSONService").newInstance();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return jsonService;
    }

    private static String deleteDynamicNode(String json) {
        StringBuilder sb = new StringBuilder();
        block0: while (json.indexOf(DYNAMIC_NODE) != -1) {
            int index = json.indexOf(DYNAMIC_NODE);
            sb.append(json.substring(0, index - 2));
            String str = json.substring(index);
            int startFlag = 0;
            int endFlag = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == '{') {
                    ++startFlag;
                    continue;
                }
                if (str.charAt(i) != '}' || ++endFlag != startFlag) continue;
                json = str.substring(i + 1);
                continue block0;
            }
        }
        sb.append(json);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String json2xml(String json) {
        if (StringUtil.isNotEmptyString(json)) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(JSONUtil.class.getClassLoader());
                Class cls = ClassUtil.getClass("de.odysseus.staxon.StaxonUtils");
                String string = ClassUtil.callMethod(cls, "json2xml", new Object[]{json}).toString();
                Object var5_6 = null;
                Thread.currentThread().setContextClassLoader(oldLoader);
                return string;
            }
            catch (ClassNotFoundException ex) {
                try {
                    String string = null;
                    Object var5_7 = null;
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    return string;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xml2json(String xml) {
        if (StringUtil.isNotEmptyString(xml)) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(JSONUtil.class.getClassLoader());
                String rootXml = XML_ROOT_BEGIN + xml + XML_ROOT_END;
                Class cls = ClassUtil.getClass("de.odysseus.staxon.StaxonUtils");
                String json = ClassUtil.callMethod(cls, "xml2json", new Object[]{rootXml}).toString();
                int index = json.indexOf(":");
                json = json.substring(index + 1);
                String string = json.substring(0, json.length() - 1);
                Object var8_9 = null;
                Thread.currentThread().setContextClassLoader(oldLoader);
                return string;
            }
            catch (ClassNotFoundException ex) {
                try {
                    String string = null;
                    Object var8_10 = null;
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    return string;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    Thread.currentThread().setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
        }
        return null;
    }
}

