/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.tool.ConvertUtil;
import com.ygsoft.ecp.service.tool.DBUtil;
import com.ygsoft.ecp.service.tool.I18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutilingualUtil
implements IEcpToolLogic {
    private static final String QUERY_LANGAUE_ENABLE = "SELECT PARAMVALUE FROM {0}ECP_XT_PARAMETER_VALUE WHERE PARAMNAME = ''LANGUAGELOCALE_ENABLE'' ";
    private static final String QUERY_DEFUALT_LANDGUAGE = "SELECT LANCODE FROM {0}ECP_LANGUAGE WHERE DEFAULTED=1 {1}";
    private static final String QUERY_STOP_FIELD_MYSQL = " AND IFNULL(STOPED, 0)=0 ";
    private static final String QUERY_STOP_FIELD = " AND NVL(STOPED, 0)=0 ";
    private static final String QUERY_STOP_FIELD_MSSQL = " AND ISNULL(STOPED, 0)=0 ";
    private static final String ECP_MUTILINGUAL_CLASSID = "ecp.app.params";

    private MutilingualUtil() {
    }

    public static String getMutilingualCacheValue(String cacheClassId, String paramName, String compid) {
        String key = MutilingualUtil.getKey(paramName, compid);
        return MutilingualUtil.getCache(cacheClassId).get(key);
    }

    public static void setMutilingualCache(String cacheClassId, String paramName, String compid, String data) {
        String key = MutilingualUtil.getKey(paramName, compid);
        if (data != null) {
            MutilingualUtil.getCache(cacheClassId).put(key, data);
        }
    }

    private static String getKey(String paramName, String compid) {
        String keyStr = compid;
        if (StringUtil.isNullOrTrimEmptyString(keyStr)) {
            keyStr = "";
        }
        return paramName + "-" + keyStr;
    }

    private static ICache<String, String> getCache(String cacheClassId) {
        return EcpService.getCacheService(cacheClassId);
    }

    public static boolean isLocaleEnable() {
        String paramName = "LANGUAGELOCALE_ENABLE";
        String caechKeyEnd = "";
        String value = MutilingualUtil.getMutilingualCacheValue(ECP_MUTILINGUAL_CLASSID, "LANGUAGELOCALE_ENABLE", "");
        if (StringUtil.isEmptyString(value)) {
            value = ConvertUtil.toString(MutilingualUtil.getParamValue());
            MutilingualUtil.setMutilingualCache(ECP_MUTILINGUAL_CLASSID, "LANGUAGELOCALE_ENABLE", "", value);
        }
        return "1".equals(value);
    }

    public static Locale getDefaultLocale() {
        String paramName = "MUL_LANGUAGELOCALE_DEFAULT";
        String caechKeyEnd = "";
        String language = MutilingualUtil.getMutilingualCacheValue(ECP_MUTILINGUAL_CLASSID, "MUL_LANGUAGELOCALE_DEFAULT", "");
        if (StringUtil.isEmptyString(language)) {
            language = MutilingualUtil.getDefaultLanguage();
            MutilingualUtil.setMutilingualCache(ECP_MUTILINGUAL_CLASSID, "MUL_LANGUAGELOCALE_DEFAULT", "", language);
        }
        if (null != language && language.indexOf("_") > -1) {
            String[] lang = language.split("_");
            return new Locale(lang[0], lang[1]);
        }
        return Locale.SIMPLIFIED_CHINESE;
    }

    private static int getParamValue() {
        String schemaPre;
        String sql;
        ISQLTemplate sqlTemplate = DBUtil.getSqlTemplate();
        List<Map> list = sqlTemplate.findBySQL(sql = MessageFormat.format(QUERY_LANGAUE_ENABLE, (schemaPre = DBUtil.getShareSchema()) + "."), Map.class);
        if (list != null && !list.isEmpty()) {
            return ConvertUtil.toInt(list.get(0).get("paramvalue"));
        }
        return 0;
    }

    private static String getDefaultLanguage() {
        ISQLTemplate sqlTemplate = DBUtil.getSqlTemplate();
        String schemaPre = DBUtil.getShareSchema();
        String stopFilter = QUERY_STOP_FIELD;
        DatabaseType databaseType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DBUtil.isMySql()) {
            stopFilter = QUERY_STOP_FIELD_MYSQL;
        } else if (DatabaseType.MSSQL.equals((Object)databaseType)) {
            stopFilter = QUERY_STOP_FIELD_MSSQL;
        }
        String sql = MessageFormat.format(QUERY_DEFUALT_LANDGUAGE, schemaPre + ".", stopFilter);
        List<Map> list = sqlTemplate.findBySQL(sql, Map.class);
        if (list != null && !list.isEmpty()) {
            return ConvertUtil.toString(list.get(0).get("lancode"));
        }
        return Locale.SIMPLIFIED_CHINESE.getLanguage() + "_" + Locale.SIMPLIFIED_CHINESE.getCountry();
    }

    public static String findDefaultLanguageFname(String zhChname) {
        if (StringUtil.isEmptyString(zhChname)) {
            return zhChname;
        }
        ArrayList<String> zhChnameList = new ArrayList<String>();
        zhChnameList.add(zhChname);
        Map<String, String> map = MutilingualUtil.getTransFnames(zhChnameList);
        if (map != null) {
            return map.get(zhChname);
        }
        return zhChname;
    }

    public static Map<String, String> getTransFnames(List<String> zhChnameList) {
        Locale locale = LogContextHolder.INSTANCE.getLocale();
        return MutilingualUtil.getTransFnamesByLocale(null, locale, zhChnameList);
    }

    public static Map<String, String> getTransFnamesByLocale(String schema, Locale locale, List<String> chNames) {
        return EcpService.getI18nResourceService().transDesignFnames(schema, locale, chNames);
    }

    public static String findDefaultRuntimeFname(String zhChname) {
        if (StringUtil.isEmptyString(zhChname)) {
            return zhChname;
        }
        ArrayList<String> zhChnameList = new ArrayList<String>();
        zhChnameList.add(zhChname);
        Map<String, String> map = MutilingualUtil.getTransRuntimeFnames(zhChnameList);
        if (map != null) {
            return map.get(zhChname);
        }
        return zhChname;
    }

    public static Map<String, String> getTransRuntimeFnames(List<String> zhChnameList) {
        Locale locale = LogContextHolder.INSTANCE.getLocale();
        return MutilingualUtil.getTransRuntimeFnamesByLocale(null, locale, zhChnameList);
    }

    public static Map<String, String> getTransRuntimeFnamesByLocale(String schema, Locale locale, List<String> chNames) {
        return EcpService.getI18nResourceService().transRuntimeFnames(schema, locale, chNames);
    }

    public static Map<String, Boolean> checkDicFnamesCount(List<String> chNames) {
        return EcpService.getI18nResourceService().checkDicFnamesCount(null, chNames);
    }

    public static Map<String, Boolean> checkDicFnamesCount(String schema, List<String> chNames) {
        return EcpService.getI18nResourceService().checkDicFnamesCount(schema, chNames);
    }

    public static void pushRuntimeLanCache(String loncode, Map<String, String> cacheMap) {
        EcpService.getI18nResourceService().pushRuntimeLanCache(I18nUtil.getLocale(loncode), cacheMap);
    }

    public static void pushRuntimeLanCache(Locale locale, Map<String, String> cacheMap) {
        EcpService.getI18nResourceService().pushRuntimeLanCache(locale, cacheMap);
    }

    public static void pushDesignLanCache(String loncode, Map<String, String> cacheMap) {
        EcpService.getI18nResourceService().pushDesignLanCache(I18nUtil.getLocale(loncode), cacheMap);
    }

    public static void pushDesignLanCache(Locale locale, Map<String, String> cacheMap) {
        EcpService.getI18nResourceService().pushDesignLanCache(locale, cacheMap);
    }

    public static void resetLanguageCache() {
        EcpService.getI18nResourceService().resetLanguageCache();
    }

    public static void cleanMutilingualCache() {
        EcpService.getI18nResourceService().cleanMutilingualCache();
    }

    public static Integer getLanIdByCode(Locale locale) {
        return EcpService.getI18nResourceService().getLanIdByCode(locale);
    }
}

