/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.executor.SoftLimitMRUCache;
import com.ygsoft.ecp.service.internal.tool.HTTPServiceProxy;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.RestfulUtil;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.webservice.WebServiceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceUtil
implements IEcpToolLogic {
    private static final SoftLimitMRUCache<String, Object> CACHE = new SoftLimitMRUCache(NumberConst.KB_INTEGER);
    private static final String WS_CALLER = "com.ygsoft.ecp.service.ws.client.WSCaller";
    private static final String WS_SUFFIX = "?wsdl";
    private static final Object NULL_OBJECT = new Object();

    private ServiceUtil() {
    }

    public static Object getRemoteService(String interfaceName, String vipAddress) {
        if (CACHE.containsKey(interfaceName)) {
            Object proxy = CACHE.get(interfaceName);
            return NULL_OBJECT.equals(proxy) ? null : proxy;
        }
        Object value = null;
        if (RuntimeEnvUtil.INSTANCE.getRemoteServiceHost() != null) {
            try {
                String address = vipAddress == null ? interfaceName : vipAddress;
                String host = HTTPServiceProxy.getRemoteHost(address);
                if (host != null) {
                    Class cls = ClassUtil.getClass(interfaceName);
                    HTTPServiceProxy proxy = new HTTPServiceProxy(host);
                    value = proxy.bind(cls);
                    CACHE.put(interfaceName, value);
                } else {
                    CACHE.put(interfaceName, NULL_OBJECT);
                }
            }
            catch (Exception e) {
                throw new EcpRuntimeException("E0208.0024", EcpI18nUtil.localizedString("E0208.0024", "\u670d\u52a1\u67e5\u627e\u5f02\u5e38"), e, new Object[0]);
            }
        }
        return value;
    }

    public static Object getRemoteService(String interfaceName) {
        return ServiceUtil.getRemoteService(interfaceName, null);
    }

    public static <T> T getRemoteService(Class<T> interfaceClass, String vipAddress) {
        return (T)ServiceUtil.getRemoteService(interfaceClass.getName(), vipAddress);
    }

    public static <T> T getRemoteService(Class<T> interfaceClass) {
        return (T)ServiceUtil.getRemoteService(interfaceClass.getName());
    }

    public static Object callCxfWebservice(String vipAddress, String methodName, Object parameters) {
        String host = ServiceUtil.getRemoteUrl(vipAddress);
        Class cls = null;
        try {
            cls = ClassUtil.getClass(WS_CALLER);
        }
        catch (Throwable e) {
            return null;
        }
        String url = host + vipAddress + WS_SUFFIX;
        Object result = ClassUtil.callMethod(cls, "call", new Object[]{url, methodName, parameters});
        return result;
    }

    public static Object callAxisWebservice(String vipAddress, String methodName, Object[] parameters) {
        String host = ServiceUtil.getRemoteUrl(vipAddress);
        String url = host + vipAddress + WS_SUFFIX;
        WebServiceUtil client = new WebServiceUtil();
        client.setUrl(url);
        Object[] result = client.callMethod(methodName, parameters);
        return result;
    }

    public static Object doGet(String vipAddress) {
        String encode = EcpService.getConfigService().getApplicationConfig().getCharset().name();
        return ServiceUtil.doGet(vipAddress, encode);
    }

    public static Object doGet(String vipAddress, String encode) {
        String host = ServiceUtil.getRemoteUrl(vipAddress);
        String url = host + vipAddress;
        return RestfulUtil.doGet(url, encode);
    }

    public static Object doPost(String vipAddress, String json) {
        String encode = EcpService.getConfigService().getApplicationConfig().getCharset().name();
        return ServiceUtil.doPost(vipAddress, json, encode);
    }

    public static Object doPost(String vipAddress, String json, String encode) {
        String host = ServiceUtil.getRemoteUrl(vipAddress);
        String url = host + vipAddress;
        return RestfulUtil.doPost(url, json, encode);
    }

    private static String getRemoteUrl(String vipAddress) {
        if (RuntimeEnvUtil.INSTANCE.getRemoteServiceHost() == null) {
            return null;
        }
        String host = HTTPServiceProxy.getRemoteHost(vipAddress);
        if (host == null) {
            throw new RuntimeException("host is not found");
        }
        return host;
    }

    public static void clearRemoteServiceCache() {
        CACHE.clear();
    }
}

