/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.exception.ParamCheckException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil
implements IEcpToolLogic {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int ORACLE_FIELD_MAXLENGTH = 4000;

    private StringUtil() {
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.length() < 1;
    }

    public static boolean isNotEmptyString(String str) {
        return str != null && str.length() > 0;
    }

    public static String[] formatStrings(String[] patterns, Object[] arguments) {
        String[] results = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            results[i] = MessageFormat.format(patterns[i], arguments);
        }
        return results;
    }

    public static String[] stringToArray(String inStr, String specialStr) {
        if (inStr == null || inStr.length() == 0) {
            return new String[0];
        }
        if (inStr.endsWith(specialStr)) {
            inStr = inStr.substring(0, inStr.length() - specialStr.length());
        }
        String[] result = new String[StringUtil.getSubStringCount(inStr, specialStr) + 1];
        int count = 0;
        int lastPos = 0;
        int pos = 0;
        pos = inStr.indexOf(specialStr);
        while (pos != -1) {
            result[count] = inStr.substring(lastPos, pos);
            lastPos = pos + specialStr.length();
            pos = inStr.indexOf(specialStr, lastPos);
            ++count;
        }
        result[count] = inStr.substring(lastPos);
        return result;
    }

    public static int getSubStringCount(String inStr, String specialStr) {
        int count = 0;
        int pos = inStr.indexOf(specialStr);
        while (pos != -1) {
            ++count;
            pos = inStr.indexOf(specialStr, pos + specialStr.length());
        }
        return count;
    }

    public static String arrayToStr(String[] array, String special) throws Exception {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            result.append(special).append(array[i]);
        }
        return result.substring(special.length());
    }

    public static String trim(String value) {
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public static boolean isNullOrTrimEmptyString(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String replaceAllChar(String source, char oldChar, char newChar) {
        if (source == null || source.length() < 1) {
            return source;
        }
        char[] ca = source.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != oldChar) continue;
            ca[i] = newChar;
        }
        return new String(ca);
    }

    public static boolean isEquals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        if (str1 != null) {
            return str1.equalsIgnoreCase(str2);
        }
        return str2 == null;
    }

    public static String replaceAll(String source, String oldString, String newString) {
        return StringUtils.replace((String)source, (String)oldString, (String)newString);
    }

    public static boolean isNull(String nullValue) {
        return nullValue == null || nullValue.equals("\"null\"") || nullValue.equals("null");
    }

    public static boolean getBoolean(String value) {
        return !StringUtil.isNull(value) && "true".equals(value.toLowerCase());
    }

    public static boolean getBoolean(String value, boolean defaultValue) {
        return StringUtil.isNull(value) ? defaultValue : "true".equals(value.toLowerCase());
    }

    public static String genCacheName(String classID, String typeID) {
        if ("".equals(StringUtil.viewFormat(typeID))) {
            return StringUtil.viewFormat(classID);
        }
        return StringUtil.viewFormat(classID) + "$" + StringUtil.viewFormat(typeID);
    }

    public static String viewFormat(String nullValue) {
        if (nullValue == null || nullValue.equals("\"null\"") || nullValue.equals("null")) {
            return "";
        }
        return nullValue;
    }

    public static String firstToUpperCase(String s) {
        char first;
        if (!StringUtil.isNullOrTrimEmptyString(s) && Character.isLowerCase(first = s.charAt(0))) {
            StringBuffer sb = new StringBuffer(s);
            sb.setCharAt(0, Character.toUpperCase(first));
            return sb.toString();
        }
        return s;
    }

    public static String firstToLowerCase(String s) {
        char first;
        if (!StringUtil.isNullOrTrimEmptyString(s) && Character.isUpperCase(first = s.charAt(0))) {
            StringBuffer sb = new StringBuffer(s);
            sb.setCharAt(0, Character.toLowerCase(first));
            return sb.toString();
        }
        return s;
    }

    public static <T> String ListToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T l : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(l);
        }
        return sb.toString();
    }

    public static <T> String listToStringWithQuote(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T l : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(l).append("'");
        }
        return sb.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            if (array[i] == null) continue;
            buffer.append(array[i]);
        }
        return buffer.toString();
    }

    public static String md5Hex(String data) {
        if (data == null) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "data must not be null"));
        }
        byte[] bytes = StringUtil.digest("MD5", data);
        return StringUtil.toHexString(bytes);
    }

    public static String sha1Hex(String data) {
        if (data == null) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "data must not be null"));
        }
        byte[] bytes = StringUtil.digest("SHA1", data);
        return StringUtil.toHexString(bytes);
    }

    private static String toHexString(byte[] bytes) {
        int l = bytes.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & bytes[i]) >>> 4];
            out[j++] = DIGITS[0xF & bytes[i]];
        }
        return new String(out);
    }

    private static byte[] digest(String algorithm, String data) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ParamCheckException("E0208.0026", e);
        }
        try {
            return digest.digest(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String randomMQConfigUrl(String mqConfig) {
        String failover = "failover:(";
        if (StringUtil.isNotEmptyString(mqConfig) && mqConfig.startsWith("failover:(")) {
            int index;
            String value = mqConfig;
            value = value.substring(value.indexOf("(") + 1, value.lastIndexOf(")"));
            String[] urlList = value.split(",");
            String[] targetList = new String[urlList.length];
            double temp = Math.random();
            int length = urlList.length;
            for (int i = index = (int)(temp * (double)length); i < length; ++i) {
                targetList[i - index] = urlList[i];
            }
            for (int j = 0; j < index; ++j) {
                targetList[j + length - index] = urlList[j];
            }
            value = "failover:(";
            for (int k = 0; k < length; ++k) {
                value = value + targetList[k];
                if (k >= length - 1) continue;
                value = value + ",";
            }
            value = value + ")";
            return value;
        }
        return mqConfig;
    }

    public static String strToXml(String value) {
        String result = value;
        result = StringUtil.stringReplace(value, "&", "&amp;");
        result = StringUtil.stringReplace(result, "<", "&lt;");
        result = StringUtil.stringReplace(result, ">", "&gt;");
        result = StringUtil.stringReplace(result, "'", "&apos;");
        result = StringUtil.stringReplace(result, "\"", "&quot;");
        result = StringUtil.stringReplace(result, "\n", "&#010;");
        result = StringUtil.stringReplace(result, "\r", "&#013;");
        return result;
    }

    public static String stringReplace(String value, String oldPattern, String newPattern) {
        if (oldPattern.equals(newPattern)) {
            return value;
        }
        StringBuffer result = new StringBuffer("");
        String searchStr = "";
        String newStr = "";
        int offset = -1;
        searchStr = value;
        newStr = value;
        while (!searchStr.equals("")) {
            offset = searchStr.indexOf(oldPattern);
            if (offset == -1) {
                result.append(newStr);
                break;
            }
            result.append(newStr.substring(0, offset) + newPattern);
            newStr = newStr.substring(offset + oldPattern.length());
            searchStr = searchStr.substring(offset + oldPattern.length());
        }
        return result.toString();
    }

    public static boolean isNumeric(String str) {
        if (StringUtil.isNotEmptyString(str)) {
            Pattern pattern = Pattern.compile("[0-9]*");
            return pattern.matcher(str).matches();
        }
        return false;
    }

    public static String encodeForHTML(String input) {
        return StringEscapeUtils.escapeHtml4((String)input);
    }

    public static String encodeForJavaScript(String input) {
        return StringEscapeUtils.escapeEcmaScript((String)input);
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String null2Str(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        return str;
    }

    public static boolean isChineseChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        ArrayList<Character.UnicodeBlock> list = new ArrayList<Character.UnicodeBlock>();
        list.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        list.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        list.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
        list.add(Character.UnicodeBlock.GENERAL_PUNCTUATION);
        list.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION);
        list.add(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS);
        return list.contains(ub);
    }

    public static String getDBMaxLenStr(String str) {
        if (!StringUtil.isNullOrTrimEmptyString(str)) {
            char[] charArr = str.toCharArray();
            boolean containsChineseChar = false;
            for (char c : charArr) {
                if (!StringUtil.isChineseChar(c)) continue;
                containsChineseChar = true;
                break;
            }
            if (!containsChineseChar) {
                if (str.length() <= 4000) {
                    return str;
                }
                str.substring(0, 4000);
            } else {
                int len = 0;
                char[] tmpCharArr = new char[charArr.length];
                for (int i = 0; i < charArr.length && len < 4000; ++i) {
                    len = StringUtil.isChineseChar(charArr[i]) ? (len += 2) : ++len;
                    tmpCharArr[i] = charArr[i];
                }
                return new String(tmpCharArr);
            }
        }
        return null;
    }
}

