/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.dataaccess.CommonTreeQueryBuilder;
import com.ygsoft.ecp.service.dataaccess.ICommonTreeDataFilter;
import com.ygsoft.ecp.service.dataaccess.ICommonTreeQueryDao;
import com.ygsoft.ecp.service.entity.AbstractEntity;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeUtil
implements IEcpToolLogic {
    private TreeUtil() {
    }

    public static <T extends AbstractEntity> List<T> findAncestors(String treeKey, String parentTreeKey, Class<T> cls, ICommonTreeDataFilter<T> dataFilter, String ... ids) {
        ICommonTreeQueryDao<T> treeQuery = new CommonTreeQueryBuilder<T>().build(cls);
        treeQuery.setKey(treeKey);
        treeQuery.setParentKey(parentTreeKey);
        treeQuery.setDataFilter(dataFilter);
        if (ids != null && ids.length == 1) {
            return treeQuery.findByStartWith(ids[0], true);
        }
        return treeQuery.findByStartWithMulti(ids, true);
    }

    public static <T extends AbstractEntity> List<T> findDescendants(String treeKey, String parentTreeKey, Class<T> cls, ICommonTreeDataFilter<T> dataFilter, String ... ids) {
        ICommonTreeQueryDao<T> treeQuery = new CommonTreeQueryBuilder<T>().build(cls);
        treeQuery.setKey(treeKey);
        treeQuery.setParentKey(parentTreeKey);
        treeQuery.setDataFilter(dataFilter);
        if (ids != null && ids.length == 1) {
            return treeQuery.findByStartWith(ids[0], false);
        }
        return treeQuery.findByStartWithMulti(ids, false);
    }
}

