/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.internal.crypto.BASE64Decoder;
import com.ygsoft.ecp.service.internal.crypto.BASE64Encoder;
import com.ygsoft.ecp.service.internal.xml.ICopyGetTargetNodeAction;
import com.ygsoft.ecp.service.internal.xml.ICopyXmlNodeAction;
import com.ygsoft.ecp.service.internal.xml.YgXmlNodeList;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.exception.ParamCheckException;
import com.ygsoft.ecp.service.tool.exception.XMLException;
import com.ygsoft.ecp.service.xml.XmlDoc;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil
implements IEcpToolLogic {
    public static final int SERVER_JUNIT = 10;
    public static final int SERVER_TYPE = 10;
    public static final int SERVER_TOMCAT = 3;
    public static final String ENCODENAME = "UTF-8";
    public static final int CONTINUE = 0;
    public static final int DONTCOPYCURRENTNODE = 1;
    public static final int DONTCOPYCURRENTNODEANDSUBNODE = 2;
    public static final int DONTCOPYCURRENTNODEATTRIBUTE = 4;
    private static IEcpLog log = EcpLogFactory.getLog(XmlUtil.class);
    public static final String ATTRPREFIX = "@";
    public static final char XPATHSEP = '/';
    public static final String CONDITIONPREFIX = "[";

    public static final String getExceptionAllMessage(Throwable e) {
        try {
            ByteArrayOutputStream bai = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)bai, false, ENCODENAME);
            e.printStackTrace(ps);
            ps.flush();
            bai.flush();
            String detailMessage = bai.toString(ENCODENAME);
            ps.close();
            bai.close();
            return detailMessage;
        }
        catch (Exception e2) {
            return e2.getMessage();
        }
    }

    public static String encodeString(String inStr) {
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            return encoder.encode(inStr.getBytes(ENCODENAME));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeString(String inStr) throws IOException {
        BASE64Decoder decoder = new BASE64Decoder();
        return new String(decoder.decodeBuffer(inStr), ENCODENAME);
    }

    private static String exportXml(Node node, boolean indenting, String encoding, boolean preserveSpace) {
        if (node == null) {
            return null;
        }
        if (XmlUtil.isAttributeNode(node)) {
            String name = node.getNodeName();
            return new StringBuffer("<").append(name).append(">").append(node.getNodeValue()).append("</").append(name).append(">").toString();
        }
        if (XmlUtil.isTextNode(node)) {
            return node.getNodeValue();
        }
        StringBuffer buffer = new StringBuffer();
        OutputFormat format = new OutputFormat(node.getOwnerDocument());
        format.setEncoding(encoding);
        format.setIndenting(indenting);
        format.setPreserveSpace(preserveSpace);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.asDOMSerializer();
            serial.serialize((Element)node);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u5e8f\u5217\u5316XML\u5931\u8d25", e);
            }
            throw new XMLException("E0208.0022", EcpI18nUtil.localizedString("E0208.0022", "\u5e8f\u5217\u5316XML\u5931\u8d25:"), e, new Object[0]);
        }
        buffer.append(stringOut.toString());
        return buffer.toString();
    }

    public static final boolean isTextNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 3;
    }

    public static final boolean isCommentNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 8;
    }

    public static final boolean isElementNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 1;
    }

    public static final boolean isAttributeNode(Node n) {
        if (n == null) {
            return false;
        }
        short nodeType = n.getNodeType();
        return nodeType == 2;
    }

    private static final Text createTextNode(Node node, String textValue) {
        Node temp = node;
        return temp.getOwnerDocument().createTextNode(textValue);
    }

    public static String getXml(Node node, boolean indenting, String encoding) {
        return XmlUtil.exportXml(node, indenting, encoding, true);
    }

    public static String getXml(Node node, boolean indenting, String encoding, boolean preserveSpace) {
        return XmlUtil.exportXml(node, indenting, encoding, preserveSpace);
    }

    public static final Node addAttribute(Node parentNode, Node attrNode) {
        if (attrNode == null) {
            return null;
        }
        if (parentNode == null) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "\u8981\u8bbe\u7f6e\u5c5e\u6027\u7684\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Node tmpNode = null;
        tmpNode = parentNode;
        if (XmlUtil.isElementNode(tmpNode) && XmlUtil.isAttributeNode(attrNode)) {
            return ((Element)parentNode).setAttributeNode((Attr)attrNode);
        }
        throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "\u52a0\u5165\u5c5e\u6027\u8282\u70b9\u5931\u8d25\uff0c\u4f20\u5165\u7684\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5fc5\u987b\u4e00\u4e2aElementNode\u548c\u4e00\u4e2aAttributeNode"));
    }

    public static final Node addAttribute(Node parentNode, String attrName, String attrValue) {
        if (parentNode == null) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "\u8981\u8bbe\u7f6e\u5c5e\u6027\u7684\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Attr atr = parentNode.getOwnerDocument().createAttribute(attrName);
        atr.setNodeValue(attrValue);
        return XmlUtil.addAttribute(parentNode, atr);
    }

    public static final Attr getAttribute(Node node, String attrName) {
        if (XmlUtil.isAttributeNode(node)) {
            if (log.isWarnEnabled()) {
                log.warn("\u5f53\u524d\u8282\u70b9\u4e3a\u5c5e\u6027\u8282\u70b9\uff0c\u518d\u5bf9\u6b64\u8282\u70b9\u5c5e\u6027\u64cd\u4f5c\u65e0\u6548");
            }
            return null;
        }
        return (Attr)node.getAttributes().getNamedItem(attrName);
    }

    public static final String getAttributeText(Node node, String attrName) {
        Attr attr = XmlUtil.getAttribute(node, attrName);
        return attr == null ? null : attr.getNodeValue();
    }

    public static final String getAttributeTextAsString(Node node, String attrName) {
        String str = XmlUtil.getAttributeText(node, attrName);
        return str == null ? "" : str;
    }

    public static final int getAttributeTextAsInt(Node node, String attrName) {
        String str = XmlUtil.getAttributeText(node, attrName);
        return str == null || str.equals("") ? 0 : Integer.parseInt(str);
    }

    public static final boolean getAttributeTextAsBoolean(Node node, String attrName) {
        String str = XmlUtil.getAttributeText(node, attrName);
        if (str == null) {
            return false;
        }
        if (str.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (str.equalsIgnoreCase("FALSE")) {
            return false;
        }
        try {
            int i = Integer.parseInt(str);
            return i != 0;
        }
        catch (Exception e) {
            return str.trim().length() > 0;
        }
    }

    public static final String deleteXmlHeader(String text) {
        if (text != null) {
            int iPos = text.indexOf("?>");
            if (iPos > 0) {
                int iLength = text.length();
                String result = text.substring(iPos + 2, iLength);
                int ipos2 = result.indexOf(60);
                if (ipos2 != 0) {
                    result = result.substring(ipos2, result.length());
                    return result;
                }
                return result;
            }
            return text;
        }
        return null;
    }

    public static final String deleteDTDHeader(String text) {
        if (text != null) {
            if (text.startsWith("<!")) {
                int index = text.indexOf(">");
                return text.substring(index + 1);
            }
            return text;
        }
        return null;
    }

    public static final String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        if (XmlUtil.isAttributeNode(node)) {
            return node.getNodeValue();
        }
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        if (len > 1) {
            return null;
        }
        if (len < 1) {
            return "";
        }
        Node cn = list.item(0);
        if (XmlUtil.isTextNode(cn)) {
            return cn.getNodeValue();
        }
        return null;
    }

    public static final String getNodeText(Node node) {
        if (node == null) {
            return null;
        }
        if (XmlUtil.isAttributeNode(node)) {
            return node.getNodeValue();
        }
        if (XmlUtil.isTextNode(node)) {
            return node.getNodeValue();
        }
        NodeList list = node.getChildNodes();
        int iLength = list.getLength();
        if (iLength != 1) {
            return "";
        }
        Node tmpNode = list.item(0);
        if (XmlUtil.isTextNode(tmpNode)) {
            return tmpNode.getNodeValue();
        }
        return "";
    }

    public static final Attr setAttriuteText(Node node, String attrName, String attrText) {
        if (XmlUtil.isAttributeNode(node)) {
            if (log.isWarnEnabled()) {
                log.warn("\u5f53\u524d\u8282\u70b9\u4e3a\u5c5e\u6027\u8282\u70b9\uff0c\u518d\u5bf9\u6b64\u8282\u70b9\u5c5e\u6027\u64cd\u4f5c\u65e0\u6548");
            }
            return null;
        }
        Attr atr = XmlUtil.getAttribute(node, attrName);
        if (atr == null) {
            XmlUtil.addAttribute(node, attrName, attrText);
            return XmlUtil.getAttribute(node, attrName);
        }
        atr.setValue(attrText);
        return atr;
    }

    public static final Node setNodeText(Node node, String nodeText) {
        if (node == null) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "\u8981\u8bbe\u7f6e\u503c\u7684\u8282\u70b9\u4e3a\u7a7a"));
        }
        if (XmlUtil.isAttributeNode(node)) {
            node.setNodeValue(nodeText);
            return node;
        }
        NodeList list = node.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            if (list.item(i) == null) continue;
            node.removeChild(list.item(i));
        }
        if (nodeText != null) {
            node.appendChild(XmlUtil.createTextNode(node, nodeText));
        }
        return node;
    }

    public static final String toBase64String(String str) {
        return XmlUtil.encodeString(str);
    }

    public static final String fromBase64String(String base64Str) throws IOException {
        return XmlUtil.decodeString(base64Str);
    }

    public static final boolean isAttrPath(String xpath) {
        return xpath != null && xpath.startsWith(ATTRPREFIX);
    }

    public static final Node copyNode(XmlDoc xml, Node parent, Node tNode, XmlDoc sxml, Node sNode) {
        return XmlUtil.copyNode(xml, parent, tNode, sxml, sNode, true);
    }

    public static final Node copyNode(XmlDoc xml, Node parent, Node tNode, XmlDoc sxml, Node sNode, boolean deep) {
        if (tNode == null) {
            tNode = xml.getNodeCanNew(parent, sNode.getNodeName());
        }
        NamedNodeMap sMap = sNode.getAttributes();
        int len = sMap.getLength();
        for (int i = 0; i < len; ++i) {
            Node atrNode = sMap.item(i);
            XmlUtil.setAttriuteText(tNode, atrNode.getNodeName(), atrNode.getNodeValue());
        }
        tNode.setNodeValue(sNode.getNodeValue());
        if (!deep) {
            return tNode;
        }
        NodeList childList = sNode.getChildNodes();
        len = childList.getLength();
        for (int i = 0; i < len; ++i) {
            Node childNode = childList.item(i);
            if (XmlUtil.isTextNode(childNode)) {
                if (len != 1) continue;
                XmlUtil.setNodeText(tNode, childNode.getNodeValue());
                continue;
            }
            XmlUtil.copyNode(xml, tNode, xml.getNode(tNode, childNode.getNodeName()), sxml, childNode);
        }
        return tNode;
    }

    public static final Node copyNode(XmlDoc xml, Node parent, Node tNode, XmlDoc sxml, Node sNode, boolean deep, ICopyXmlNodeAction action) {
        int i;
        int len;
        int copyType = 0;
        if (action != null) {
            copyType = action.beforeCopyNode(xml, parent, tNode, sxml, sNode);
        }
        if ((copyType & 2) == 2) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u8282\u70b9\u53ca\u5176\u5b50\u8282\u70b9\u90fd\u4e0d\u590d\u5236Y\uff0c\u76f4\u63a5\u8fd4\u56de\u76ee\u6807\u8282\u70b9");
            }
            return tNode;
        }
        if (tNode == null) {
            tNode = xml.getNodeCanNew(parent, sNode.getNodeName());
        }
        if ((copyType & 1) == 1) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u8282\u70b9\u4e0dCOPY\uff0c\u7ee7\u7eed\u5904\u7406\u5176\u5b50\u8282\u70b9");
            }
        } else {
            if ((copyType & 4) == 4) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5f53\u524d\u8282\u70b9\u7684\u5c5e\u6027\u4e0d\u590d\u5236");
                }
            } else {
                NamedNodeMap sMap = sNode.getAttributes();
                len = sMap.getLength();
                for (i = 0; i < len; ++i) {
                    Node atrNode = sMap.item(i);
                    XmlUtil.setAttriuteText(tNode, atrNode.getNodeName(), atrNode.getNodeValue());
                }
            }
            tNode.setNodeValue(sNode.getNodeValue());
        }
        if (!deep) {
            return tNode;
        }
        NodeList childList = sNode.getChildNodes();
        len = childList.getLength();
        for (i = 0; i < len; ++i) {
            Node childNode = childList.item(i);
            if (XmlUtil.isTextNode(childNode)) {
                if (len != 1) continue;
                XmlUtil.setNodeText(tNode, childNode.getNodeValue());
                continue;
            }
            Node vtNode = xml.getNode(tNode, childNode.getNodeName());
            XmlUtil.copyNode(xml, tNode, vtNode, sxml, childNode);
        }
        return tNode;
    }

    public static final Node copyNode(XmlDoc xml, Node parent, Node tNode, XmlDoc sxml, Node sNode, boolean deep, ICopyXmlNodeAction action, ICopyGetTargetNodeAction targetAction) {
        int i;
        int len;
        int copyType = 0;
        if (action != null) {
            copyType = action.beforeCopyNode(xml, parent, tNode, sxml, sNode);
        }
        if ((copyType & 2) == 2) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u8282\u70b9\u53ca\u5176\u5b50\u8282\u70b9\u90fd\u4e0d\u590d\u5236Y\uff0c\u76f4\u63a5\u8fd4\u56de\u76ee\u6807\u8282\u70b9");
            }
            return tNode;
        }
        if (tNode == null) {
            tNode = xml.getNodeCanNew(parent, sNode.getNodeName());
        }
        if ((copyType & 1) == 1) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f53\u524d\u8282\u70b9\u4e0dCOPY\uff0c\u7ee7\u7eed\u5904\u7406\u5176\u5b50\u8282\u70b9");
            }
        } else {
            if ((copyType & 4) == 4) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5f53\u524d\u8282\u70b9\u7684\u5c5e\u6027\u4e0d\u590d\u5236");
                }
            } else {
                NamedNodeMap sMap = sNode.getAttributes();
                len = sMap.getLength();
                for (i = 0; i < len; ++i) {
                    Node atrNode = sMap.item(i);
                    XmlUtil.setAttriuteText(tNode, atrNode.getNodeName(), atrNode.getNodeValue());
                }
            }
            tNode.setNodeValue(sNode.getNodeValue());
        }
        if (!deep) {
            return tNode;
        }
        NodeList childList = sNode.getChildNodes();
        len = childList.getLength();
        for (i = 0; i < len; ++i) {
            Node childNode = childList.item(i);
            if (XmlUtil.isTextNode(childNode)) {
                if (len != 1) continue;
                XmlUtil.setNodeText(tNode, childNode.getNodeValue());
                continue;
            }
            Node vtNode = null;
            vtNode = targetAction != null ? targetAction.getTargetNode(xml, tNode, sxml, childNode) : xml.getNode(tNode, childNode.getNodeName());
            XmlUtil.copyNode(xml, tNode, vtNode, sxml, childNode, deep, action, targetAction);
        }
        return tNode;
    }

    public static NodeList getNoTextChildNodes(Node node) {
        YgXmlNodeList list = new YgXmlNodeList();
        list.addAll(node.getChildNodes());
        return list;
    }

    public static final String getXPath(Node node) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> nodelist = new ArrayList<String>();
        if (XmlUtil.isAttributeNode(node)) {
            nodelist.add(ATTRPREFIX + node.getNodeName());
        } else {
            nodelist.add(node.getNodeName());
        }
        for (Node pnode = node.getParentNode(); pnode != null && pnode.getParentNode() != null; pnode = pnode.getParentNode()) {
            nodelist.add(pnode.getNodeName());
        }
        int length = nodelist.size();
        for (int i = length - 1; i >= 0; --i) {
            buffer.append("/");
            buffer.append((String)nodelist.get(i));
        }
        return buffer.toString();
    }

    public static final String getXPath(Node node, int parentLevel) {
        return XmlUtil.getXPath(node, parentLevel, '/');
    }

    public static final String getXPath(Node node, int parentLevel, char sep) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> nodelist = new ArrayList<String>();
        if (XmlUtil.isAttributeNode(node)) {
            nodelist.add(ATTRPREFIX + node.getNodeName());
        } else {
            nodelist.add(node.getNodeName());
        }
        int count = 0;
        boolean allPath = true;
        for (Node pnode = node.getParentNode(); pnode != null && pnode.getParentNode() != null; pnode = pnode.getParentNode()) {
            nodelist.add(pnode.getNodeName());
            if (++count < parentLevel || parentLevel <= 0) continue;
            allPath = pnode == null;
            break;
        }
        int length = nodelist.size();
        if (parentLevel < 0) {
            allPath = false;
            length += parentLevel;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (!allPath && i == length - 1) {
                buffer.append((String)nodelist.get(i));
                continue;
            }
            buffer.append(sep);
            buffer.append((String)nodelist.get(i));
        }
        return buffer.toString();
    }

    public static final String comboXpath(String p1, String p2, String curRootTag) {
        if (p1 == null || p1.length() < 1) {
            return p2;
        }
        if (p2 == null || p2.length() < 1) {
            return p1;
        }
        if (p2.charAt(p2.length() - 1) == '/') {
            return p2;
        }
        if (p2.toUpperCase().startsWith(new StringBuffer().append('/').append(curRootTag).toString())) {
            return p2;
        }
        if (p2.startsWith(String.valueOf('/'))) {
            return new StringBuffer().append(p1).append(p2).toString();
        }
        return new StringBuffer().append(p1).append('/').append(p2).toString();
    }
}

