/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool.webservice;

public class XSDType {
    private static final String[] typeNames = new String[]{"anyURI", "base64Binary", "boolean", "byte", "date", "dateTime", "gDay", "decimal", "double", "duration", "ENTITIES", "ENTITY", "float", "hexBinary", "ID", "IDREF", "IDREFS", "int", "integer", "language", "long", "gMonth", "gMonthDay", "Name", "NCName", "negativeInteger", "NMTOKEN", "NMTOKENS", "nonNegativeInteger", "nonPositiveInteger", "normalizedString", "NOTATION", "positiveInteger", "QName", "short", "string", "time", "token", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort", "gYear", "gYearMonth"};
    public static final int INITCONST = 8450;
    public static final int ANYURI = 8450;
    public static final int BASE64BINARY = 8451;
    public static final int BOOLEAN = 8452;
    public static final int BYTE = 8453;
    public static final int DATE = 8454;
    public static final int DATETIME = 8455;
    public static final int GDAY = 8456;
    public static final int DECIMAL = 8457;
    public static final int DOUBLE = 8458;
    public static final int DURATION = 8459;
    public static final int ENTITIES = 8460;
    public static final int ENTITY = 8461;
    public static final int FLOAT = 8462;
    public static final int HEXBINARY = 8463;
    public static final int ID = 8464;
    public static final int IDREF = 8465;
    public static final int IDREFS = 8466;
    public static final int INT = 8467;
    public static final int INTEGER = 8468;
    public static final int LANGUAGE = 8469;
    public static final int LONG = 8470;
    public static final int GMONTH = 8471;
    public static final int GMONTHDAY = 8472;
    public static final int NAME = 8473;
    public static final int NCNAME = 8474;
    public static final int NEGATIVEINTEGER = 8475;
    public static final int NMTOKEN = 8476;
    public static final int NMTOKENS = 8477;
    public static final int NONNEGATIVEINTEGER = 8478;
    public static final int NONPOSITIVEINTEGER = 8479;
    public static final int NORMALIZEDSTRING = 8480;
    public static final int NOTATION = 8481;
    public static final int POSITIVEINTEGER = 8482;
    public static final int QNAME = 8483;
    public static final int SHORT = 8484;
    public static final int STRING = 8485;
    public static final int TIME = 8486;
    public static final int TOKEN = 8487;
    public static final int UNSIGNEDBYTE = 8488;
    public static final int UNSIGNEDINT = 8489;
    public static final int UNSIGNEDLONG = 8490;
    public static final int UNSIGNEDSHORT = 8491;
    public static final int GYEAR = 8492;
    public static final int GYEARMONTH = 8493;
    public static final int LASTCONST = 8493;

    private static void checkRange(int type) {
        if (type < 8450 || type > 8493) {
            throw new RuntimeException("\u7ed9\u51fa\u7684XSD\u7c7b\u578b\u53c2\u6570\u503c\u8d85\u51fa\u6709\u6548\u8303\u56f4\uff0c\u4e0d\u662f\u4e00\u4e2a\u5df2\u5b9a\u4e49\u7c7b\u578b(" + type + ")");
        }
    }

    public static final String getTypeName(int type) {
        XSDType.checkRange(type);
        return typeNames[type - 8450];
    }

    public static final boolean isNumeric(int type) {
        XSDType.checkRange(type);
        return type == 8457 || type == 8467 || type == 8468 || type == 8462 || type == 8458 || type == 8484 || type == 8491 || type == 8489 || type == 8490 || type == 8488;
    }

    public static final boolean isNumeric(String typeName) {
        return XSDType.isNumeric(XSDType.getType(typeName));
    }

    public static final int getType(String typeName) {
        for (int i = 0; i < typeNames.length; ++i) {
            if (!typeNames[i].equalsIgnoreCase(typeName)) continue;
            return 8450 + i;
        }
        return -1;
    }
}

