/*
 * Decompiled with CFR 0.152.
 */
package com.hc.service;

import com.hc.pojo.CertParser;
import com.hc.util.GMUtils;
import com.hc.util.HNCAP7SignStructure;
import com.hc.util.SM2Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.util.encoders.Base64;

public class PKSC7VerifyService {
    private static Map<String, String> rootMap = new ConcurrentHashMap<String, String>();

    static {
        ArrayList<String> list = new ArrayList<String>();
        String xaca = "MIIC3jCCAoOgAwIBAgIQVXNHldKu7NuQWjrzLxXm+zAMBggqgRzPVQGDdQUAMC4xCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEPMA0GA1UEAwwGUk9PVENBMB4XDTE2MDMwMjAzMzUxM1oXDTM2MDIyNjAzMzUxM1owgYoxCzAJBgNVBAYTAkNOMQ4wDAYDVQQIDAVIZU5hbjESMBAGA1UEBwwJWmhlbmdaaG91MTcwNQYDVQQKDC5IZU5hbiBQcm92aW5jZSBJbmZvcm1hdGlvbiBEZXZlbG9wbWVudCBDby4gTHRkMQ8wDQYDVQQLDAZITlhBQ0ExDTALBgNVBAMMBFhBQ0EwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARaQQq0FZ9spqY+M3jOGjKtGTKwXjnXh/GH1qbKVxNtjYilWva8U3U8WJ1dsdtM1EJOb4jB9XvuKwwRdLLGoKXko4IBIjCCAR4wHwYDVR0jBBgwFoAUTDKxl9kzG8SmBcHG5YtiW/CXdlgwDwYDVR0TAQH/BAUwAwEB/zCBugYDVR0fBIGyMIGvMEGgP6A9pDswOTELMAkGA1UEBhMCQ04xDjAMBgNVBAoMBU5SQ0FDMQwwCgYDVQQLDANBUkwxDDAKBgNVBAMMA2FybDAqoCigJoYkaHR0cDovL3d3dy5yb290Y2EuZ292LmNuL2FybC9hcmwuY3JsMD6gPKA6hjhsZGFwOi8vbGRhcC5yb290Y2EuZ292LmNuOjM4OS9DTj1hcmwsT1U9QVJMLE89TlJDQUMsQz1DTjAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFGzzTThKvwmyE7ZvprxLXJI4gVpbMAwGCCqBHM9VAYN1BQADRwAwRAIgVLJO299JRy/g8iSlr9ULwZY7+B8EqxYpELWgeR/0CoQCIAqLgCQXgkfNlKWmGmO8PnyrDEeawUxRoFYVujjXULeT";
        String hnca = "MIICujCCAl6gAwIBAgIQTH8N39siWijpxaBrVMPQ+jAMBggqgRzPVQGDdQUAMC4xCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEPMA0GA1UEAwwGUk9PVENBMB4XDTEzMDEyMDAyMjMyM1oXDTMzMDExNTAyMjMyM1owZjELMAkGA1UEBhMCQ04xDjAMBgNVBAgMBUhlTmFuMRIwEAYDVQQHDAlaaGVuZ1pob3UxJDAiBgNVBAoMG0hlTmFuIENlcnRpZmljYXRlIEF1dGhvcml0eTENMAsGA1UEAwwESE5DQTBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABEobkq+7L8gZ6VxIrMp92LoXX8a+WGXIm7yDpwSwBfFLOOZyEF/51lijyszCgJSOwYEHHzBAhmUhEIX86gXfFH2jggEiMIIBHjAfBgNVHSMEGDAWgBRMMrGX2TMbxKYFwcbli2Jb8Jd2WDAPBgNVHRMBAf8EBTADAQH/MIG6BgNVHR8EgbIwga8wQaA/oD2kOzA5MQswCQYDVQQGEwJDTjEOMAwGA1UECgwFTlJDQUMxDDAKBgNVBAsMA0FSTDEMMAoGA1UEAwwDYXJsMCqgKKAmhiRodHRwOi8vd3d3LnJvb3RjYS5nb3YuY24vYXJsL2FybC5jcmwwPqA8oDqGOGxkYXA6Ly9sZGFwLnJvb3RjYS5nb3YuY246Mzg5L0NOPWFybCxPVT1BUkwsTz1OUkNBQyxDPUNOMA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUhekiQo5iGdsElgMSMdwRkN8OxrUwDAYIKoEcz1UBg3UFAANIADBFAiEA1x5QKzptmleXXwlPbNEMHPkiTO58TQSBvzl3Uht3RF8CIH0/53wGT0M0+rIEJNw3K137xDjRP7estRzh81l0BGMF";
        String szca = "MIIC1zCCAnugAwIBAgIQOb98H4Fw/QHUY36nJnCF1TAMBggqgRzPVQGDdQUAMC4xCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEPMA0GA1UEAwwGUk9PVENBMB4XDTEzMDcyODA3MzU0MFoXDTMzMDcyMzA3MzU0MFowgYIxCzAJBgNVBAYTAkNOMRIwEAYDVQQIDAlHdWFuZ2RvbmcxETAPBgNVBAcMCFNoZW56aGVuMScwJQYDVQQKDB5TaGVuWmhlbiBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxDTALBgNVBAsMBHN6Y2ExFDASBgNVBAMMC1NaQ0EgU00yIENBMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEzRUY/KZuM5HfDtcTJjFFHVgNzCLNWWJYEu3Z3EhlE6xaLrV1l9UCtDN8RwwTQIgJRUuQToFRssW8pJLthgzsjqOCASIwggEeMB8GA1UdIwQYMBaAFEwysZfZMxvEpgXBxuWLYlvwl3ZYMA8GA1UdEwEB/wQFMAMBAf8wgboGA1UdHwSBsjCBrzBBoD+gPaQ7MDkxCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEMMAoGA1UECwwDQVJMMQwwCgYDVQQDDANhcmwwKqAooCaGJGh0dHA6Ly93d3cucm9vdGNhLmdvdi5jbi9hcmwvYXJsLmNybDA+oDygOoY4bGRhcDovL2xkYXAucm9vdGNhLmdvdi5jbjozODkvQ049YXJsLE9VPUFSTCxPPU5SQ0FDLEM9Q04wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBSKe0ZazhFl2FO5UXpC70c9Coy46DAMBggqgRzPVQGDdQUAA0gAMEUCIQD+CsKp4bIWZwlF73iuDKjtTIHvqGyA8KrNGBxFpTIU0gIgCedgwc+Dkwf8CjlY8itWwJLyY1PqpBY3rT6NWUHW4yc=";
        String bjca = "MIIClzCCAjygAwIBAgIQdd/IVUqMA6s1z1nouGE7njAMBggqgRzPVQGDdQUAMC4xCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEPMA0GA1UEAwwGUk9PVENBMB4XDTEzMDExNjExMDczMVoXDTMzMDExMTExMDczMVowRDELMAkGA1UEBhMCQ04xDTALBgNVBAoMBEJKQ0ExDTALBgNVBAsMBEJKQ0ExFzAVBgNVBAMMDkJlaWppbmcgU00yIENBMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEioqqRw0qmjPYUF+6SWgWI1JzDHPGO0iTjSa5m0MuR/QB83yLBknccZ3T1qwdgv27e3qqKMdA3U3ipZkz6qxVk6OCASIwggEeMB8GA1UdIwQYMBaAFEwysZfZMxvEpgXBxuWLYlvwl3ZYMA8GA1UdEwEB/wQFMAMBAf8wgboGA1UdHwSBsjCBrzBBoD+gPaQ7MDkxCzAJBgNVBAYTAkNOMQ4wDAYDVQQKDAVOUkNBQzEMMAoGA1UECwwDQVJMMQwwCgYDVQQDDANhcmwwKqAooCaGJGh0dHA6Ly93d3cucm9vdGNhLmdvdi5jbi9hcmwvYXJsLmNybDA+oDygOoY4bGRhcDovL2xkYXAucm9vdGNhLmdvdi5jbjozODkvQ049YXJsLE9VPUFSTCxPPU5SQ0FDLEM9Q04wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBQf5s/Uj8UiKpdKKYoV5xbJkjTEtjAMBggqgRzPVQGDdQUAA0cAMEQCIFiMoH1BR7I3DmlPk5uhui/W2cX6iPAdnXI4LSPUg9T9AiB06XDp+wsPScMBYzRuY5xBC7IiC+nj+ehMDmkLD4mXKg==";
        list.add(xaca);
        list.add(hnca);
        list.add(szca);
        list.add(bjca);
        PKSC7VerifyService.rootMap(list);
    }

    private PKSC7VerifyService() {
    }

    public static PKSC7VerifyService getInstance() {
        return HolderClass.instance;
    }

    private static void rootMap(List<String> list) {
        for (String s : list) {
            PKSC7VerifyService.addRootCertBase64(s);
        }
    }

    public static long addRootCertBase64(String rootCertBase64) {
        byte[] octets;
        CertParser rootCert;
        block4: {
            try {
                rootCert = CertParser.getInstance(rootCertBase64);
                if (rootCert != null) break block4;
                return -1L;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -2L;
            }
        }
        byte[] extbuf = rootCert.getCert().getExtensionValue("2.5.29.14");
        if (extbuf != null && extbuf.length > 0 && (octets = ASN1OctetString.getInstance(extbuf).getOctets()) != null && octets.length > 0) {
            DEROctetString derOStr = (DEROctetString)DEROctetString.fromByteArray(octets);
            byte[] testbuf = derOStr.getOctets();
            String rootCertFP = GMUtils.bytesToHex(testbuf);
            rootMap.put(rootCertFP, rootCertBase64);
            return 0L;
        }
        return -3L;
    }

    public boolean verifyAttach(byte[] p7Sign) {
        HNCAP7SignStructure p7Structure = HNCAP7SignStructure.getInstanceFromByte(p7Sign);
        String src = p7Structure.getSrcStr();
        try {
            return this.verifyDettach(p7Sign, Base64.decode(src));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean verifyDettach(byte[] p7Sign, byte[] src) {
        HNCAP7SignStructure p7Structure = HNCAP7SignStructure.getInstanceFromByte(p7Sign);
        String sign = p7Structure.getSignature();
        String certStr = p7Structure.getCertStr();
        boolean flag = false;
        try {
            String hncasignbase64;
            long verify;
            if (this.rootCertVerify(certStr) && (verify = SM2Utils.Verify(src, Base64.decode(hncasignbase64 = SM2Utils.subSignature(Base64.decode(sign))), Base64.decode(certStr))) == 0L) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }

    private boolean rootCertVerify(String certStr) {
        boolean flag = false;
        try {
            CertParser cert = CertParser.getInstance(certStr);
            String rootCertOp = cert.getRootCertFP();
            String rootCert = rootMap.get(rootCertOp);
            if (rootCert != null) {
                byte[] certSign = cert.getCert().getSignature();
                String hncasignbase64 = SM2Utils.subSignature(certSign);
                byte[] certSrc = cert.getCert().getTBSCertificate();
                long verify = SM2Utils.Verify(certSrc, Base64.decode(hncasignbase64), Base64.decode(rootCert));
                if (verify == 0L) {
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public CertParser getCertInfo(byte[] p7Sign) {
        HNCAP7SignStructure p7Structure = HNCAP7SignStructure.getInstanceFromByte(p7Sign);
        String certStr = p7Structure.getCertStr();
        return CertParser.getInstance(certStr);
    }

    /* synthetic */ PKSC7VerifyService(PKSC7VerifyService pKSC7VerifyService) {
        this();
    }

    private static class HolderClass {
        private static final PKSC7VerifyService instance = new PKSC7VerifyService(null);

        private HolderClass() {
        }
    }
}

