/*
 * Decompiled with CFR 0.152.
 */
package com.hc.util;

import com.hc.constant.AlgConstant;
import com.hc.pojo.CertParser;
import java.io.IOException;
import org.bouncycastle162.asn1.ASN1BitString;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1TaggedObject;
import org.bouncycastle162.asn1.BERTaggedObject;
import org.bouncycastle162.asn1.DERNull;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.DERSet;
import org.bouncycastle162.asn1.DERTaggedObject;
import org.bouncycastle162.asn1.DLSequence;
import org.bouncycastle162.cert.X509CertificateHolder;
import org.bouncycastle162.util.encoders.Base64;

public class HNCAP7SignStructure {
    private final String srcStr;
    private final String certStr;
    private final String signature;
    private final ASN1Sequence rootSequence;
    private final boolean isAttach;
    private final String strSigAlg;

    public String getStrSigAlg() {
        return this.strSigAlg;
    }

    public String getSrcStr() {
        return this.srcStr;
    }

    public String getCertStr() {
        return this.certStr;
    }

    public String getSignature() {
        return this.signature;
    }

    public ASN1Sequence getRootSequence() {
        return this.rootSequence;
    }

    public boolean isAttach() {
        return this.isAttach;
    }

    public HNCAP7SignStructure(String _srcStr, String _certstr, String _signature, ASN1Sequence rootSequence, String SignAlg, boolean isAttach) {
        this.certStr = _certstr;
        this.srcStr = _srcStr;
        this.signature = _signature;
        this.rootSequence = rootSequence;
        this.isAttach = isAttach;
        this.strSigAlg = SignAlg;
    }

    public static HNCAP7SignStructure getInstanceFromByte(byte[] sigbuf) {
        ASN1Encodable[] seqArray;
        String certStr;
        String sourceData;
        boolean isAttach;
        String SignAlg;
        int SignInfoArryNum;
        ASN1Sequence rootSequence;
        block13: {
            byte[] certbuf;
            ASN1Sequence cert;
            DERTaggedObject dataObject;
            DEROctetString derOctetString;
            DERSequence sourceSeq;
            ASN1ObjectIdentifier objIdhash;
            ASN1Encodable[] rootarray;
            block12: {
                block11: {
                    try {
                        rootSequence = (ASN1Sequence)ASN1Sequence.fromByteArray(sigbuf);
                        rootarray = rootSequence.toArray();
                        if (rootarray[0] instanceof ASN1ObjectIdentifier) break block11;
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                SignInfoArryNum = 5;
                SignAlg = "";
                ASN1TaggedObject _taggedObject = null;
                _taggedObject = rootarray[1] instanceof BERTaggedObject ? (BERTaggedObject)rootarray[1] : (DERTaggedObject)rootarray[1];
                DERSequence seq3 = (DERSequence)_taggedObject.getObject();
                rootarray = seq3.toArray();
                if (rootarray.length == 5) break block12;
                return null;
            }
            isAttach = false;
            sourceData = "";
            DERSet AlgSeq = (DERSet)rootarray[1];
            ASN1Encodable[] AlgArray = AlgSeq.toArray();
            ASN1Sequence Algseq2 = (ASN1Sequence)AlgArray[0];
            ASN1Encodable[] algseqArray = Algseq2.toArray();
            if (algseqArray.length > 0 && (objIdhash = (ASN1ObjectIdentifier)algseqArray[0]) != null) {
                SignAlg = objIdhash.getId().equals(AlgConstant.GM_OID_SHA1.GetContent()) ? "SHA1with" : (objIdhash.getId().equals(AlgConstant.GM_OID_SHA256.GetContent()) ? "SHA256With" : (objIdhash.getId().equals(AlgConstant.GM_OID_SHA512.GetContent()) ? "SHA512With" : (objIdhash.getId().equals(AlgConstant.GM_OID_SM3_With_PK.GetContent()) ? "SM3With" : (objIdhash.getId().equals(AlgConstant.GM_OID_SM3.GetContent()) ? "SM3With" : ""))));
            }
            if ((sourceSeq = (DERSequence)rootarray[2]).size() == 2 && (derOctetString = (DEROctetString)(dataObject = (DERTaggedObject)sourceSeq.getObjectAt(1)).getObject()) != null) {
                sourceData = Base64.toBase64String(derOctetString.getOctets());
                isAttach = true;
            }
            DERTaggedObject certStruct = (DERTaggedObject)rootarray[3];
            ASN1Sequence certseq = (ASN1Sequence)certStruct.getObject();
            ASN1Encodable[] CertseqArray = certseq.toArray();
            certStr = "";
            if (CertseqArray != null && CertseqArray.length == 3 && CertseqArray[0] instanceof ASN1Sequence && CertseqArray[1] instanceof ASN1Sequence && CertseqArray[2] instanceof ASN1BitString) {
                cert = certseq;
                certbuf = cert.getEncoded();
                certStr = Base64.toBase64String(certbuf);
            } else if (CertseqArray != null && CertseqArray.length > 0 && CertseqArray[0] instanceof ASN1Sequence) {
                cert = (ASN1Sequence)CertseqArray[0];
                if (SignAlg.indexOf("RSA") != -1 && CertseqArray.length > 1) {
                    cert = (ASN1Sequence)CertseqArray[CertseqArray.length - 1];
                }
                certbuf = cert.getEncoded();
                certStr = Base64.toBase64String(certbuf);
            }
            CertParser instance = CertParser.getInstance(certStr);
            SignAlg = String.valueOf(SignAlg) + instance.getAlgorithm();
            DERSet signInfos = (DERSet)rootarray[4];
            ASN1Encodable[] signInfoArray = signInfos.toArray();
            ASN1Sequence _seq2 = (ASN1Sequence)signInfoArray[0];
            seqArray = _seq2.toArray();
            if (seqArray.length == SignInfoArryNum) break block13;
            return null;
        }
        DEROctetString sig = (DEROctetString)seqArray[SignInfoArryNum - 1];
        byte[] sss = sig.getOctets();
        String signature = Base64.toBase64String(sss);
        return new HNCAP7SignStructure(sourceData, certStr, signature, rootSequence, SignAlg, isAttach);
    }

    public static HNCAP7SignStructure HNCAP7AttTimeStampSignStructure(byte[] sigbuf) {
        ASN1Encodable[] seqArray;
        String certStr;
        String sourceData;
        boolean isAttach;
        String SignAlg;
        int SignInfoArryNum;
        ASN1Sequence rootSequence;
        block17: {
            byte[] certbuf;
            ASN1Sequence cert;
            DERTaggedObject dataObject;
            DEROctetString derOctetString;
            DERSequence sourceSeq;
            ASN1ObjectIdentifier objIdhash;
            ASN1Encodable[] rootarray;
            block16: {
                block15: {
                    block14: {
                        try {
                            rootSequence = (ASN1Sequence)ASN1Sequence.fromByteArray(sigbuf);
                            rootarray = rootSequence.toArray();
                            if (rootarray[0] instanceof ASN1ObjectIdentifier) break block14;
                            return null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    ASN1ObjectIdentifier objIdeRoot = (ASN1ObjectIdentifier)rootarray[0];
                    SignInfoArryNum = 5;
                    SignAlg = "";
                    if (objIdeRoot.getId().equals(AlgConstant.GM_OID_SM2_P7_SignedData.GetContent())) {
                        SignInfoArryNum = 5;
                        SignAlg = "SM2";
                        break block15;
                    }
                    if (objIdeRoot.getId().equals(AlgConstant.GM_OID_RSA_P7_SignedData.GetContent())) {
                        SignInfoArryNum = 6;
                        SignAlg = "RSA";
                        break block15;
                    }
                    return null;
                }
                DERTaggedObject _taggedObject = (DERTaggedObject)rootarray[1];
                DERSequence seq3 = (DERSequence)_taggedObject.getObject();
                rootarray = seq3.toArray();
                if (rootarray.length == 5) break block16;
                return null;
            }
            isAttach = false;
            sourceData = "";
            DERSet AlgSeq = (DERSet)rootarray[1];
            ASN1Encodable[] AlgArray = AlgSeq.toArray();
            ASN1Sequence Algseq2 = (ASN1Sequence)AlgArray[0];
            ASN1Encodable[] algseqArray = Algseq2.toArray();
            if (algseqArray.length > 0 && (objIdhash = (ASN1ObjectIdentifier)algseqArray[0]) != null) {
                SignAlg = objIdhash.getId().equals(AlgConstant.GM_OID_SHA1.GetContent()) ? "SHA1with" + SignAlg : (objIdhash.getId().equals(AlgConstant.GM_OID_SHA256.GetContent()) ? "SHA256With" + SignAlg : (objIdhash.getId().equals(AlgConstant.GM_OID_SHA512.GetContent()) ? "SHA512With" + SignAlg : (objIdhash.getId().equals(AlgConstant.GM_OID_SM3_With_PK.GetContent()) ? "SM3With" + SignAlg : (objIdhash.getId().equals(AlgConstant.GM_OID_SM3.GetContent()) ? "SM3With" + SignAlg : ""))));
            }
            if ((sourceSeq = (DERSequence)rootarray[2]).size() == 2 && (derOctetString = (DEROctetString)(dataObject = (DERTaggedObject)sourceSeq.getObjectAt(1)).getObject()) != null) {
                SignInfoArryNum = 6;
                sourceData = Base64.toBase64String(derOctetString.getOctets());
                isAttach = true;
            }
            DERTaggedObject certStruct = (DERTaggedObject)rootarray[3];
            ASN1Sequence certseq = (ASN1Sequence)certStruct.getObject();
            ASN1Encodable[] CertseqArray = certseq.toArray();
            certStr = "";
            if (CertseqArray != null && CertseqArray.length == 3 && CertseqArray[0] instanceof ASN1Sequence && CertseqArray[1] instanceof ASN1Sequence && CertseqArray[2] instanceof ASN1BitString) {
                cert = certseq;
                certbuf = cert.getEncoded();
                certStr = Base64.toBase64String(certbuf);
            } else if (CertseqArray != null && CertseqArray.length > 0 && CertseqArray[0] instanceof ASN1Sequence) {
                cert = (ASN1Sequence)CertseqArray[0];
                if (SignAlg.indexOf("RSA") != -1 && CertseqArray.length > 1) {
                    cert = (ASN1Sequence)CertseqArray[CertseqArray.length - 1];
                }
                certbuf = cert.getEncoded();
                certStr = Base64.toBase64String(certbuf);
            }
            DERSet signInfos = (DERSet)rootarray[4];
            ASN1Encodable[] signInfoArray = signInfos.toArray();
            ASN1Sequence _seq2 = (ASN1Sequence)signInfoArray[0];
            seqArray = _seq2.toArray();
            if (seqArray.length == SignInfoArryNum) break block17;
            return null;
        }
        DEROctetString sig = (DEROctetString)seqArray[SignInfoArryNum - 1];
        byte[] sss = sig.getOctets();
        String signature = Base64.toBase64String(sss);
        return new HNCAP7SignStructure(sourceData, certStr, signature, rootSequence, SignAlg, isAttach);
    }

    public static HNCAP7SignStructure getInstanceDetach(byte[] signature, byte[] certData) {
        try {
            ASN1Sequence sigseq = (ASN1Sequence)ASN1Sequence.fromByteArray(signature);
            X509CertificateHolder certholder = new X509CertificateHolder(certData);
            byte[] issuerDnbuf = certholder.getIssuer().getEncoded();
            DLSequence issuerDnSequence = (DLSequence)DLSequence.fromByteArray(issuerDnbuf);
            byte[] certsnbuf = certholder.getSerialNumber().toByteArray();
            ASN1Integer certsn = new ASN1Integer(certsnbuf);
            DLSequence certseq = (DLSequence)DLSequence.fromByteArray(certData);
            DERTaggedObject certStruct = new DERTaggedObject(0, certseq);
            ASN1Integer asn1Integer = new ASN1Integer(1L);
            DERSequence seq1 = new DERSequence(new ASN1Encodable[]{issuerDnSequence, certsn});
            ASN1ObjectIdentifier _objIde1 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM3_With_PK.GetContent());
            DERSequence seq2 = new DERSequence(new ASN1Encodable[]{_objIde1, DERNull.INSTANCE});
            ASN1ObjectIdentifier _objIde2 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_Sign.GetContent());
            DERSequence seq3 = new DERSequence(new ASN1Encodable[]{_objIde2, DERNull.INSTANCE});
            DEROctetString octstrSign = new DEROctetString(sigseq.getEncoded());
            DERSequence seq = new DERSequence(new ASN1Encodable[]{asn1Integer, seq1, seq2, seq3, octstrSign});
            DERSet signInfos = new DERSet(seq);
            ASN1Integer _asn1integer = new ASN1Integer(1L);
            ASN1ObjectIdentifier _objIde4 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM3_With_PK.GetContent());
            DERSequence seq4 = new DERSequence(new ASN1Encodable[]{_objIde4, DERNull.INSTANCE});
            DERSet _set = new DERSet(seq4);
            ASN1ObjectIdentifier _objIde5 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_P7_Data.GetContent());
            DERSequence seq5 = new DERSequence(_objIde5);
            DERSequence seq6 = new DERSequence(new ASN1Encodable[]{_asn1integer, _set, seq5, certStruct, signInfos});
            DERTaggedObject _taggedObject = new DERTaggedObject(0, seq6);
            ASN1ObjectIdentifier _objIdeRoot = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_P7_SignedData.GetContent());
            DLSequence rootSequence = new DLSequence(new ASN1Encodable[]{_objIdeRoot, _taggedObject});
            String certStr = Base64.toBase64String(certData);
            String sigData = Base64.toBase64String(signature);
            return new HNCAP7SignStructure("", certStr, sigData, rootSequence, "SM3withSM2", false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HNCAP7SignStructure getInstanceDetachRSA(byte[] signature, byte[] certData) {
        try {
            X509CertificateHolder certholder = new X509CertificateHolder(certData);
            byte[] issuerDnbuf = certholder.getIssuer().getEncoded();
            DLSequence issuerDnSequence = (DLSequence)DLSequence.fromByteArray(issuerDnbuf);
            byte[] certsnbuf = certholder.getSerialNumber().toByteArray();
            ASN1Integer certsn = new ASN1Integer(certsnbuf);
            DLSequence certseq = (DLSequence)DLSequence.fromByteArray(certData);
            DERSequence certarry = new DERSequence(new ASN1Encodable[]{certseq});
            DERTaggedObject certStruct = new DERTaggedObject(0, certarry);
            ASN1Integer asn1Integer = new ASN1Integer(1L);
            DERSequence seq1 = new DERSequence(new ASN1Encodable[]{issuerDnSequence, certsn});
            ASN1ObjectIdentifier _objIde1 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM3_With_PK.GetContent());
            DERSequence seq2 = new DERSequence(new ASN1Encodable[]{_objIde1, DERNull.INSTANCE});
            ASN1ObjectIdentifier _objIde2 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_Sign.GetContent());
            DERSequence seq3 = new DERSequence(new ASN1Encodable[]{_objIde2, DERNull.INSTANCE});
            DEROctetString octstrSign = new DEROctetString(signature);
            DERSequence seq = new DERSequence(new ASN1Encodable[]{asn1Integer, seq1, seq2, seq3, octstrSign});
            DERSet signInfos = new DERSet(seq);
            ASN1Integer _asn1integer = new ASN1Integer(1L);
            ASN1ObjectIdentifier _objIde4 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM3_With_PK.GetContent());
            DERSequence seq4 = new DERSequence(new ASN1Encodable[]{_objIde4, DERNull.INSTANCE});
            DERSet _set = new DERSet(seq4);
            ASN1ObjectIdentifier _objIde5 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_P7_Data.GetContent());
            DERSequence seq5 = new DERSequence(_objIde5);
            DERSequence seq6 = new DERSequence(new ASN1Encodable[]{_asn1integer, _set, seq5, certStruct, signInfos});
            DERTaggedObject _taggedObject = new DERTaggedObject(0, seq6);
            ASN1ObjectIdentifier _objIdeRoot = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_P7_SignedData.GetContent());
            DLSequence rootSequence = new DLSequence(new ASN1Encodable[]{_objIdeRoot, _taggedObject});
            String certStr = Base64.toBase64String(certData);
            String sigData = Base64.toBase64String(signature);
            return new HNCAP7SignStructure("", certStr, sigData, rootSequence, "SHA256withRSA", false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HNCAP7SignStructure getInstanceAttach(byte[] source, byte[] signature, byte[] certData) {
        try {
            ASN1Sequence sigseq = (ASN1Sequence)ASN1Sequence.fromByteArray(signature);
            X509CertificateHolder certholder = new X509CertificateHolder(certData);
            byte[] issuerDnbuf = certholder.getIssuer().getEncoded();
            DLSequence issuerDnSequence = (DLSequence)DLSequence.fromByteArray(issuerDnbuf);
            byte[] certsnbuf = certholder.getSerialNumber().toByteArray();
            ASN1Integer certsn = new ASN1Integer(certsnbuf);
            DLSequence certseq = (DLSequence)DLSequence.fromByteArray(certData);
            DERTaggedObject certStruct = new DERTaggedObject(0, certseq);
            ASN1Integer asn1Integer = new ASN1Integer(1L);
            DERSequence seq1 = new DERSequence(new ASN1Encodable[]{issuerDnSequence, certsn});
            ASN1ObjectIdentifier _objIde1 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM3_With_PK.GetContent());
            DERSequence seq2 = new DERSequence(new ASN1Encodable[]{_objIde1, DERNull.INSTANCE});
            ASN1ObjectIdentifier _objIde2 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_Sign.GetContent());
            DERSequence seq3 = new DERSequence(new ASN1Encodable[]{_objIde2, DERNull.INSTANCE});
            DEROctetString octstrSign = new DEROctetString(sigseq.getEncoded());
            DERSequence seq = new DERSequence(new ASN1Encodable[]{asn1Integer, seq1, seq2, seq3, octstrSign});
            DERSet signInfos = new DERSet(seq);
            ASN1Integer _asn1integer = new ASN1Integer(1L);
            ASN1ObjectIdentifier _objIde4 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM3_With_PK.GetContent());
            DERSequence seq4 = new DERSequence(new ASN1Encodable[]{_objIde4, DERNull.INSTANCE});
            DERSet _set = new DERSet(seq4);
            ASN1ObjectIdentifier _objIde5 = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_P7_Data.GetContent());
            DEROctetString dataStr = new DEROctetString(source);
            DERTaggedObject _taggedObjectdata = new DERTaggedObject(0, dataStr);
            DERSequence seq5 = new DERSequence(new ASN1Encodable[]{_objIde5, _taggedObjectdata});
            DERSequence seq6 = new DERSequence(new ASN1Encodable[]{_asn1integer, _set, seq5, certStruct, signInfos});
            DERTaggedObject _taggedObject = new DERTaggedObject(0, seq6);
            ASN1ObjectIdentifier _objIdeRoot = new ASN1ObjectIdentifier(AlgConstant.GM_OID_SM2_P7_SignedData.GetContent());
            DLSequence rootSequence = new DLSequence(new ASN1Encodable[]{_objIdeRoot, _taggedObject});
            String srcStr = Base64.toBase64String(source);
            String certStr = Base64.toBase64String(certData);
            String sigData = Base64.toBase64String(signature);
            return new HNCAP7SignStructure(srcStr, certStr, sigData, rootSequence, "SM3withSM2", true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getEncoded() {
        if (this.rootSequence != null) {
            try {
                byte[] buffer = this.rootSequence.getEncoded();
                return buffer;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

