/*
 * Decompiled with CFR 0.152.
 */
package com.hc.util;

import com.hc.util.Util;

public class SM3 {
    public static final byte[] iv;
    public static int[] Tj;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 115;
        byArray[1] = -128;
        byArray[2] = 22;
        byArray[3] = 111;
        byArray[4] = 73;
        byArray[5] = 20;
        byArray[6] = -78;
        byArray[7] = -71;
        byArray[8] = 23;
        byArray[9] = 36;
        byArray[10] = 66;
        byArray[11] = -41;
        byArray[12] = -38;
        byArray[13] = -118;
        byArray[14] = 6;
        byArray[16] = -87;
        byArray[17] = 111;
        byArray[18] = 48;
        byArray[19] = -68;
        byArray[20] = 22;
        byArray[21] = 49;
        byArray[22] = 56;
        byArray[23] = -86;
        byArray[24] = -29;
        byArray[25] = -115;
        byArray[26] = -18;
        byArray[27] = 77;
        byArray[28] = -80;
        byArray[29] = -5;
        byArray[30] = 14;
        byArray[31] = 78;
        iv = byArray;
        Tj = new int[64];
        int i = 0;
        while (i < 16) {
            SM3.Tj[i] = 2043430169;
            ++i;
        }
        i = 16;
        while (i < 64) {
            SM3.Tj[i] = 2055708042;
            ++i;
        }
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM3.convert(V);
        int[] b = SM3.convert(B);
        return SM3.convert(SM3.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < arr.length) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = SM3.bigEndianByteToInt(tmp);
            i += 4;
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        int i = 0;
        while (i < arr.length) {
            tmp = SM3.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
            ++i;
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM3.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        int j = 0;
        while (j < 64) {
            int ss1 = SM3.bitCycleLeft(a, 12) + e + SM3.bitCycleLeft(Tj[j], j);
            ss1 = SM3.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ SM3.bitCycleLeft(a, 12);
            int tt1 = SM3.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = SM3.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = SM3.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = SM3.bitCycleLeft(f, 19);
            f = e;
            e = SM3.P0(tt2);
            ++j;
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(int[] B) {
        int[] W = new int[68];
        int[] W1 = new int[64];
        int i = 0;
        while (i < B.length) {
            W[i] = B[i];
            ++i;
        }
        i = 16;
        while (i < 68) {
            W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
            ++i;
        }
        i = 0;
        while (i < 64) {
            W1[i] = W[i] ^ W[i + 4];
            ++i;
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static byte[] bigEndianIntToByte(int num) {
        return SM3.back(Util.intToBytes(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return Util.byteToInt(SM3.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.FF1j(X, Y, Z);
        }
        return SM3.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3.GG1j(X, Y, Z);
        }
        return SM3.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        int y = SM3.rotateLeft(X, 9);
        y = SM3.bitCycleLeft(X, 9);
        int z = SM3.rotateLeft(X, 17);
        z = SM3.bitCycleLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private static int P1(int X) {
        int t = X ^ SM3.bitCycleLeft(X, 15) ^ SM3.bitCycleLeft(X, 23);
        return t;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = SM3.back(Util.longToBytes(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < out.length) {
            out[i] = in[out.length - i - 1];
            ++i;
        }
        return out;
    }

    public static int rotateLeft(int x, int n) {
        return x << n | x >> 32 - n;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = SM3.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = SM3.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = SM3.bitSmall8CycleLeft(tmp, len);
        }
        return SM3.bigEndianByteToInt(tmp);
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        int i = 0;
        while (i < tmp.length) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
            ++i;
        }
        return tmp;
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }
}

