/*
 * Decompiled with CFR 0.152.
 */
package com.hnxc.soft.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    private static final int BUFFER_SIZE = 8192;
    public static final int EOF = -1;

    private IOUtil() {
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long copy(InputStream input, OutputStream output) {
        try {
            byte[] buf = new byte[8192];
            int byteRead = 0;
            long size = 0L;
            while ((byteRead = input.read(buf)) != -1) {
                output.write(buf, 0, byteRead);
                size += (long)byteRead;
            }
            return size;
        }
        catch (Exception e) {
            throw new RuntimeException("copy\u6d41\u5931\u8d25\u3002", e);
        }
    }

    public static byte[] toByteArray(InputStream input) {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            IOUtil.copy(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6d41\u5931\u8d25\u3002", e);
        }
        finally {
            IOUtil.close(output);
        }
    }

    public static byte[] readFile(String filePath) {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(filePath));
            byArray = IOUtil.toByteArray(in);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\u3002", e);
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close(in);
        return byArray;
    }

    public static void write(byte[] data, OutputStream output) {
        if (data != null) {
            try {
                output.write(data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (input1 == input2) {
            return true;
        }
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static void main(String[] args) throws Exception {
        String path = "D:\\data\\gwca\\gdsdk\\8.lic";
        FileInputStream input = new FileInputStream(new File("D:\\data\\gwca\\gdsdk\\8.lic"));
        byte[] data = IOUtil.toByteArray(input);
        String resultPath = "D:\\data\\gwca\\gdsdk\\.lic";
        FileOutputStream out = new FileOutputStream(new File("D:\\data\\gwca\\gdsdk\\.lic"));
        IOUtil.write(data, out);
    }
}

