/*
 * Decompiled with CFR 0.152.
 */
package com.hnxc.soft.util;

import com.spire.pdf.PdfDocument;
import com.spire.pdf.attachments.PdfAttachmentCollection;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripperByArea;

public class PdfUtil {
    public static String parseXmlByPdf(String filePath) throws Exception {
        String xmlStr = "";
        try (PdfDocument doc = null;){
            doc = new PdfDocument();
            doc.loadFromFile(filePath);
            PdfAttachmentCollection attachments = doc.getAttachments();
            for (int i = 0; i < attachments.getCount(); ++i) {
                xmlStr = new String(attachments.get(i).getData());
            }
        }
        return xmlStr;
    }

    public static String parseXmlByPdf(InputStream is) throws Exception {
        String xmlStr = "";
        try (PdfDocument doc = null;){
            doc = new PdfDocument();
            doc.loadFromStream(is);
            PdfAttachmentCollection attachments = doc.getAttachments();
            for (int i = 0; i < attachments.getCount(); ++i) {
                xmlStr = new String(attachments.get(i).getData());
            }
        }
        return xmlStr;
    }

    public static String parseXmlByPdf(byte[] is) throws Exception {
        String xmlStr = "";
        try (PdfDocument doc = null;){
            doc = new PdfDocument();
            doc.loadFromBytes(is);
            PdfAttachmentCollection attachments = doc.getAttachments();
            for (int i = 0; i < attachments.getCount(); ++i) {
                xmlStr = new String(attachments.get(i).getData());
            }
        }
        return xmlStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parseEinvoiceInfo(byte[] file) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (PDDocument document = null;){
            document = PDDocument.load(file);
            if (document.isEncrypted()) {
                document.isEncrypted();
            }
            Rectangle textRrect = new Rectangle(0, 70, 600, 300);
            String s = PdfUtil.parsePDFToString(document, textRrect);
            String ivcCode = s.split("\r\n")[0].split(" ")[0].split("\uff1a")[1];
            String ivcNo = s.split("\r\n")[0].split(" ")[1].split("\uff1a")[1];
            String ckNo = s.split("\r\n")[1].split(" ")[1].split("\uff1a")[1];
            String payer = s.split("\r\n")[2].split(" ")[0].split("\uff1a")[1];
            String mdate = s.split("\r\n")[2].split(" ")[1].split("\uff1a")[1];
            String itemCode = s.split("\r\n")[4].split(" ")[0];
            String amount = s.split("\r\n")[5].split(" ")[1].substring(4);
            map.put("ivcCode", ivcCode);
            map.put("ivcNo", ivcNo);
            map.put("ckNo", ckNo);
            map.put("payer", payer);
            map.put("mdate", mdate);
            map.put("itemCode", itemCode);
            map.put("amount", amount);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parseEinvoiceInfo(File file) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (PDDocument document = null;){
            document = PDDocument.load(file);
            if (document.isEncrypted()) {
                document.isEncrypted();
            }
            Rectangle textRrect = new Rectangle(0, 70, 600, 300);
            String s = PdfUtil.parsePDFToString(document, textRrect);
            String ivcCode = s.split("\r\n")[0].split(" ")[0].split("\uff1a")[1];
            String ivcNo = s.split("\r\n")[0].split(" ")[1].split("\uff1a")[1];
            String ckNo = s.split("\r\n")[1].split(" ")[1].split("\uff1a")[1];
            String payer = s.split("\r\n")[2].split(" ")[0].split("\uff1a")[1];
            String mdate = s.split("\r\n")[2].split(" ")[1].split("\uff1a")[1];
            String itemCode = s.split("\r\n")[4].split(" ")[0];
            String amount = s.split("\r\n")[5].split(" ")[1].substring(4);
            map.put("ivcCode", ivcCode);
            map.put("ivcNo", ivcNo);
            map.put("ckNo", ckNo);
            map.put("payer", payer);
            map.put("mdate", mdate);
            map.put("itemCode", itemCode);
            map.put("amount", amount);
        }
        return map;
    }

    public static Map<String, Object> parseEinvoiceInfo(InputStream is) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (PDDocument document = null;){
            int i;
            document = PDDocument.load(is);
            if (document.isEncrypted()) {
                document.isEncrypted();
            }
            Rectangle textRrect = new Rectangle(0, 70, 600, 300);
            String s = PdfUtil.parsePDFToString(document, textRrect);
            String ivcCode = s.split("\r\n")[0].split(" ")[0].split("\uff1a")[1];
            String ivcNo = s.split("\r\n")[0].split(" ")[1].split("\uff1a")[1];
            String ckNo = s.split("\r\n")[1].split(" ")[1].split("\uff1a")[1];
            String[] payerName = s.split("\r\n")[2].split("\uff1a")[1].split(" ");
            String payer = "";
            if (payerName.length > 2) {
                for (int i2 = 0; i2 < payerName.length && i2 != payerName.length - 1; ++i2) {
                    payer = i2 == payerName.length - 2 ? payer + new StringBuffer().append(payerName[i2]).append("") : payer + new StringBuffer().append(payerName[i2]).append(" ");
                }
            } else {
                payer = payerName[0];
            }
            String mdate = s.split("\r\n")[2].split("\uff1a")[2].replace("-", "");
            ArrayList<String> itemList = new ArrayList<String>();
            int j = 4;
            if (ivcCode.contains("410601") || ivcCode.contains("410602")) {
                String itemCode;
                for (i = 4; i < 20 && !(itemCode = s.split("\r\n")[i].split(" ")[0]).contains("\u91d1\u989d\u5408\u8ba1"); ++i) {
                    ++j;
                }
            } else {
                String itemCode;
                for (i = 4; i < 9 && !(itemCode = s.split("\r\n")[i].split(" ")[0]).contains("\u91d1\u989d\u5408\u8ba1"); ++i) {
                    itemList.add(itemCode);
                    ++j;
                }
            }
            String amount = s.split("\r\n")[j].split(" ")[1].substring(5);
            map.put("ivcCode", ivcCode);
            map.put("ivcNo", ivcNo);
            map.put("ckNo", ckNo);
            map.put("payer", payer);
            map.put("mdate", mdate);
            map.put("items", itemList);
            map.put("amount", amount);
        }
        return map;
    }

    private static String parsePDFToString(PDDocument pdfdocument, Rectangle textRrect) {
        try {
            PDPage pdfPage = pdfdocument.getPage(0);
            PDFTextStripperByArea textStripper = new PDFTextStripperByArea();
            textStripper.setSortByPosition(true);
            textStripper.addRegion("content", textRrect);
            textStripper.extractRegions(pdfPage);
            String textContent = textStripper.getTextForRegion("content");
            return textContent;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(new StringBuffer().append("\u8bfb\u53d6Pdf\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff0c").append(e.getMessage()).toString());
        }
    }
}

