/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.IOException;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.icao.CscaMasterList;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.io.Streams;
import org.bouncycastle162.util.test.SimpleTest;

public class CscaMasterListTest
extends SimpleTest {
    public String getName() {
        return "CscaMasterList";
    }

    public void performTest() throws Exception {
        byte[] output;
        byte[] input = this.getInput("masterlist-content.data");
        CscaMasterList parsedList = CscaMasterList.getInstance(ASN1Primitive.fromByteArray(input));
        if (parsedList.getCertStructs().length != 3) {
            this.fail("Cert structure parsing failed: incorrect length");
        }
        if (!Arrays.areEqual(input, output = parsedList.getEncoded())) {
            this.fail("Encoding failed after parse");
        }
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll(this.getClass().getResourceAsStream(name));
    }

    public static void main(String[] args) {
        CscaMasterListTest.runTest(new CscaMasterListTest());
    }
}

