/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.IOException;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.x500.X500Name;
import org.bouncycastle162.asn1.x509.DistributionPointName;
import org.bouncycastle162.asn1.x509.GeneralName;
import org.bouncycastle162.asn1.x509.GeneralNames;
import org.bouncycastle162.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle162.asn1.x509.ReasonFlags;
import org.bouncycastle162.util.test.SimpleTest;

public class IssuingDistributionPointUnitTest
extends SimpleTest {
    public String getName() {
        return "IssuingDistributionPoint";
    }

    public void performTest() throws Exception {
        DistributionPointName name = new DistributionPointName(new GeneralNames(new GeneralName(new X500Name("cn=test"))));
        ReasonFlags reasonFlags = new ReasonFlags(32);
        this.checkPoint(6, name, true, true, reasonFlags, true, true);
        this.checkPoint(2, name, false, false, reasonFlags, false, false);
        this.checkPoint(0, null, false, false, null, false, false);
        try {
            IssuingDistributionPoint.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkPoint(int size, DistributionPointName distributionPoint, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, ReasonFlags onlySomeReasons, boolean indirectCRL, boolean onlyContainsAttributeCerts) throws IOException {
        IssuingDistributionPoint point = new IssuingDistributionPoint(distributionPoint, onlyContainsUserCerts, onlyContainsCACerts, onlySomeReasons, indirectCRL, onlyContainsAttributeCerts);
        this.checkValues(point, distributionPoint, onlyContainsUserCerts, onlyContainsCACerts, onlySomeReasons, indirectCRL, onlyContainsAttributeCerts);
        ASN1Sequence seq = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(point.getEncoded()));
        if (seq.size() != size) {
            this.fail("size mismatch");
        }
        point = IssuingDistributionPoint.getInstance(seq);
        this.checkValues(point, distributionPoint, onlyContainsUserCerts, onlyContainsCACerts, onlySomeReasons, indirectCRL, onlyContainsAttributeCerts);
    }

    private void checkValues(IssuingDistributionPoint point, DistributionPointName distributionPoint, boolean onlyContainsUserCerts, boolean onlyContainsCACerts, ReasonFlags onlySomeReasons, boolean indirectCRL, boolean onlyContainsAttributeCerts) {
        if (point.onlyContainsUserCerts() != onlyContainsUserCerts) {
            this.fail("mismatch on onlyContainsUserCerts");
        }
        if (point.onlyContainsCACerts() != onlyContainsCACerts) {
            this.fail("mismatch on onlyContainsCACerts");
        }
        if (point.isIndirectCRL() != indirectCRL) {
            this.fail("mismatch on indirectCRL");
        }
        if (point.onlyContainsAttributeCerts() != onlyContainsAttributeCerts) {
            this.fail("mismatch on onlyContainsAttributeCerts");
        }
        if (!this.isEquiv(onlySomeReasons, point.getOnlySomeReasons())) {
            this.fail("mismatch on onlySomeReasons");
        }
        if (!this.isEquiv(distributionPoint, point.getDistributionPoint())) {
            this.fail("mismatch on distributionPoint");
        }
    }

    private boolean isEquiv(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static void main(String[] args) {
        IssuingDistributionPointUnitTest.runTest(new IssuingDistributionPointUnitTest());
    }
}

