/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.IOException;
import org.bouncycastle162.asn1.crmf.PKIPublicationInfo;
import org.bouncycastle162.asn1.crmf.SinglePubInfo;
import org.bouncycastle162.asn1.x500.X500Name;
import org.bouncycastle162.asn1.x509.GeneralName;
import org.bouncycastle162.util.test.SimpleTest;

public class PKIPublicationInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        PKIPublicationInfoTest.runTest(new PKIPublicationInfoTest());
    }

    public String getName() {
        return "PKIPublicationInfoTest";
    }

    public void performTest() throws Exception {
        PKIPublicationInfo pkiPubInfo = new PKIPublicationInfo(PKIPublicationInfo.dontPublish);
        this.isEquals(PKIPublicationInfo.dontPublish, pkiPubInfo.getAction());
        this.encEqualTest(pkiPubInfo);
        pkiPubInfo = new PKIPublicationInfo(PKIPublicationInfo.dontPublish.getValue());
        this.isEquals(PKIPublicationInfo.dontPublish, pkiPubInfo.getAction());
        this.encEqualTest(pkiPubInfo);
        SinglePubInfo singlePubInfo1 = new SinglePubInfo(SinglePubInfo.x500, new GeneralName(new X500Name("CN=TEST")));
        pkiPubInfo = new PKIPublicationInfo(singlePubInfo1);
        this.isEquals(PKIPublicationInfo.pleasePublish, pkiPubInfo.getAction());
        this.isEquals(1, pkiPubInfo.getPubInfos().length);
        this.isEquals(singlePubInfo1, pkiPubInfo.getPubInfos()[0]);
        this.encEqualTest(pkiPubInfo);
        SinglePubInfo singlePubInfo2 = new SinglePubInfo(SinglePubInfo.x500, new GeneralName(new X500Name("CN=BLOOT")));
        pkiPubInfo = new PKIPublicationInfo(new SinglePubInfo[]{singlePubInfo1, singlePubInfo2});
        this.isEquals(PKIPublicationInfo.pleasePublish, pkiPubInfo.getAction());
        this.isEquals(2, pkiPubInfo.getPubInfos().length);
        this.isEquals(singlePubInfo1, pkiPubInfo.getPubInfos()[0]);
        this.isEquals(singlePubInfo2, pkiPubInfo.getPubInfos()[1]);
        this.encEqualTest(pkiPubInfo);
        pkiPubInfo = new PKIPublicationInfo((SinglePubInfo)null);
        this.isEquals(PKIPublicationInfo.pleasePublish, pkiPubInfo.getAction());
        this.isTrue(null == pkiPubInfo.getPubInfos());
        this.encEqualTest(pkiPubInfo);
        pkiPubInfo = new PKIPublicationInfo((SinglePubInfo[])null);
        this.isEquals(PKIPublicationInfo.pleasePublish, pkiPubInfo.getAction());
        this.isTrue(null == pkiPubInfo.getPubInfos());
        this.encEqualTest(pkiPubInfo);
    }

    private void encEqualTest(PKIPublicationInfo pubInfo) throws IOException {
        byte[] b = pubInfo.getEncoded();
        PKIPublicationInfo pubInfoResult = PKIPublicationInfo.getInstance(b);
        this.isEquals(pubInfo, pubInfoResult);
    }
}

