/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.DERUTF8String;
import org.bouncycastle162.asn1.cmc.BodyPartID;
import org.bouncycastle162.asn1.cmc.TaggedContentInfo;
import org.bouncycastle162.asn1.cms.ContentInfo;
import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.util.test.SimpleTest;

public class TaggedContentInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        TaggedContentInfoTest.runTest(new TaggedContentInfoTest());
    }

    public String getName() {
        return "TaggedContentInfoTest";
    }

    public void performTest() throws Exception {
        TaggedContentInfo tci = new TaggedContentInfo(new BodyPartID(10L), new ContentInfo(PKCSObjectIdentifiers.pkcs_9_at_contentType, new DERUTF8String("Cats")));
        byte[] b = tci.getEncoded();
        TaggedContentInfo tciResp = TaggedContentInfo.getInstance(b);
        this.isEquals("bodyPartID", tci.getBodyPartID(), tciResp.getBodyPartID());
        this.isEquals("contentInfo", tci.getContentInfo(), tciResp.getContentInfo());
        try {
            TaggedContentInfo.getInstance(new DERSequence());
            this.fail("Sequence must be 2");
        }
        catch (Throwable t) {
            this.isEquals("Exception type", t.getClass(), IllegalArgumentException.class);
        }
    }
}

