/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cert.ocsp;

import java.util.Date;
import org.bouncycastle162.asn1.ASN1GeneralizedTime;
import org.bouncycastle162.asn1.ocsp.RevokedInfo;
import org.bouncycastle162.asn1.x509.CRLReason;
import org.bouncycastle162.cert.ocsp.CertificateStatus;
import org.bouncycastle162.cert.ocsp.OCSPUtils;

public class RevokedStatus
implements CertificateStatus {
    RevokedInfo info;

    public RevokedStatus(RevokedInfo info) {
        this.info = info;
    }

    public RevokedStatus(Date revocationDate, int reason) {
        this.info = new RevokedInfo(new ASN1GeneralizedTime(revocationDate), CRLReason.lookup(reason));
    }

    public Date getRevocationTime() {
        return OCSPUtils.extractDate(this.info.getRevocationTime());
    }

    public boolean hasRevocationReason() {
        return this.info.getRevocationReason() != null;
    }

    public int getRevocationReason() {
        if (this.info.getRevocationReason() == null) {
            throw new IllegalStateException("attempt to get a reason where none is available");
        }
        return this.info.getRevocationReason().getValue().intValue();
    }
}

