/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms.bc;

import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.KEKRecipient;
import org.bouncycastle162.cms.bc.CMSUtils;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.operator.OperatorException;
import org.bouncycastle162.operator.SymmetricKeyUnwrapper;
import org.bouncycastle162.operator.bc.BcSymmetricKeyUnwrapper;

public abstract class BcKEKRecipient
implements KEKRecipient {
    private SymmetricKeyUnwrapper unwrapper;

    public BcKEKRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        this.unwrapper = unwrapper;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            return CMSUtils.getBcKey(this.unwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

