/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.engines.ARIAEngine;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class ARIATest
extends SimpleTest {
    private static SecureRandom R = new SecureRandom();
    private static final String[][] TEST_VECTORS_RFC5794 = new String[][]{{"128-Bit Key", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "d718fbd6ab644c739da95f3be6451778"}, {"192-Bit Key", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "26449c1805dbe7aa25a468ce263a9e79"}, {"256-Bit Key", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "f92bd7c79fb72e2f2b8f80c1972d24fc"}};

    public String getName() {
        return "ARIA";
    }

    public void performTest() throws Exception {
        this.checkTestVectors_RFC5794();
        for (int i = 0; i < 100; ++i) {
            this.checkRandomRoundtrips();
        }
        new MyARIAEngine().checkImplementation();
    }

    private void checkRandomRoundtrips() {
        ARIAEngine ce = new ARIAEngine();
        ARIAEngine cd = new ARIAEngine();
        byte[] txt = new byte[ce.getBlockSize()];
        byte[] enc = new byte[ce.getBlockSize()];
        byte[] dec = new byte[ce.getBlockSize()];
        for (int keyLen = 16; keyLen <= 32; keyLen += 8) {
            byte[] K = new byte[keyLen];
            R.nextBytes(K);
            KeyParameter key = new KeyParameter(K);
            ce.init(true, key);
            cd.init(false, key);
            R.nextBytes(txt);
            for (int i = 0; i < 100; ++i) {
                ce.processBlock(txt, 0, enc, 0);
                cd.processBlock(enc, 0, dec, 0);
                this.isTrue(Arrays.areEqual(txt, dec));
                System.arraycopy(enc, 0, txt, 0, enc.length);
            }
        }
    }

    private void checkTestVector_RFC5794(String[] tv) {
        String name = "'" + tv[0] + "'";
        ARIAEngine c = new ARIAEngine();
        int blockSize = c.getBlockSize();
        this.isTrue("Wrong block size returned from getBlockSize() for " + name, 16 == blockSize);
        KeyParameter key = new KeyParameter(Hex.decode(tv[1]));
        byte[] plaintext = Hex.decode(tv[2]);
        byte[] ciphertext = Hex.decode(tv[3]);
        this.isTrue("Unexpected plaintext length for " + name, blockSize == plaintext.length);
        this.isTrue("Unexpected ciphertext length for " + name, blockSize == ciphertext.length);
        c.init(true, key);
        byte[] actual = new byte[blockSize];
        int num = c.processBlock(plaintext, 0, actual, 0);
        this.isTrue("Wrong length returned from processBlock() (encryption) for " + name, blockSize == num);
        this.isTrue("Incorrect ciphertext computed for " + name, Arrays.areEqual(ciphertext, actual));
        c.init(false, key);
        num = c.processBlock(ciphertext, 0, actual, 0);
        this.isTrue("Wrong length returned from processBlock() (decryption) for " + name, blockSize == num);
        this.isTrue("Incorrect plaintext computed for " + name, Arrays.areEqual(plaintext, actual));
    }

    private void checkTestVectors_RFC5794() {
        for (int i = 0; i < TEST_VECTORS_RFC5794.length; ++i) {
            this.checkTestVector_RFC5794(TEST_VECTORS_RFC5794[i]);
        }
    }

    public static void main(String[] args) {
        ARIATest.runTest(new ARIATest());
    }

    private class MyARIAEngine
    extends ARIAEngine {
        private MyARIAEngine() {
        }

        public void checkImplementation() {
            this.checkInvolution();
            this.checkSBoxes();
        }

        private void checkInvolution() {
            byte[] x = new byte[16];
            byte[] y = new byte[16];
            for (int i = 0; i < 100; ++i) {
                R.nextBytes(x);
                System.arraycopy(x, 0, y, 0, 16);
                MyARIAEngine.A(y);
                MyARIAEngine.A(y);
                ARIATest.this.isTrue(Arrays.areEqual(x, y));
            }
        }

        private void checkSBoxes() {
            for (int i = 0; i < 256; ++i) {
                byte x = (byte)i;
                ARIATest.this.isTrue(x == MyARIAEngine.SB1(MyARIAEngine.SB3(x)));
                ARIATest.this.isTrue(x == MyARIAEngine.SB3(MyARIAEngine.SB1(x)));
                ARIATest.this.isTrue(x == MyARIAEngine.SB2(MyARIAEngine.SB4(x)));
                ARIATest.this.isTrue(x == MyARIAEngine.SB4(MyARIAEngine.SB2(x)));
            }
        }
    }
}

