/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import org.bouncycastle162.crypto.DataLengthException;
import org.bouncycastle162.crypto.DerivationFunction;
import org.bouncycastle162.crypto.digests.SHA1Digest;
import org.bouncycastle162.crypto.digests.SHA256Digest;
import org.bouncycastle162.crypto.digests.ShortenedDigest;
import org.bouncycastle162.crypto.generators.KDF1BytesGenerator;
import org.bouncycastle162.crypto.params.ISO18033KDFParameters;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class KDF1GeneratorTest
extends SimpleTest {
    private byte[] seed1 = Hex.decode("d6e168c5f256a2dcff7ef12facd390f393c7a88d");
    private byte[] mask1 = Hex.decode("0742ba966813af75536bb6149cc44fc256fd6406df79665bc31dc5a62f70535e52c53015b9d37d412ff3c1193439599e1b628774c50d9ccb78d82c425e4521ee47b8c36a4bcffe8b8112a89312fc04420a39de99223890e74ce10378bc515a212b97b8a6447ba6a8870278");
    private byte[] seed2 = Hex.decode("032e45326fa859a72ec235acff929b15d1372e30b207255f0611b8f785d764374152e0ac009e509e7ba30cd2f1778e113b64e135cf4e2292c75efe5288edfda4");
    private byte[] mask2 = Hex.decode("5f8de105b5e96b2e490ddecbd147dd1def7e3b8e0e6a26eb7b956ccb8b3bdc1ca975bc57c3989e8fbad31a224655d800c46954840ff32052cdf0d640562bdfadfa263cfccf3c52b29f2af4a1869959bc77f854cf15bd7a25192985a842dbff8e13efee5b7e7e55bbe4d389647c686a9a9ab3fb889b2d7767d3837eea4e0a2f04");
    private byte[] seed3 = this.seed2;
    private byte[] mask3 = Hex.decode("09e2decf2a6e1666c2f6071ff4298305e2643fd510a2403db42a8743cb989de86e668d168cbe604611ac179f819a3d18412e9eb45668f2923c087c12fee0c5a0d2a8aa70185401fbbd99379ec76c663e875a60b4aacb1319fa11c3365a8b79a44669f26fb555c80391847b05eca1cb5cf8c2d531448d33fbaca19f6410ee1fcb");

    public void performTest() {
        this.checkMask(1, new KDF1BytesGenerator(new ShortenedDigest(new SHA256Digest(), 20)), this.seed1, this.mask1);
        this.checkMask(2, new KDF1BytesGenerator(new SHA1Digest()), this.seed2, this.mask2);
        this.checkMask(3, new KDF1BytesGenerator(new ShortenedDigest(new SHA256Digest(), 20)), this.seed3, this.mask3);
        try {
            new KDF1BytesGenerator(new SHA1Digest()).generateBytes(new byte[10], 0, 20);
            this.fail("short input array not caught");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
    }

    private void checkMask(int count, DerivationFunction kdf, byte[] seed, byte[] result) {
        byte[] data = new byte[result.length];
        kdf.init(new ISO18033KDFParameters(seed));
        kdf.generateBytes(data, 0, data.length);
        if (!this.areEqual(result, data)) {
            this.fail("KDF1 failed generator test " + count);
        }
    }

    public String getName() {
        return "KDF1";
    }

    public static void main(String[] args) {
        KDF1GeneratorTest.runTest(new KDF1GeneratorTest());
    }
}

