/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.crypto.AsymmetricBlockCipher;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.InvalidCipherTextException;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithRandom;
import org.bouncycastle162.operator.AsymmetricKeyWrapper;
import org.bouncycastle162.operator.GenericKey;
import org.bouncycastle162.operator.OperatorException;
import org.bouncycastle162.operator.bc.OperatorUtils;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier encAlgId, AsymmetricKeyParameter publicKey) {
        super(encAlgId);
        this.publicKey = publicKey;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        AsymmetricBlockCipher keyEncryptionCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters params = this.publicKey;
        if (this.random != null) {
            params = new ParametersWithRandom(params, this.random);
        }
        try {
            byte[] keyEnc = OperatorUtils.getKeyBytes(encryptionKey);
            keyEncryptionCipher.init(true, params);
            return keyEncryptionCipher.processBlock(keyEnc, 0, keyEnc.length);
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to encrypt contents key", e);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

