/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.crypto.InvalidCipherTextException;
import org.bouncycastle162.crypto.Wrapper;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.operator.GenericKey;
import org.bouncycastle162.operator.OperatorException;
import org.bouncycastle162.operator.SymmetricKeyUnwrapper;

public class BcSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyUnwrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public BcSymmetricKeyUnwrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(encryptedKeyAlgorithm, this.wrapper.unwrap(encryptedKey, 0, encryptedKey.length));
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to unwrap key: " + e.getMessage(), e);
        }
    }
}

