/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.crypto.gmss;

import org.bouncycastle162.crypto.Digest;
import org.bouncycastle162.pqc.crypto.gmss.util.GMSSRandom;
import org.bouncycastle162.util.encoders.Hex;

public class GMSSRootSig {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[] privateKeyOTS;
    private byte[] hash;
    private byte[] sign;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int k;
    private int r;
    private int test;
    private int counter;
    private int ii;
    private long test8;
    private long big8;
    private int steps;
    private int checksum;
    private int height;
    private byte[] seed;

    public GMSSRootSig(Digest digest, byte[][] statByte, int[] statInt) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.counter = statInt[0];
        this.test = statInt[1];
        this.ii = statInt[2];
        this.r = statInt[3];
        this.steps = statInt[4];
        this.keysize = statInt[5];
        this.height = statInt[6];
        this.w = statInt[7];
        this.checksum = statInt[8];
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.k = (1 << this.w) - 1;
        int mdsizeBit = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)mdsizeBit / (double)this.w);
        this.privateKeyOTS = statByte[0];
        this.seed = statByte[1];
        this.hash = statByte[2];
        this.sign = statByte[3];
        this.test8 = (long)(statByte[4][0] & 0xFF) | (long)(statByte[4][1] & 0xFF) << 8 | (long)(statByte[4][2] & 0xFF) << 16 | (long)(statByte[4][3] & 0xFF) << 24 | (long)(statByte[4][4] & 0xFF) << 32 | (long)(statByte[4][5] & 0xFF) << 40 | (long)(statByte[4][6] & 0xFF) << 48 | (long)(statByte[4][7] & 0xFF) << 56;
        this.big8 = (long)(statByte[4][8] & 0xFF) | (long)(statByte[4][9] & 0xFF) << 8 | (long)(statByte[4][10] & 0xFF) << 16 | (long)(statByte[4][11] & 0xFF) << 24 | (long)(statByte[4][12] & 0xFF) << 32 | (long)(statByte[4][13] & 0xFF) << 40 | (long)(statByte[4][14] & 0xFF) << 48 | (long)(statByte[4][15] & 0xFF) << 56;
    }

    public GMSSRootSig(Digest digest, int w, int height) {
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        this.w = w;
        this.height = height;
        this.k = (1 << w) - 1;
        int mdsizeBit = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)mdsizeBit / (double)w);
    }

    public void initSign(byte[] seed0, byte[] message) {
        this.hash = new byte[this.mdsize];
        this.messDigestOTS.update(message, 0, message.length);
        this.hash = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(this.hash, 0);
        byte[] messPart = new byte[this.mdsize];
        System.arraycopy(this.hash, 0, messPart, 0, this.mdsize);
        int checkPart = 0;
        int sumH = 0;
        int checksumsize = this.getLog((this.messagesize << this.w) + 1);
        if (8 % this.w == 0) {
            int dt = 8 / this.w;
            for (int a = 0; a < this.mdsize; ++a) {
                for (int b = 0; b < dt; ++b) {
                    sumH += messPart[a] & this.k;
                    messPart[a] = (byte)(messPart[a] >>> this.w);
                }
            }
            checkPart = this.checksum = (this.messagesize << this.w) - sumH;
            for (int b = 0; b < checksumsize; b += this.w) {
                sumH += checkPart & this.k;
                checkPart >>>= this.w;
            }
        } else if (this.w < 8) {
            int j;
            long big8;
            int i;
            int ii = 0;
            int dt = this.mdsize / this.w;
            for (i = 0; i < dt; ++i) {
                int j2;
                big8 = 0L;
                for (j2 = 0; j2 < this.w; ++j2) {
                    big8 ^= (long)((messPart[ii] & 0xFF) << (j2 << 3));
                    ++ii;
                }
                for (j2 = 0; j2 < 8; ++j2) {
                    sumH += (int)(big8 & (long)this.k);
                    big8 >>>= this.w;
                }
            }
            dt = this.mdsize % this.w;
            big8 = 0L;
            for (j = 0; j < dt; ++j) {
                big8 ^= (long)((messPart[ii] & 0xFF) << (j << 3));
                ++ii;
            }
            dt <<= 3;
            for (j = 0; j < dt; j += this.w) {
                sumH += (int)(big8 & (long)this.k);
                big8 >>>= this.w;
            }
            checkPart = this.checksum = (this.messagesize << this.w) - sumH;
            for (i = 0; i < checksumsize; i += this.w) {
                sumH += checkPart & this.k;
                checkPart >>>= this.w;
            }
        } else if (this.w < 57) {
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            int r = 0;
            while (r <= (this.mdsize << 3) - this.w) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j = s; j < f; ++j) {
                    big8 ^= (long)((messPart[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                sumH = (int)((long)sumH + ((big8 >>>= rest) & (long)this.k));
            }
            s = r >>> 3;
            if (s < this.mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                for (j = s; j < this.mdsize; ++j) {
                    big8 ^= (long)((messPart[j] & 0xFF) << (ii << 3));
                    ++ii;
                }
                sumH = (int)((long)sumH + ((big8 >>>= rest) & (long)this.k));
            }
            checkPart = this.checksum = (this.messagesize << this.w) - sumH;
            for (int i = 0; i < checksumsize; i += this.w) {
                sumH += checkPart & this.k;
                checkPart >>>= this.w;
            }
        }
        this.keysize = this.messagesize + (int)Math.ceil((double)checksumsize / (double)this.w);
        this.steps = (int)Math.ceil((double)(this.keysize + sumH) / (double)(1 << this.height));
        this.sign = new byte[this.keysize * this.mdsize];
        this.counter = 0;
        this.test = 0;
        this.ii = 0;
        this.test8 = 0L;
        this.r = 0;
        this.privateKeyOTS = new byte[this.mdsize];
        this.seed = new byte[this.mdsize];
        System.arraycopy(seed0, 0, this.seed, 0, this.mdsize);
    }

    public boolean updateSign() {
        for (int s = 0; s < this.steps; ++s) {
            if (this.counter < this.keysize) {
                this.oneStep();
            }
            if (this.counter != this.keysize) continue;
            return true;
        }
        return false;
    }

    public byte[] getSig() {
        return this.sign;
    }

    private void oneStep() {
        if (8 % this.w == 0) {
            if (this.test == 0) {
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
                if (this.ii < this.mdsize) {
                    this.test = this.hash[this.ii] & this.k;
                    this.hash[this.ii] = (byte)(this.hash[this.ii] >>> this.w);
                } else {
                    this.test = this.checksum & this.k;
                    this.checksum >>>= this.w;
                }
            } else if (this.test > 0) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test;
            }
            if (this.test == 0) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                ++this.counter;
                if (this.counter % (8 / this.w) == 0) {
                    ++this.ii;
                }
            }
        } else if (this.w < 8) {
            if (this.test == 0) {
                if (this.counter % 8 == 0 && this.ii < this.mdsize) {
                    this.big8 = 0L;
                    if (this.counter < this.mdsize / this.w << 3) {
                        for (int j = 0; j < this.w; ++j) {
                            this.big8 ^= (long)((this.hash[this.ii] & 0xFF) << (j << 3));
                            ++this.ii;
                        }
                    } else {
                        for (int j = 0; j < this.mdsize % this.w; ++j) {
                            this.big8 ^= (long)((this.hash[this.ii] & 0xFF) << (j << 3));
                            ++this.ii;
                        }
                    }
                }
                if (this.counter == this.messagesize) {
                    this.big8 = this.checksum;
                }
                this.test = (int)(this.big8 & (long)this.k);
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (this.test > 0) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test;
            }
            if (this.test == 0) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                this.big8 >>>= this.w;
                ++this.counter;
            }
        } else if (this.w < 57) {
            if (this.test8 == 0L) {
                this.big8 = 0L;
                this.ii = 0;
                int rest = this.r % 8;
                int s = this.r >>> 3;
                if (s < this.mdsize) {
                    int f;
                    if (this.r <= (this.mdsize << 3) - this.w) {
                        this.r += this.w;
                        f = this.r + 7 >>> 3;
                    } else {
                        f = this.mdsize;
                        this.r += this.w;
                    }
                    for (int i = s; i < f; ++i) {
                        this.big8 ^= (long)((this.hash[i] & 0xFF) << (this.ii << 3));
                        ++this.ii;
                    }
                    this.big8 >>>= rest;
                    this.test8 = this.big8 & (long)this.k;
                } else {
                    this.test8 = this.checksum & this.k;
                    this.checksum >>>= this.w;
                }
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
            } else if (this.test8 > 0L) {
                this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
                this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
                --this.test8;
            }
            if (this.test8 == 0L) {
                System.arraycopy(this.privateKeyOTS, 0, this.sign, this.counter * this.mdsize, this.mdsize);
                ++this.counter;
            }
        }
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }

    public byte[][] getStatByte() {
        byte[][] statByte = new byte[5][this.mdsize];
        statByte[0] = this.privateKeyOTS;
        statByte[1] = this.seed;
        statByte[2] = this.hash;
        statByte[3] = this.sign;
        statByte[4] = this.getStatLong();
        return statByte;
    }

    public int[] getStatInt() {
        int[] statInt = new int[]{this.counter, this.test, this.ii, this.r, this.steps, this.keysize, this.height, this.w, this.checksum};
        return statInt;
    }

    public byte[] getStatLong() {
        byte[] bytes = new byte[]{(byte)(this.test8 & 0xFFL), (byte)(this.test8 >> 8 & 0xFFL), (byte)(this.test8 >> 16 & 0xFFL), (byte)(this.test8 >> 24 & 0xFFL), (byte)(this.test8 >> 32 & 0xFFL), (byte)(this.test8 >> 40 & 0xFFL), (byte)(this.test8 >> 48 & 0xFFL), (byte)(this.test8 >> 56 & 0xFFL), (byte)(this.big8 & 0xFFL), (byte)(this.big8 >> 8 & 0xFFL), (byte)(this.big8 >> 16 & 0xFFL), (byte)(this.big8 >> 24 & 0xFFL), (byte)(this.big8 >> 32 & 0xFFL), (byte)(this.big8 >> 40 & 0xFFL), (byte)(this.big8 >> 48 & 0xFFL), (byte)(this.big8 >> 56 & 0xFFL)};
        return bytes;
    }

    public String toString() {
        int i;
        String out = "" + this.big8 + "  ";
        int[] statInt = new int[9];
        statInt = this.getStatInt();
        byte[][] statByte = new byte[5][this.mdsize];
        statByte = this.getStatByte();
        for (i = 0; i < 9; ++i) {
            out = out + statInt[i] + " ";
        }
        for (i = 0; i < 5; ++i) {
            out = out + new String(Hex.encode(statByte[i])) + " ";
        }
        return out;
    }
}

