/*
 * Decompiled with CFR 0.152.
 */
package com.zhejiang.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class TrustKeyStore {
    private String filePath = TrustKeyStore.class.getClassLoader().getResource("").getPath() + File.separator + "truststore";
    private String pass = "mychain";
    private boolean verifyRoot = true;
    private KeyStore keyStore;
    private String keyStorePath;
    private boolean existed;

    public void init() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, NoSuchProviderException {
        if (this.verifyRoot) {
            try {
                this.keyStore = KeyStore.getInstance("BKS", "BC");
                this.keyStorePath = this.filePath;
                FileInputStream is = FileUtils.openInputStream((File)new File(this.filePath.replace('/', File.separatorChar)));
                this.keyStore.load(is, this.pass.toCharArray());
                this.existed = true;
                ((InputStream)is).close();
            }
            catch (Exception e) {
                FileOutputStream os = FileUtils.openOutputStream((File)new File(this.filePath.replace('/', File.separatorChar)));
                this.createKeyStore(os, this.pass.toCharArray());
            }
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public boolean isExisted() {
        return this.existed;
    }

    public TrustKeyStore createKeyStore(FileOutputStream fileOutputStream, char[] pass) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.keyStore.load(null, null);
        this.keyStore.store(fileOutputStream, pass);
        return this;
    }

    public void saveKeyStore(char[] pass) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream os = FileUtils.openOutputStream((File)new File(this.keyStorePath.replace('/', File.separatorChar)));
        this.saveKeyStore(os, pass);
    }

    public void saveKeyStore(FileOutputStream fileOutputStream, char[] pass) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        if (this.keyStore != null) {
            this.keyStore.store(fileOutputStream, pass);
        }
    }

    public TrustKeyStore addCert(X509Certificate certificate) throws KeyStoreException {
        return this.addCert(certificate.getSubjectX500Principal().toString(), certificate);
    }

    public TrustKeyStore addCert(String alias, X509Certificate certificate) throws KeyStoreException {
        this.keyStore.setCertificateEntry(alias, certificate);
        return this;
    }

    public TrustKeyStore removeCert(String alias) throws KeyStoreException {
        this.keyStore.deleteEntry(alias);
        return this;
    }

    public Certificate getCertBySubject(String subject) throws KeyStoreException {
        return this.keyStore.containsAlias(subject) ? this.keyStore.getCertificate(subject) : null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

