/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanisms;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTPKCSObjectIdentifiers;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTX9ObjectIdentifiers;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MechanismKit {
    public static final String RSA = "RSA";
    public static final String RSA_PKCS = "RSA/ECB/PKCS1PADDING";
    public static final String EC = "EC";
    public static final String ECC = "ECC";
    public static final String ECDSA = "ECDSA";
    public static final String SM2 = "SM2";
    public static final String SM4_KEY = "SM4";
    public static final String SM4_CBC = "SM4/CBC/PKCS7Padding";
    public static final String SM4_ECB = "SM4/ECB/PKCS7Padding";
    public static final String RC4 = "RC4";
    public static final String RC4_KEY = "RC4";
    public static final String DES3_KEY = "DESede";
    public static final String DES3_ECB = "DESede/ECB/PKCS7Padding";
    public static final String DES3_CBC = "DESede/CBC/PKCS7Padding";
    public static final String AES_KEY = "AES";
    public static final String AES_ECB = "AES/ECB/PKCS7Padding";
    public static final String AES_CBC = "AES/CBC/PKCS7Padding";
    public static final String PBE_KEY = "PBEWithMD5AndDES";
    public static final String PBE_MD5_RC2_KEY = "PBEWithMD5AndRC2";
    public static final String PBE_SHA1_RC2_KEY = "PBEWithSHA1AndRC2";
    public static final String PBE_SHA1_DES_KEY = "PBEWithSHA1AndDES";
    public static final String PBE_2KEY = "PBEWITHSHAAND2-KEYTRIPLEDES-CBC";
    public static final String PBE_3KEY = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final String PBE_40BITRC4KEY = "PBEWITHSHAAND40BITRC4";
    public static final String PBE_128BITRC4KEY = "PBEWITHSHAAND128BITRC4";
    public static final String PBE_MD5_DES = "PBEWithMD5AndDES";
    public static final String PBE_MD5_RC2 = "PBEWithMD5AndRC2";
    public static final String PBE_SHA1_DES = "PBEWithSHA1AndDES";
    public static final String PBE_SHA1_2DES = "PBEWITHSHAAND2-KEYTRIPLEDES-CBC";
    public static final String PBE_SHA1_3DES = "PBEWITHSHAAND3-KEYTRIPLEDES-CBC";
    public static final String PBE_SHA1_RC2 = "PBEWithSHA1AndRC2";
    public static final String PBE_SHA1_40BITRC4 = "PBEWITHSHAAND40BITRC4";
    public static final String PBE_SHA1_128BITRC4 = "PBEWITHSHAAND128BITRC4";
    public static final String MD2 = "MD2";
    public static final String MD4 = "MD4";
    public static final String MD5 = "MD5";
    public static final String RIPEMD128 = "RIPEMD128";
    public static final String RIPEMD160 = "RIPEMD160";
    public static final String RIPEMD256 = "RIPEMD256";
    public static final String SHA1 = "SHA-1";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final String SM3 = "SM3";
    public static final String MD5_RSA = "md5WithRSAEncryption";
    public static final String SHA1_RSA = "sha1WithRSAEncryption";
    public static final String SHA256_RSA = "sha256WithRSAEncryption";
    public static final String SHA384_RSA = "sha384WithRSAEncryption";
    public static final String SHA512_RSA = "sha512WithRSAEncryption";
    public static final String SM3_SM2 = "sm3WithSM2Encryption";
    public static final String SM3_SM2_OLD = "sm3WithSM2Encryption_OLD";
    public static final String MD2_RSA = "md2WithRSAEncryption";
    protected String mechanismType;
    protected Object param;
    protected String curveName;
    public static final String SHA1_ECDSA = "sha1WithECDSAEncryption";
    public static final String SHA256_ECDSA = "sha256WithECDSAEncryption";
    public static final String SHA384_ECDSA = "sha384WithECDSAEncryption";
    public static final String SHA512_ECDSA = "sha512WithECDSAEncryption";
    public static final Map<ASN1ObjectIdentifier, String> OIDALGMap = MechanismKit.buildOidNameMap();
    public static final Map<String, ASN1ObjectIdentifier> ALGOIDMap = MechanismKit.buildNameOidMap();
    private static final Map<String, String> SIGNALGMAPPINGS = MechanismKit.buildSignAlgMap();

    public MechanismKit(String mechanismType, Object param, String curveName) {
        this.mechanismType = mechanismType;
        this.param = param;
        this.curveName = curveName;
    }

    public MechanismKit(String mechanismType, Object param) {
        this.mechanismType = mechanismType;
        this.param = param;
    }

    public MechanismKit(String mechanismType) {
        this.mechanismType = mechanismType;
        this.param = null;
    }

    public String getMechanismType() {
        return this.mechanismType;
    }

    public Object getParam() {
        return this.param;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    public void setMechanismType(String mechanismType) {
        this.mechanismType = mechanismType;
    }

    public String getCurveName() {
        return this.curveName;
    }

    public void setCurveName(String curveName) {
        this.curveName = curveName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mechanismType == null ? 0 : this.mechanismType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MechanismKit other = (MechanismKit)obj;
        return !(this.mechanismType == null ? other.mechanismType != null : !this.mechanismType.equalsIgnoreCase(other.mechanismType));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Mechanism [mechanism=");
        builder.append(this.mechanismType);
        builder.append(", param=");
        builder.append(this.param);
        builder.append(", curveName=");
        builder.append(this.curveName);
        builder.append("]");
        return builder.toString();
    }

    public static boolean isDigestAlgorithmValid(String digestAlgorithm) {
        return Mechanisms.isValidDigestAlgorithm(digestAlgorithm);
    }

    private static Map<ASN1ObjectIdentifier, String> buildOidNameMap() {
        ConcurrentHashMap<ASN1ObjectIdentifier, String> OIDALGMap = new ConcurrentHashMap<ASN1ObjectIdentifier, String>(16);
        OIDALGMap.put(GMTPKCSObjectIdentifiers.md5WithRSAEncryption, MD5_RSA);
        OIDALGMap.put(GMTPKCSObjectIdentifiers.sha1WithRSAEncryption, SHA1_RSA);
        OIDALGMap.put(GMTPKCSObjectIdentifiers.sha256WithRSAEncryption, SHA256_RSA);
        OIDALGMap.put(GMTPKCSObjectIdentifiers.sha384WithRSAEncryption, SHA384_RSA);
        OIDALGMap.put(GMTPKCSObjectIdentifiers.sha512WithRSAEncryption, SHA512_RSA);
        OIDALGMap.put(GMTX9ObjectIdentifiers.sm3WithSM2Encryption, SM3_SM2);
        OIDALGMap.put(GMTX9ObjectIdentifiers.sm3WithSM2Encryption_OLD, SM3_SM2_OLD);
        OIDALGMap.put(GMTX9ObjectIdentifiers.ecdsa_with_SHA256, SHA256_ECDSA);
        OIDALGMap.put(GMTX9ObjectIdentifiers.ecdsa_with_SHA384, SHA384_ECDSA);
        OIDALGMap.put(GMTX9ObjectIdentifiers.ecdsa_with_SHA512, SHA512_ECDSA);
        OIDALGMap.put(GMTX9ObjectIdentifiers.ecdsa_with_SHA1, SHA1_ECDSA);
        return Collections.unmodifiableMap(OIDALGMap);
    }

    private static Map<String, ASN1ObjectIdentifier> buildNameOidMap() {
        ConcurrentHashMap<String, ASN1ObjectIdentifier> ALGOIDMap = new ConcurrentHashMap<String, ASN1ObjectIdentifier>(16);
        ALGOIDMap.put(MD5_RSA, GMTPKCSObjectIdentifiers.md5WithRSAEncryption);
        ALGOIDMap.put(SHA1_RSA, GMTPKCSObjectIdentifiers.sha1WithRSAEncryption);
        ALGOIDMap.put(SHA256_RSA, GMTPKCSObjectIdentifiers.sha256WithRSAEncryption);
        ALGOIDMap.put(SHA384_RSA, GMTPKCSObjectIdentifiers.sha384WithRSAEncryption);
        ALGOIDMap.put(SHA512_RSA, GMTPKCSObjectIdentifiers.sha512WithRSAEncryption);
        ALGOIDMap.put(SM3_SM2, GMTX9ObjectIdentifiers.sm3WithSM2Encryption);
        ALGOIDMap.put(SM3_SM2_OLD, GMTX9ObjectIdentifiers.sm3WithSM2Encryption_OLD);
        ALGOIDMap.put(SHA1_ECDSA, GMTX9ObjectIdentifiers.ecdsa_with_SHA1);
        ALGOIDMap.put(SHA256_ECDSA, GMTX9ObjectIdentifiers.ecdsa_with_SHA256);
        ALGOIDMap.put(SHA384_ECDSA, GMTX9ObjectIdentifiers.ecdsa_with_SHA384);
        ALGOIDMap.put(SHA512_ECDSA, GMTX9ObjectIdentifiers.ecdsa_with_SHA512);
        return Collections.unmodifiableMap(ALGOIDMap);
    }

    private static Map<String, String> buildSignAlgMap() {
        ConcurrentHashMap<String, String> signAlgMappings = new ConcurrentHashMap<String, String>(32);
        signAlgMappings.put("MD2WITHRSAENCRYPTION", "MD2withRSAEncryption");
        signAlgMappings.put("MD5WITHRSAENCRYPTION", "MD5withRSAEncryption");
        signAlgMappings.put("SHA1WITHRSAENCRYPTION", "SHA1withRSAEncryption");
        signAlgMappings.put("SHA256WITHRSAENCRYPTION", "SHA256withRSAEncryption");
        signAlgMappings.put("SHA384WITHRSAENCRYPTION", "SHA384withRSAEncryption");
        signAlgMappings.put("SHA512WITHRSAENCRYPTION", "SHA512withRSAEncryption");
        signAlgMappings.put("SM3WITHSM2ENCRYPTION", "SM3withSM2");
        signAlgMappings.put("SM3WITHSM2ENCRYPTION_OLD", "SM3withSM2");
        signAlgMappings.put("SM3WITHSM2", "SM3withSM2");
        signAlgMappings.put("SHA1WITHECDSAENCRYPTION", "SHA1withECDSAEncryption");
        signAlgMappings.put("SHA256WITHECDSAENCRYPTION", "SHA256withECDSAEncryption");
        signAlgMappings.put("SHA384WITHECDSAENCRYPTION", "SHA384withECDSAEncryption");
        signAlgMappings.put("SHA512WITHECDSAENCRYPTION", "SHA512withECDSAEncryption");
        signAlgMappings.put("RSAWITHMD2ENCRYPTION", "MD2withRSAEncryption");
        signAlgMappings.put("RSAWITHMD5ENCRYPTION", "MD5withRSAEncryption");
        signAlgMappings.put("RSAWITHSHA1ENCRYPTION", "SHA1withRSAEncryption");
        signAlgMappings.put("RSAWITHSHA256ENCRYPTION", "SHA256withRSAEncryption");
        signAlgMappings.put("RSAWITHSHA384ENCRYPTION", "SHA384withRSAEncryption");
        signAlgMappings.put("RSAWITHSHA512ENCRYPTION", "SHA512withRSAEncryption");
        signAlgMappings.put("SM2WITHSM3ENCRYPTION", "SM3withSM2");
        signAlgMappings.put("SM2WITHSM3ENCRYPTION_OLD", "SM3withSM2");
        signAlgMappings.put("SM2WITHSM3", "SM3withSM2");
        signAlgMappings.put("ECDSAWITHSHA1ENCRYPTION", "SHA1withECDSAEncryption");
        signAlgMappings.put("ECDSAWITHSHA256ENCRYPTION", "SHA256withECDSAEncryption");
        signAlgMappings.put("ECDSAWITHSHA384ENCRYPTION", "SHA384withECDSAEncryption");
        signAlgMappings.put("ECDSAWITHSHA512ENCRYPTION", "SHA512withECDSAEncryption");
        return Collections.unmodifiableMap(signAlgMappings);
    }

    public static boolean isValid(MechanismKit signAlg) {
        boolean valid = false;
        valid = signAlg != null && signAlg.getMechanismType() != null ? SIGNALGMAPPINGS.containsKey(signAlg.getMechanismType().toUpperCase()) : false;
        return valid;
    }

    public static String getSignatureAlgName(AlgorithmIdentifier signatureAlgorithm) {
        ASN1ObjectIdentifier oid = signatureAlgorithm.getAlgorithm();
        String sigAlgName = OIDALGMap.get(oid);
        if (sigAlgName == null) {
            sigAlgName = oid.getId();
        }
        return sigAlgName;
    }

    public static boolean isValid(AlgorithmIdentifier signatureAlgorithm) {
        ASN1ObjectIdentifier oid = signatureAlgorithm.getAlgorithm();
        return OIDALGMap.containsKey(oid);
    }

    public static ASN1ObjectIdentifier getObjectIdentifier(String signatureAlgorithm) {
        return ALGOIDMap.get(signatureAlgorithm);
    }
}

