/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.ASN1TaggedObject;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.pkcs.IssuerAndSerialNumber;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import com.ygsoft.abc.mapp.ygca.algorithm.common.ASN1SM2Signature;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2ContextConfig;
import java.io.IOException;
import java.util.Enumeration;

public class SM2SignerInfo
extends ASN1Object {
    private ASN1Integer version;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private AlgorithmIdentifier digAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digEncryptionAlgorithm;
    private ASN1Integer encryptedDigestR;
    private ASN1Integer encryptedDigestS;
    private ASN1Set unauthenticatedAttributes;

    public static SM2SignerInfo getInstance(Object o) {
        if (o instanceof SM2SignerInfo) {
            return (SM2SignerInfo)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new SM2SignerInfo((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o.getClass().getName());
    }

    public SM2SignerInfo(ASN1Integer version, IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmIdentifier digAlgorithm, ASN1Set authenticatedAttributes, AlgorithmIdentifier digEncryptionAlgorithm, ASN1Integer encryptedDigestR, ASN1Integer encryptedDigestS, ASN1Set unauthenticatedAttributes) {
        this.version = version;
        this.issuerAndSerialNumber = issuerAndSerialNumber;
        this.digAlgorithm = digAlgorithm;
        this.authenticatedAttributes = authenticatedAttributes;
        this.digEncryptionAlgorithm = digEncryptionAlgorithm;
        this.encryptedDigestR = encryptedDigestR;
        this.encryptedDigestS = encryptedDigestS;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
    }

    public SM2SignerInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (ASN1Integer)e.nextElement();
        this.issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(e.nextElement());
        this.digAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        Object obj = e.nextElement();
        if (obj instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)obj), (boolean)false);
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digEncryptionAlgorithm = AlgorithmIdentifier.getInstance(obj);
        }
        Object o = e.nextElement();
        if (o instanceof ASN1Sequence) {
            ASN1Sequence rsSequnence = (ASN1Sequence)o;
            Enumeration eRS = rsSequnence.getObjects();
            this.encryptedDigestR = ASN1Integer.getInstance(eRS.nextElement());
            this.encryptedDigestS = ASN1Integer.getInstance(eRS.nextElement());
        } else if (o instanceof ASN1OctetString) {
            byte[] value = ((ASN1OctetString)o).getOctets();
            ASN1SM2Signature signValue = new ASN1SM2Signature(value);
            this.encryptedDigestR = signValue.getR();
            this.encryptedDigestS = signValue.getS();
        } else {
            this.encryptedDigestR = (ASN1Integer)o;
            this.encryptedDigestS = (ASN1Integer)e.nextElement();
        }
        this.unauthenticatedAttributes = e.hasMoreElements() ? ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)e.nextElement()), (boolean)false) : null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digAlgorithm;
    }

    public ASN1Integer getEncryptedDigestR() {
        return this.encryptedDigestR;
    }

    public ASN1Integer getEncryptedDigestS() {
        return this.encryptedDigestS;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digEncryptionAlgorithm;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.issuerAndSerialNumber);
        v.add((ASN1Encodable)this.digAlgorithm);
        if (this.authenticatedAttributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.authenticatedAttributes));
        }
        v.add((ASN1Encodable)this.digEncryptionAlgorithm);
        int signFormat = SM2ContextConfig.getSignFormat();
        if (3 == signFormat) {
            ASN1EncodableVector rsV = new ASN1EncodableVector();
            rsV.add((ASN1Encodable)this.encryptedDigestR);
            rsV.add((ASN1Encodable)this.encryptedDigestS);
            DERSequence rsSequence = new DERSequence(rsV);
            try {
                DEROctetString rsStr = new DEROctetString((ASN1Encodable)rsSequence);
                v.add((ASN1Encodable)rsStr);
            }
            catch (IOException var6) {
                throw new SecurityException("SM2SignerFile Encoded Failure: " + var6.getMessage());
            }
        } else if (2 == signFormat) {
            ASN1EncodableVector rsV = new ASN1EncodableVector();
            rsV.add((ASN1Encodable)this.encryptedDigestR);
            rsV.add((ASN1Encodable)this.encryptedDigestS);
            DERSequence rsSequence = new DERSequence(rsV);
            v.add((ASN1Encodable)rsSequence);
        } else if (1 == signFormat) {
            v.add((ASN1Encodable)this.encryptedDigestR);
            v.add((ASN1Encodable)this.encryptedDigestS);
        }
        if (this.unauthenticatedAttributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.unauthenticatedAttributes));
        }
        return new DERSequence(v);
    }
}

