/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.util;

import cn.org.bjca.gaia.asn1.ASN1Integer;
import java.math.BigInteger;
import java.security.SecureRandom;

public class BigIntegerKit {
    private static final int MAX_ITERATIONS = 1000;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    public static byte[] asUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] asUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static BigInteger createRandomInRange(BigInteger min, BigInteger max, SecureRandom random) {
        int cmp = min.compareTo(max);
        if (cmp >= 0) {
            if (cmp > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return min;
        }
        if (min.bitLength() > max.bitLength() / 2) {
            return BigIntegerKit.createRandomInRange(ZERO, max.subtract(min), random).add(min);
        }
        for (int i = 0; i < 1000; ++i) {
            BigInteger x = new BigInteger(max.bitLength(), random);
            if (x.compareTo(min) < 0 || x.compareTo(max) > 0) continue;
            return x;
        }
        return new BigInteger(max.subtract(min).bitLength() - 1, random).add(min);
    }

    public static final BigInteger fromUnsignedByteArray(byte[] buf) {
        if (buf == null) {
            throw new IllegalArgumentException("null not allowed for buf");
        }
        return new BigInteger(1, buf);
    }

    public static final BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        if (buf != null && buf.length >= off) {
            if (buf.length < off + length) {
                length = buf.length - off;
            }
            byte[] value = new byte[length];
            System.arraycopy(buf, off, value, 0, value.length);
            return new BigInteger(1, value);
        }
        throw new IllegalArgumentException("null/length not allowed for buf");
    }

    public static final ASN1Integer fromByteArray(byte[] bytes, int length) {
        byte[] encoding;
        if (bytes == null) {
            throw new IllegalArgumentException("missing argument#bytes");
        }
        int bytesLength = bytes.length;
        if (bytesLength < length) {
            encoding = new byte[length];
            int zeroLength = length - bytesLength;
            for (int i = 0; i < zeroLength; ++i) {
                encoding[i] = 0;
            }
            System.arraycopy(bytes, 0, encoding, zeroLength, bytesLength);
        } else if (bytes[0] < 0) {
            encoding = new byte[bytesLength + 1];
            encoding[0] = 0;
            System.arraycopy(bytes, 0, encoding, 1, bytesLength);
        } else {
            encoding = bytes;
        }
        return new ASN1Integer(encoding);
    }

    public static ASN1Integer formatXYRS(ASN1Integer derV) {
        if (derV == null) {
            throw new IllegalArgumentException("SM2 changedXYRS required X/Y/R/S not null");
        }
        BigInteger value = derV.getPositiveValue();
        int bitLength = value.bitLength();
        if (bitLength > 256) {
            throw new IllegalArgumentException("SM2 changedXYRS required X/Y/R/S bitLength<=256");
        }
        ASN1Integer derR = bitLength < 249 ? BigIntegerKit.fromByteArray(value.toByteArray(), 32) : (bitLength == 256 ? BigIntegerKit.fromByteArray(value.toByteArray(), 32) : derV);
        return derR;
    }

    public static BigInteger toPositiveInteger(byte[] in) {
        if (in == null) {
            return null;
        }
        byte[] bt = null;
        if (in[0] < 0) {
            bt = new byte[in.length + 1];
            bt[0] = 0;
            System.arraycopy(in, 0, bt, 1, bt.length - 1);
        } else {
            bt = in;
        }
        return new BigInteger(bt);
    }

    public static byte[] asUnsigned32ByteArray(BigInteger n) {
        return BigIntegerKit.asUnsignedNByteArray(n, 32);
    }

    public static byte[] asUnsignedNByteArray(BigInteger x, int length) {
        if (x == null) {
            return null;
        }
        byte[] tmp = new byte[length];
        byte[] arrays = x.toByteArray();
        int len = arrays.length;
        if (len > length + 1) {
            return null;
        }
        if (len == length + 1) {
            if (arrays[0] != 0) {
                return null;
            }
            System.arraycopy(arrays, 1, tmp, 0, length);
            return tmp;
        }
        System.arraycopy(arrays, 0, tmp, length - len, len);
        return tmp;
    }
}

