/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.crypto;

import cn.org.bjca.gaia.jce.interfaces.ECPublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanism;
import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanisms;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PrivateKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.util.HashEncoderUtil;
import com.ygsoft.abc.mapp.ygca.algorithm.util.KeyUtil;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseLib {
    public final KeyPair generateKeyPair(Mechanism mechanism, int bitLength) {
        try {
            KeyPair keypair;
            if (mechanism == null) {
                throw new RuntimeException("GenerateKeyPair failure with missing mechanism");
            }
            if (Mechanisms.isSM2Type(mechanism)) {
                keypair = this.SM2GenerateKeyPair();
            } else if (Mechanisms.isRSAType(mechanism)) {
                keypair = this.RSAGenerateKeyPair(bitLength);
            } else {
                if (!Mechanisms.isECDSA(mechanism)) {
                    throw new RuntimeException("GenerateKeyPair failure with invalid keyType=" + mechanism.getMechanismType());
                }
                keypair = this.ECCGenerateKeyPair(mechanism);
            }
            return keypair;
        }
        catch (Exception var5) {
            throw new RuntimeException("GenerateKeyPair failure with exception: " + var5.getMessage(), var5);
        }
    }

    public final Key generateKey(Mechanism mechanism) {
        try {
            if (mechanism == null) {
                throw new RuntimeException("GenerateKey failure with missing mechanism");
            }
            String type = mechanism.getMechanismType();
            SecureRandom random = new SecureRandom();
            SecretKeySpec key = null;
            if ("SM4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("DESede".equals(type)) {
                byte[] keyData = new byte[24];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else {
                if (!"RC4".equals(type)) {
                    throw new RuntimeException("GenerateKey failure with invalid keyType=" + mechanism.getMechanismType());
                }
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            }
            return key;
        }
        catch (Exception var7) {
            throw new RuntimeException("GenerateKey failure with exception: " + var7.getMessage(), var7);
        }
    }

    public final Key generateKey(Mechanism mechanism, byte[] keyData) {
        try {
            if (mechanism == null) {
                throw new RuntimeException("GenerateKey failure with missing mechanism");
            }
            Key key = KeyUtil.generateKey(mechanism, keyData);
            return key;
        }
        catch (Exception var5) {
            throw new RuntimeException("GenerateKey failure with exception: " + var5.getMessage(), var5);
        }
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) {
        try {
            if (mechanism == null) {
                throw new RuntimeException("verify failure with missing mechanism");
            }
            if (pubKey == null) {
                throw new RuntimeException("verify failure with missing PublicKey");
            }
            if (sourceData == null) {
                throw new RuntimeException("verify failure with missing sourceData");
            }
            if (signData == null) {
                throw new RuntimeException("verify failure with missing signData");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new RuntimeException("verify failure with invalid mechanism=" + mechanism);
            }
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                byte[] hash = this.SM2HashMessage(sm2PubKey, sourceData, true);
                verifyResult = this.SM2VerifyHash(sm2PubKey, hash, signData);
                boolean compatibleWithoutZ = true;
                if (compatibleWithoutZ && !verifyResult) {
                    hash = this.SM2HashMessage(sm2PubKey, sourceData, false);
                    verifyResult = this.SM2VerifyHash(sm2PubKey, hash, signData);
                }
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(pubKey instanceof ECPublicKey)) {
                    throw new RuntimeException("verify failure pubKey is not supported: " + pubKey.getClass());
                }
                byte[] hash = this.RSAHashMessage(mechanism, sourceData, false);
                verifyResult = this.ECDSAVerifyHash(pubKey, hash, signData, mechanism);
            } else {
                byte[] hash = this.RSAHashMessage(mechanism, sourceData);
                verifyResult = this.RSAVerifyHash(pubKey, hash, signData);
            }
            return verifyResult;
        }
        catch (Exception var10) {
            throw new RuntimeException("sign failure with exception: " + var10.getMessage(), var10);
        }
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) {
        try {
            if (mechanism == null) {
                throw new RuntimeException("verify failure with missing mechanism");
            }
            if (pubKey == null) {
                throw new RuntimeException("verify failure with missing PublicKey");
            }
            if (sourceStream == null) {
                throw new RuntimeException("verify failure with missing sourceStream");
            }
            if (signData == null) {
                throw new RuntimeException("verify failure with missing signData");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new RuntimeException("verify failure with invalid mechanism=" + mechanism);
            }
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                boolean compatibleWithoutZ = true;
                byte[] hashWithZ = new byte[32];
                byte[] hashWithoutZ = new byte[32];
                this.SM2HashFile(sm2PubKey, compatibleWithoutZ, sourceStream, hashWithZ, hashWithoutZ);
                verifyResult = this.SM2VerifyHash(sm2PubKey, hashWithZ, signData);
                hashWithZ = null;
                if (compatibleWithoutZ && !verifyResult) {
                    verifyResult = this.SM2VerifyHash(sm2PubKey, hashWithoutZ, signData);
                }
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(pubKey instanceof ECPublicKey)) {
                    throw new RuntimeException("verify failure pubKey is not supported: " + pubKey.getClass());
                }
                byte[] hashWithoutAlgorithm = this.RSAHashFile(mechanism, sourceStream, false);
                verifyResult = this.ECDSAVerifyHash(pubKey, hashWithoutAlgorithm, signData, mechanism);
            } else {
                byte[] hashWithoutAlgorithm = this.RSAHashFile(mechanism, sourceStream);
                verifyResult = this.RSAVerifyHash(pubKey, hashWithoutAlgorithm, signData);
            }
            return verifyResult;
        }
        catch (Exception var11) {
            throw new RuntimeException("sign failure with exception: " + var11.getMessage(), var11);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hashValue, byte[] signValue) {
        try {
            if (mechanism == null) {
                throw new RuntimeException("verifyByHash failure with missing mechanism");
            }
            if (pubKey == null) {
                throw new RuntimeException("verifyByHash failure with missing PublicKey");
            }
            if (hashValue == null) {
                throw new RuntimeException("verifyByHash failure with missing hashValue");
            }
            if (signValue == null) {
                throw new RuntimeException("verifyByHash failure with missing signValue");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new RuntimeException("verifyByHash failure with invalid mechanism=" + mechanism);
            }
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                verifyResult = this.SM2VerifyHash(sm2PubKey, hashValue, signValue);
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(pubKey instanceof ECPublicKey)) {
                    throw new RuntimeException("verifyByHash failure pubKey is not supported: " + pubKey.getClass());
                }
                verifyResult = this.ECDSAVerifyHash(pubKey, hashValue, signValue, mechanism);
            } else {
                byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(mechanism, hashValue);
                verifyResult = this.RSAVerifyHash(pubKey, hashWithAlgorithm, signValue);
            }
            System.out.println("verifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
            return verifyResult;
        }
        catch (Exception var8) {
            throw new RuntimeException("verifyByHash failure with exception: " + var8.getMessage(), var8);
        }
    }

    public final Provider getProvider() {
        return null;
    }

    public final String getProviderName() {
        return "YGCA";
    }

    protected final SM2PublicKey SM2PublicKeyFrom(Key key) {
        SM2PublicKey sm2PublicKey = key instanceof SM2PublicKey ? (SM2PublicKey)((Object)key) : new SM2PublicKey(key.getEncoded());
        return sm2PublicKey;
    }

    protected final SM2PrivateKey SM2PrivateKeyFrom(Key key) {
        SM2PrivateKey sm2PrivateKey = key instanceof SM2PrivateKey ? (SM2PrivateKey)((Object)key) : new SM2PrivateKey(key.getEncoded());
        return sm2PrivateKey;
    }

    protected abstract KeyPair SM2GenerateKeyPair();

    protected abstract KeyPair RSAGenerateKeyPair(int var1);

    protected abstract KeyPair ECCGenerateKeyPair(Mechanism var1);

    protected abstract byte[] SM2EncryptMessage(SM2PublicKey var1, byte[] var2);

    protected abstract byte[] SM2DecryptMessage(SM2PrivateKey var1, byte[] var2);

    protected abstract byte[] SM2SignHash(SM2PrivateKey var1, byte[] var2);

    protected abstract boolean SM2VerifyHash(SM2PublicKey var1, byte[] var2, byte[] var3);

    protected abstract byte[] SM2HashMessage(SM2PublicKey var1, byte[] var2, boolean var3);

    protected abstract byte[] SM2HashFile(SM2PublicKey var1, InputStream var2, boolean var3);

    protected abstract byte[] RSAEncryptMessage(PublicKey var1, byte[] var2);

    protected abstract byte[] RSADecryptMessage(PrivateKey var1, byte[] var2);

    protected abstract byte[] RSASignHash(PrivateKey var1, byte[] var2);

    protected abstract boolean RSAVerifyHash(PublicKey var1, byte[] var2, byte[] var3);

    protected abstract byte[] RSAHashMessage(Mechanism var1, byte[] var2);

    protected abstract byte[] RSAHashMessage(Mechanism var1, byte[] var2, boolean var3);

    protected abstract byte[] RSAHashFile(Mechanism var1, InputStream var2);

    protected abstract byte[] RSAHashFile(Mechanism var1, InputStream var2, boolean var3);

    protected abstract byte[] SM4EncryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] SM4DecryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] RC4EncryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] RC4DecryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] DESedeEncryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] DESedeDecryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] AESEncryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract byte[] AESDecryptMessage(Mechanism var1, Key var2, byte[] var3);

    protected abstract void SM2HashFile(SM2PublicKey var1, boolean var2, InputStream var3, byte[] var4, byte[] var5);

    protected abstract byte[] ECDSASignHash(PrivateKey var1, byte[] var2, Mechanism var3);

    protected abstract boolean ECDSAVerifyHash(PublicKey var1, byte[] var2, byte[] var3, Mechanism var4);

    protected abstract byte[] ECCEncryptMessage(PublicKey var1, byte[] var2);

    protected abstract byte[] ECCDecryptMessage(PrivateKey var1, byte[] var2);

    public boolean checkIdleTest() {
        return true;
    }
}

