/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.factory;

import com.ygsoft.abc.mapp.ygca.gwcw.common.config.ConfigTool;
import com.ygsoft.abc.mapp.ygca.gwcw.common.config.VerifyConfig;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.BizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.impl.service.HttpSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizSignatureServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BizSignatureServiceFactory.class);
    private static IBizSignatureService sdkSignatureService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBizSignatureService getInstance(VerifyConfig verifyConfig) {
        String verifyType = verifyConfig.getVerifyType();
        if (ConfigTool.VERIFY_SERVER.equals(verifyType)) {
            String serverUrl = BizSignatureServiceFactory.getServerUrl(verifyConfig.getServerUrl());
            LOG.info("verify serverUrl:" + serverUrl);
            if (!serverUrl.equals(ConfigTool.SERVER_VIP_ADDRESS_01) && !serverUrl.equals(ConfigTool.SERVER_VIP_ADDRESS_02) && !serverUrl.equals(ConfigTool.SERVER_VIP_ADDRESS_03)) return new HttpSignatureService(serverUrl, HttpSignatureService.httpRemoteClient);
            return new HttpSignatureService(serverUrl, HttpSignatureService.mappRemoteClient);
        }
        if (!ConfigTool.VERIFY_SDK.equals(verifyType)) throw new IllegalArgumentException("\u975e\u6cd5\u9a8c\u7b7e\u8ba4\u8bc1\u65b9\u5f0f");
        if (sdkSignatureService != null) return sdkSignatureService;
        Class<BizSignatureServiceFactory> clazz = BizSignatureServiceFactory.class;
        synchronized (BizSignatureServiceFactory.class) {
            if (sdkSignatureService != null) return sdkSignatureService;
            sdkSignatureService = BizSignatureServiceFactory.createSdkSignatureService();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return sdkSignatureService;
        }
    }

    private static String getServerUrl(String serverUrl) {
        if (StringUtil.isEmpty(serverUrl)) {
            throw new RuntimeException("serverUrl\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String url = serverUrl.trim();
        if (StringUtil.isEmpty(url)) {
            throw new RuntimeException("serverUrl\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static IBizSignatureService createSdkSignatureService() {
        try {
            Class<?> clazz = Class.forName("org.dom4j.DocumentHelper");
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("parseText", String.class);
                method.invoke(null, "<members></members>");
                LOG.info("DocumentHelper.parseText..");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("createSdkSignatureService error", e);
        }
        return new BizSignatureService();
    }
}

