/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public final class HttpClientUtils {
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final int HTTP_STATUS_SUCCESS = 200;
    public static final int HTTP_STATUS_FAILURE = 500;
    public static final String CHARSET = "UTF-8";

    private HttpClientUtils() {
    }

    public static String doGet(String url, List<NameValuePair> queryParams, List<Header> headerParams) throws IOException {
        HttpClient client = new HttpClient();
        HttpMethod httpMethod = HttpClientUtils.createHttpMethod(url, HTTP_METHOD_GET, queryParams, null, headerParams, null);
        int code = client.executeMethod(httpMethod);
        if (code != 200) {
            throw new IllegalArgumentException(String.format("the http status code: %d is wrong!", code));
        }
        String result = httpMethod.getResponseBodyAsString();
        httpMethod.releaseConnection();
        return result;
    }

    public static String doPostForm(String url, List<NameValuePair> queryParams, List<Header> headerParams, List<NameValuePair> formParams) throws IOException {
        HttpClient client = new HttpClient();
        HttpMethod httpMethod = HttpClientUtils.createHttpMethod(url, HTTP_METHOD_POST, queryParams, formParams, headerParams, null);
        int code = client.executeMethod(httpMethod);
        if (code != 200) {
            throw new IllegalArgumentException(String.format("the http status code: %d is wrong!", code));
        }
        String data = httpMethod.getResponseBodyAsString();
        httpMethod.releaseConnection();
        return data;
    }

    public static String doPostJson(String url, List<NameValuePair> queryParams, String body, List<Header> headerParams, String chartSet) throws IOException {
        HttpClient client = new HttpClient();
        String contentType = "application/json;charset=UTF-8";
        StringRequestEntity entity = new StringRequestEntity(body, "application/json;charset=UTF-8", CHARSET);
        HttpMethod httpMethod = HttpClientUtils.createHttpMethod(url, HTTP_METHOD_POST, queryParams, null, headerParams, (RequestEntity)entity);
        int code = client.executeMethod(httpMethod);
        String data = null;
        data = chartSet == null || "".equals(chartSet) ? httpMethod.getResponseBodyAsString() : new String(httpMethod.getResponseBody(), chartSet);
        if (code != 200) {
            throw new IllegalArgumentException(String.format("the http status code: %d is wrong! the response: %s", code, data));
        }
        httpMethod.releaseConnection();
        return data;
    }

    public static HttpMethod createHttpMethod(String uri, String httpMethod, List<NameValuePair> queryParams, List<NameValuePair> formParams, List<Header> headerParams, RequestEntity body) {
        if (httpMethod.equalsIgnoreCase(HTTP_METHOD_GET)) {
            return HttpClientUtils.createGetMethod(uri, queryParams, headerParams);
        }
        if (httpMethod.equalsIgnoreCase(HTTP_METHOD_POST)) {
            return HttpClientUtils.createPostMethod(uri, queryParams, formParams, headerParams, body);
        }
        throw new IllegalArgumentException(String.format("un supported http method: %s", httpMethod));
    }

    private static HttpMethod createGetMethod(String uri, List<NameValuePair> queryParams, List<Header> headerParams) {
        if (uri == null || "".equals(uri)) {
            throw new IllegalArgumentException("\u53d1\u9001GET\u8bf7\u6c42\u5f02\u5e38,\u53c2\u6570url\u4e3anull\u6216\u7a7a");
        }
        String fullUrl = HttpClientUtils.buildFullUrl(uri, queryParams);
        GetMethod getMethod = new GetMethod(fullUrl);
        if (headerParams != null && headerParams.size() > 0) {
            for (Header header : headerParams) {
                getMethod.addRequestHeader(header);
            }
        }
        return getMethod;
    }

    private static HttpMethod createPostMethod(String uri, List<NameValuePair> queryParams, List<NameValuePair> formParams, List<Header> headerParams, RequestEntity body) {
        if (uri == null || "".equals(uri)) {
            throw new IllegalArgumentException("\u53d1\u9001POST\u8bf7\u6c42\u5f02\u5e38,\u53c2\u6570url\u4e3anull\u6216\u7a7a");
        }
        String fullUrl = HttpClientUtils.buildFullUrl(uri, queryParams);
        Utf8PostMethod postMethod = new Utf8PostMethod(fullUrl);
        if (formParams != null && formParams.size() != 0) {
            NameValuePair[] nvs = new NameValuePair[formParams.size()];
            for (int i = 0; i < formParams.size(); ++i) {
                nvs[i] = formParams.get(i);
            }
            postMethod.setRequestBody(nvs);
        } else if (body != null) {
            postMethod.setRequestEntity(body);
        }
        if (headerParams != null && !headerParams.isEmpty()) {
            for (Header header : headerParams) {
                postMethod.addRequestHeader(header);
            }
        }
        return postMethod;
    }

    private static String buildFullUrl(String uri, List<NameValuePair> queryParams) {
        String targetUrl = uri;
        if (queryParams != null && queryParams.size() > 0) {
            String queryString = HttpClientUtils.buildQueryString(queryParams);
            targetUrl = targetUrl.indexOf("?") > -1 ? targetUrl + queryString : targetUrl + "?" + queryString.substring(1);
        }
        return targetUrl;
    }

    private static String buildQueryString(List<NameValuePair> queryParams) {
        if (queryParams == null || queryParams.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (NameValuePair nameValuePair : queryParams) {
            try {
                sb.append("&").append(nameValuePair.getName()).append("=").append(URLEncoder.encode(nameValuePair.getValue(), CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return sb.toString();
    }

    static final class Utf8PostMethod
    extends PostMethod {
        private Utf8PostMethod(String url) {
            super(url);
        }

        public String getRequestCharSet() {
            return HttpClientUtils.CHARSET;
        }
    }
}

